/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class TranslateContourLabels
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_TABLE = "table";
    public static final String OUTPUT_CONTOURS = "contours";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public TranslateContourLabels() {
        this.setDefaultInputNumbers("contours");
        this.addInputNumbers(INPUT_TABLE);
        this.setDefaultOutputNumbers("contours");
        this.addOutputScalar("number_of_objects");
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public TranslateContourLabels setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)TranslateContourLabels.nonNull((Object)indexingBase);
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        int[] table = this.getInputNumbers(INPUT_TABLE).requireBlockLengthOne(INPUT_TABLE).toIntArray();
        long t1 = TranslateContourLabels.debugTime();
        int start = this.indexingBase.start;
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            int label = contours.getObjectLabel(k) - start;
            if (label < 0 || label >= table.length) continue;
            label = table[label];
            contours.setObjectLabel(k, label);
        }
        long t2 = TranslateContourLabels.debugTime();
        TranslateContourLabels.logDebug(() -> String.format(Locale.US, "%d contour labels translated in %.3f ms", contours.numberOfContours(), (double)(t2 - t1) * 1.0E-6));
        this.getScalar("number_of_objects").setTo(contours.numberOfContours());
        return SNumbers.valueOf((Contours)contours);
    }
}

