/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.List;
import java.util.stream.Stream;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;

public final class AddContoursToArray
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_ADDED = "added";
    public static final String OUTPUT_CONTOURS = "contours";
    private int objectLabel = 1;
    private boolean internalContour = false;
    private String points = "";

    public AddContoursToArray() {
        super(new String[]{"contours", INPUT_ADDED});
        this.setDefaultOutputNumbers("contours");
        this.addOutputScalar("number_of_objects");
    }

    public int getObjectLabel() {
        return this.objectLabel;
    }

    public AddContoursToArray setObjectLabel(int objectLabel) {
        this.objectLabel = objectLabel;
        return this;
    }

    public boolean isInternalContour() {
        return this.internalContour;
    }

    public AddContoursToArray setInternalContour(boolean internalContour) {
        this.internalContour = internalContour;
        return this;
    }

    public String getPoints() {
        return this.points;
    }

    public AddContoursToArray setPoints(String points) {
        this.points = (String)AddContoursToArray.nonNull((Object)points);
        return this;
    }

    protected SNumbers processNumbers(List<SNumbers> sources) {
        Contours contours;
        SNumbers source = sources.get(0);
        SNumbers added = sources.get(1);
        Contours contours2 = contours = source != null ? Contours.deserialize((int[])source.toIntArray()) : Contours.newInstance();
        if (added != null) {
            int[] contourData = added.toIntArray();
            if (Contours.isSerializedContours((int[])contourData)) {
                contours.addContours(Contours.deserialize((int[])contourData));
            } else {
                contours.addContour(new ContourHeader(this.objectLabel, this.internalContour), contourData);
            }
        } else {
            for (int[] points : AddContoursToArray.parseContours(this.points)) {
                contours.addContour(new ContourHeader(this.objectLabel, this.internalContour), points);
            }
        }
        this.getScalar("number_of_objects").setTo(contours.numberOfContours());
        return SNumbers.valueOf((Contours)contours);
    }

    protected boolean allowAllUninitializedInputs() {
        return true;
    }

    protected boolean numberOfBlocksEqualityRequired() {
        return false;
    }

    protected boolean blockLengthEqualityRequired() {
        return false;
    }

    private static int[][] parseContours(String scalar) {
        if ((scalar = scalar.trim()).isEmpty()) {
            return new int[0][];
        }
        return (int[][])Stream.of(scalar.split(";")).map(AddContoursToArray::parseSingleContour).toArray(x$0 -> new int[x$0][]);
    }

    private static int[] parseSingleContour(String scalar) {
        return Stream.of(scalar.trim().split("[,\\s]+")).map(String::trim).mapToInt(Integer::parseInt).toArray();
    }
}

