/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.slopes;

import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.misc.slopes.SlopeEmphasizer;

public class MatrixBoundariesEmphasizer {
    private static final boolean OPTIMIZE_DIRECT_ACCESSIBLE = true;
    private final SlopeEmphasizer slopeEmphasizer;
    private int directionToEmphasize = 0;

    private MatrixBoundariesEmphasizer(SlopeEmphasizer slopeEmphasizer) {
        this.slopeEmphasizer = Objects.requireNonNull(slopeEmphasizer, "Null slopeEmphasizer");
    }

    public static MatrixBoundariesEmphasizer getInstance() {
        return MatrixBoundariesEmphasizer.getInstance(SlopeEmphasizer.getInstance());
    }

    public static MatrixBoundariesEmphasizer getInstance(SlopeEmphasizer slopeEmphasizer) {
        return new MatrixBoundariesEmphasizer(slopeEmphasizer);
    }

    public SlopeEmphasizer getSlopeEmphasizer() {
        return this.slopeEmphasizer;
    }

    public int getDirectionToEmphasize() {
        return this.directionToEmphasize;
    }

    public MatrixBoundariesEmphasizer setDirectionToEmphasize(int directionToEmphasize) {
        if (directionToEmphasize < 0) {
            throw new IllegalArgumentException("Negative directionToEmphasize = " + directionToEmphasize);
        }
        this.directionToEmphasize = directionToEmphasize;
        return this;
    }

    public void emphasize(Matrix<? extends UpdatablePArray> matrix) {
        Objects.requireNonNull(matrix, "Null matrix");
        SlopeEmphasizer.ForType emphasizer = this.slopeEmphasizer.forElementType(matrix.elementType());
        int dimCount = matrix.dimCount();
        if (dimCount > 2) {
            throw new IllegalArgumentException("Matrices with more than 2 dimensions are not supported");
        }
        if (this.directionToEmphasize >= dimCount) {
            throw new IllegalArgumentException("Direction to emphasize " + this.directionToEmphasize + " is out of range 0..dimCount-1 = 0.." + (dimCount - 1));
        }
        if (this.tryToEmphasizeDirectAccessible(matrix, emphasizer)) {
            return;
        }
        UpdatablePArray array = (UpdatablePArray)matrix.array();
        long dimDirection = matrix.dim(this.directionToEmphasize);
        if (dimDirection >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large matrix dimension #" + this.directionToEmphasize + ": " + dimDirection);
        }
        int length = (int)dimDirection;
        Object valuesArray = array.newJavaArray((int)dimDirection);
        switch (this.directionToEmphasize) {
            case 0: {
                long y = 0L;
                long dimY = matrix.dimY();
                long p = 0L;
                while (y < dimY) {
                    array.getData(p, valuesArray);
                    emphasizer.emphasize(valuesArray, 0, length);
                    array.setData(p, valuesArray);
                    ++y;
                    p += (long)length;
                }
                break;
            }
            case 1: {
                long dimX = matrix.dimX();
                for (long x = 0L; x < dimX; ++x) {
                    UpdatablePArray column = (UpdatablePArray)matrix.subMatr(x, 0L, 1L, dimDirection).array();
                    column.getData(0L, valuesArray);
                    emphasizer.emphasize(valuesArray, 0, length);
                    column.setData(0L, valuesArray);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Impossible " + this.directionToEmphasize));
            }
        }
    }

    private boolean tryToEmphasizeDirectAccessible(Matrix<? extends UpdatablePArray> matrix, SlopeEmphasizer.ForType emphasizer) {
        DirectAccessible da;
        PArray array = (PArray)matrix.array();
        if (array instanceof DirectAccessible && (da = (DirectAccessible)array).hasJavaArray()) {
            int startOffset = da.javaArrayOffset();
            Object values = da.javaArray();
            int dimX = (int)matrix.dimX();
            int dimY = (int)matrix.dimY();
            switch (this.directionToEmphasize) {
                case 0: {
                    IntStream.range(0, dimY).parallel().forEach(y -> emphasizer.emphasize(values, startOffset + y * dimX, dimX));
                    break;
                }
                case 1: {
                    IntStream.range(0, dimX).parallel().forEach(x -> emphasizer.emphasize(values, startOffset + x, dimY, dimX));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Impossible " + this.directionToEmphasize));
                }
            }
            return true;
        }
        return false;
    }
}

