/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.executors.modules.cv.matrices.morphology.RankMorphologyFilter;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.ContrastingFunc;
import net.algart.math.functions.Func;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.multimatrix.MultiMatrix;

public final class LocalContrast
extends RankMorphologyFilter {
    private double level = 1.0;
    private double minContrastedDifference = 0.1;

    public double getLevel() {
        return this.level;
    }

    public void setLevel(double level) {
        this.level = LocalContrast.inRange((double)level, (double)0.0, (double)1.0);
    }

    public double getMinContrastedDifference() {
        return this.minContrastedDifference;
    }

    public void setMinContrastedDifference(double minContrastedDifference) {
        this.minContrastedDifference = LocalContrast.inRange((double)minContrastedDifference, (double)0.0, (double)1.0);
    }

    public MultiMatrix process(MultiMatrix source) {
        if (this.getPatternSize() == 0) {
            return source;
        }
        List sourceChannels = source.allChannels();
        int numberOfChannels = source.numberOfChannels();
        boolean grayscale = numberOfChannels == 1;
        Matrix intensity = source.intensityChannel();
        double scale = ((PArray)intensity.array()).maxPossibleValue(1.0);
        double minCD = this.minContrastedDifference * scale;
        ContrastingFunc contrastingFunc = ContrastingFunc.getInstance((double)scale, (double)minCD);
        double fromLevel = 0.5 - 0.5 * this.level;
        double toLevel = 0.5 + 0.5 * this.level;
        if (!grayscale) {
            intensity = intensity.matrix((Array)((PArray)intensity.array()).updatableClone((MemoryModel)Arrays.SMM));
        }
        Pattern pattern = this.getPattern((Matrix<? extends PArray>)intensity);
        RankMorphology morphology = this.createRankMorphology(intensity.elementType(), 1.0);
        LocalContrast.logDebug(() -> "Local contrast of range " + fromLevel + ".." + toLevel + ", minContrastedDifference = " + this.minContrastedDifference + this.rankMorphologyLogMessage() + " with " + pattern + (String)(this.getContinuationMode() == null ? "" : ", " + this.getContinuationMode()) + " for " + source);
        double fromPercentileIndex = fromLevel * (double)(pattern.pointCount() - 1L);
        double toPercentileIndex = toLevel * (double)(pattern.pointCount() - 1L);
        Matrix<? extends PArray> contrasted = this.uncompress((Matrix<? extends PArray>)morphology.functionOfPercentilePair(this.compress((Matrix<? extends PArray>)intensity), fromPercentileIndex, toPercentileIndex, pattern, (Func)contrastingFunc));
        if (grayscale) {
            return MultiMatrix.valueOf2DMono(contrasted);
        }
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int currentChannel = 0; currentChannel < numberOfChannels; ++currentChannel) {
            Matrix m = (Matrix)sourceChannels.get(currentChannel);
            AbstractFunc f = new AbstractFunc(){

                public double get(double ... x) {
                    return x[0] * x[1] / x[2];
                }

                public double get(double x0, double x1, double x2) {
                    return x0 * x1 / x2;
                }
            };
            channels.add(Matrices.asFuncMatrix((Func)f, (Class)m.type(PArray.class), (Matrix)m, contrasted, (Matrix)intensity));
        }
        return MultiMatrix.valueOf(channels);
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        return this.process(MultiMatrix.valueOfMono(m)).intensityChannel();
    }

    @Override
    protected Matrix<? extends PArray> processCompressedChannel(Matrix<? extends PArray> m) {
        throw new AssertionError((Object)"Very strange: this method cannot be called!");
    }
}

