/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2017-2023 Daniel Alievsky, AlgART Laboratory (http://algart.net)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.algart.executors.modules.opencv.matrices.objects;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.util.opencv.enums.OThinningAlgorithm;
import org.bytedeco.opencv.opencv_core.*;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.global.opencv_ximgproc;

public final class Thinning extends UMatFilter {
    private OThinningAlgorithm thinningAlgorithm = OThinningAlgorithm.THINNING_ZHANGSUEN;

    public OThinningAlgorithm getThinningAlgorithm() {
        return thinningAlgorithm;
    }

    public void setThinningAlgorithm(OThinningAlgorithm thinningAlgorithm) {
        this.thinningAlgorithm = nonNull(thinningAlgorithm);
    }

    @Override
    public Mat process(Mat source) {
        if (source.channels() > 1) {
            opencv_imgproc.cvtColor(source, source, opencv_imgproc.CV_BGR2GRAY);
        }
        opencv_ximgproc.thinning(source, source, thinningAlgorithm.code());
        return source;
    }

    @Override
    public UMat process(UMat source) {
        if (source.channels() > 1) {
            opencv_imgproc.cvtColor(source, source, opencv_imgproc.CV_BGR2GRAY);
        }
        opencv_ximgproc.thinning(source, source, thinningAlgorithm.code());
        return source;
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }
}
