/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.statistics;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.common.UMatToNumbers;
import net.algart.executors.modules.util.opencv.O2SMat;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_core.UMatVector;

public final class SingleChannelHistogram
extends UMatToNumbers
implements ReadOnlyExecutionInput {
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_HISTOGRAM = "histogram";
    private static Mat EMPTY_MAT = new Mat();
    private static UMat EMPTY_UMAT = new UMat();
    private int channelIndex = 0;
    private int histogramSize = 256;
    private double min = 0.0;
    private double max = 256.0;

    public SingleChannelHistogram() {
        this.addInputMat(INPUT_MASK);
        this.setDefaultOutputNumbers(OUTPUT_HISTOGRAM);
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public SingleChannelHistogram setChannelIndex(int channelIndex) {
        this.channelIndex = SingleChannelHistogram.nonNegative((int)channelIndex);
        return this;
    }

    public int getHistogramSize() {
        return this.histogramSize;
    }

    public SingleChannelHistogram setHistogramSize(int histogramSize) {
        this.histogramSize = SingleChannelHistogram.positive((int)histogramSize);
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public SingleChannelHistogram setMin(double min) {
        this.min = min;
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public SingleChannelHistogram setMax(double max) {
        this.max = max;
        return this;
    }

    @Override
    public SNumbers analyse(Mat source) {
        return this.analyse(source, O2SMat.toMat(this.getInputMat(INPUT_MASK, true), true));
    }

    @Override
    public SNumbers analyse(UMat source) {
        return this.analyse(source, O2SMat.toUMat(this.getInputMat(INPUT_MASK, true), true));
    }

    public SNumbers analyse(Mat source, Mat mask) {
        if (mask == null) {
            mask = EMPTY_MAT;
        }
        try (Mat hist = new Mat();){
            opencv_imgproc.calcHist((Mat)source, (int)1, (int[])new int[]{this.channelIndex}, (Mat)mask, (Mat)hist, (int)1, (int[])new int[]{this.histogramSize}, (float[])new float[]{(float)this.min, (float)this.max}, (boolean)true, (boolean)false);
            SNumbers sNumbers = O2SMat.toRawNumbers(hist, 1);
            return sNumbers;
        }
    }

    public SNumbers analyse(UMat source, UMat mask) {
        if (mask == null) {
            mask = EMPTY_UMAT;
        }
        IntBuffer channels = IntBuffer.wrap(new int[]{this.channelIndex});
        IntBuffer histSize = IntBuffer.wrap(new int[]{this.histogramSize});
        FloatBuffer ranges = FloatBuffer.wrap(new float[]{(float)this.min, (float)this.max});
        try (UMatVector matVector = new UMatVector(source);){
            SNumbers sNumbers;
            try (UMat hist = new UMat();){
                opencv_imgproc.calcHist((UMatVector)matVector, (IntBuffer)channels, (UMat)mask, (UMat)hist, (IntBuffer)histSize, (FloatBuffer)ranges);
                sNumbers = O2SMat.toRawNumbers(hist, 1);
            }
            return sNumbers;
        }
    }
}

