/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OThreshType;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Threshold
extends UMatFilter {
    private Algorithm algorithm = Algorithm.SIMPLE;
    private OThreshType thresholdType = OThreshType.PACKED_BITS;
    private double threshold = 0.5;
    private double maxValue = 1.0;
    private boolean rawValues = false;
    private int gaussianBlurKernelSize = 0;
    private int kernelSize = 5;
    private double k = 0.0;
    private double r = 128.0;
    private boolean convertToByte = false;

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Threshold setAlgorithm(Algorithm algorithm) {
        this.algorithm = (Algorithm)((Object)Threshold.nonNull((Object)((Object)algorithm)));
        return this;
    }

    public OThreshType getThresholdType() {
        return this.thresholdType;
    }

    public Threshold setThresholdType(OThreshType thresholdType) {
        this.thresholdType = (OThreshType)((Object)Threshold.nonNull((Object)((Object)thresholdType)));
        return this;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Threshold setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public Threshold setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public Threshold setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public int getGaussianBlurKernelSize() {
        return this.gaussianBlurKernelSize;
    }

    public Threshold setGaussianBlurKernelSize(int gaussianBlurKernelSize) {
        this.gaussianBlurKernelSize = Threshold.nonNegative((int)gaussianBlurKernelSize);
        return this;
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public Threshold setKernelSize(int kernelSize) {
        this.kernelSize = Threshold.nonNegative((int)kernelSize);
        return this;
    }

    public double getK() {
        return this.k;
    }

    public Threshold setK(double k) {
        this.k = k;
        return this;
    }

    public double getR() {
        return this.r;
    }

    public Threshold setR(double r) {
        this.r = r;
        return this;
    }

    public boolean isConvertToByte() {
        return this.convertToByte;
    }

    public Threshold setConvertToByte(boolean convertToByte) {
        this.convertToByte = convertToByte;
        return this;
    }

    @Override
    public Mat process(Mat source) {
        double scale;
        double d = scale = this.rawValues ? 1.0 : OTools.maxPossibleValue(source);
        if (this.convertToByte && source.depth() != 0) {
            source.convertTo(source, 0, 255.0 / OTools.maxPossibleValue(source), 0.0);
        }
        if (this.algorithm != Algorithm.SIMPLE && source.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)6);
        }
        if (this.gaussianBlurKernelSize > 0) {
            int correctedSize = this.gaussianBlurKernelSize | 1;
            try (Size size = new Size(correctedSize, correctedSize);){
                opencv_imgproc.GaussianBlur((Mat)source, (Mat)source, (Size)size, (double)0.0, (double)0.0, (int)4);
            }
        }
        Mat result = new Mat();
        if (this.algorithm.niblack) {
            opencv_ximgproc.niBlackThreshold((Mat)source, (Mat)result, (double)(this.maxValue * scale), (int)this.thresholdType.code(), (int)(this.kernelSize | 1), (double)this.k, (int)this.algorithm.subMethod, (double)this.r);
        } else if (this.algorithm.adaptive) {
            opencv_imgproc.adaptiveThreshold((Mat)source, (Mat)result, (double)(this.maxValue * scale), (int)this.algorithm.subMethod, (int)this.thresholdType.code(), (int)(this.kernelSize | 1), (double)this.k);
        } else {
            opencv_imgproc.threshold((Mat)source, (Mat)result, (double)(this.threshold * scale), (double)(this.maxValue * scale), (int)(this.thresholdType.code() | this.algorithm.subMethod));
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        double scale;
        double d = scale = this.rawValues ? 1.0 : OTools.maxPossibleValue(source);
        if (this.convertToByte && source.depth() != 0) {
            source.convertTo(source, 0, 255.0 / OTools.maxPossibleValue(source), 0.0);
        }
        if (this.algorithm != Algorithm.SIMPLE && source.channels() > 1) {
            opencv_imgproc.cvtColor((UMat)source, (UMat)source, (int)6);
        }
        if (this.gaussianBlurKernelSize > 0) {
            int correctedSize = this.gaussianBlurKernelSize | 1;
            try (Size size = new Size(correctedSize, correctedSize);){
                opencv_imgproc.GaussianBlur((UMat)source, (UMat)source, (Size)size, (double)0.0, (double)0.0, (int)4);
            }
        }
        UMat result = new UMat();
        if (this.algorithm.niblack) {
            opencv_ximgproc.niBlackThreshold((UMat)source, (UMat)result, (double)(this.maxValue * scale), (int)this.thresholdType.code(), (int)(this.kernelSize | 1), (double)this.k, (int)this.algorithm.subMethod, (double)this.r);
        } else if (this.algorithm.adaptive) {
            opencv_imgproc.adaptiveThreshold((UMat)source, (UMat)result, (double)(this.maxValue * scale), (int)this.algorithm.subMethod, (int)this.thresholdType.code(), (int)(this.kernelSize | 1), (double)this.k);
        } else {
            opencv_imgproc.threshold((UMat)source, (UMat)result, (double)(this.threshold * scale), (double)(this.maxValue * scale), (int)(this.thresholdType.code() | this.algorithm.subMethod));
        }
        return result;
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }

    @Override
    protected boolean packOutputBits() {
        return this.thresholdType.packedBits();
    }

    public static enum Algorithm {
        SIMPLE(0, false, false),
        OTSU(8, false, false),
        TRIANGLE(16, false, false),
        NIBLACK(0, true, false),
        SAUVOLA(1, true, false),
        WOLF(2, true, false),
        NICK(3, true, false),
        ADAPTIVE_MEAN(0, false, true),
        ADAPTIVE_GAUSSIAN_C(1, false, true);

        private final int subMethod;
        private final boolean niblack;
        private final boolean adaptive;

        private Algorithm(int subMethod, boolean niblack, boolean adaptive) {
            this.subMethod = subMethod;
            this.niblack = niblack;
            this.adaptive = adaptive;
        }
    }
}

