/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.IntStream;
import net.algart.arrays.Arrays;
import net.algart.arrays.IntArray;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.opencv.matrices.ml.MLSamplesType;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class AbstractMLOperation
extends OpenCVExecutor {
    public static final String INPUT_SAMPLES = "samples";
    public static final String INPUT_TRAINING_RESPONSES = "training_responses";
    public static final int MAX_NUMBER_OF_CATEGORICAL_RESPONSES_FOR_CONVERSION_TO_BINARY = 512;
    private final MLSamplesType samplesType;
    private String statModelFile = "";

    protected AbstractMLOperation(MLSamplesType samplesType) {
        this.samplesType = Objects.requireNonNull(samplesType, "Null samplesType");
    }

    public MLSamplesType samplesType() {
        return this.samplesType;
    }

    public String getStatModelFile() {
        return this.statModelFile;
    }

    public void setStatModelFile(String statModelFile) {
        this.statModelFile = (String)AbstractMLOperation.nonNull((Object)statModelFile);
    }

    public Path statModelFile() {
        String modelFileName = AbstractMLOperation.nonEmpty((String)this.statModelFile, (String)"statistical model file name");
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)modelFileName, (Executor)this);
    }

    public static Mat categoricalToMultiBinaryResponses(Mat categoricalResponses) {
        Objects.requireNonNull(categoricalResponses, "Null categoricalResponses");
        if (categoricalResponses.channels() != 1) {
            throw new IllegalArgumentException("ML categoricalResponses must contain only 1 channel, but it contains " + categoricalResponses.channels() + " channels: " + categoricalResponses);
        }
        if (categoricalResponses.cols() != 1) {
            throw new IllegalArgumentException("ML categoricalResponses must contain only 1 column, but it contains " + categoricalResponses.cols() + " columns: " + categoricalResponses);
        }
        try (Mat tempMat = categoricalResponses.depth() != 4 ? new Mat() : null;){
            Mat result;
            Mat intResponses = categoricalResponses;
            if (tempMat != null) {
                intResponses = tempMat;
                categoricalResponses.convertTo(intResponses, 4);
            }
            PArray array = O2SMat.toRawArray(intResponses);
            Mat mat = result = (Mat)AbstractMLOperation.categoricalToMultiBinaryResponses(array, false);
            return mat;
        }
    }

    public static UMat categoricalToMultiBinaryResponses(UMat categoricalResponses) {
        Objects.requireNonNull(categoricalResponses, "Null categoricalResponses");
        if (categoricalResponses.channels() != 1) {
            throw new IllegalArgumentException("ML categoricalResponses must contain only 1 channel, but it contains " + categoricalResponses.channels() + " channels: " + categoricalResponses);
        }
        if (categoricalResponses.cols() != 1) {
            throw new IllegalArgumentException("ML categoricalResponses must contain only 1 column, but it contains " + categoricalResponses.channels() + " columns: " + categoricalResponses);
        }
        try (UMat tempMat = categoricalResponses.depth() != 4 ? new UMat() : null;){
            UMat intResponses = categoricalResponses;
            if (tempMat != null) {
                intResponses = tempMat;
                categoricalResponses.convertTo(intResponses, 4);
            }
            PArray array = O2SMat.toRawArray(intResponses);
            UMat uMat = (UMat)AbstractMLOperation.categoricalToMultiBinaryResponses(array, true);
            return uMat;
        }
    }

    public static Mat selectIndexesOfMaximalMultiResponses(UMat multiResponses) {
        Objects.requireNonNull(multiResponses, "Null multiResponses");
        if (multiResponses.channels() != 1) {
            throw new IllegalArgumentException("ML multiResponses must contain only 1 channel, but it contains " + multiResponses.channels() + " channels: " + multiResponses);
        }
        if (multiResponses.depth() != 5) {
            throw new IllegalArgumentException("ML multiResponses must be CV_32F (float) matrix, but it is " + OTools.toString(multiResponses));
        }
        if (multiResponses.cols() >= 512) {
            throw new IllegalArgumentException("Too large length of every response: " + multiResponses.cols() + "; it muat be in 1..512 range");
        }
        if (multiResponses.cols() == 0) {
            throw new IllegalArgumentException("Zero length of every response (empty matrix");
        }
        try (Mat multiResponsesMat = OTools.toMat(multiResponses);){
            Mat mat = AbstractMLOperation.selectIndexesOfMaximalMultiResponses(multiResponsesMat);
            return mat;
        }
    }

    public static Mat selectIndexesOfMaximalMultiResponses(Mat multiResponses) {
        Objects.requireNonNull(multiResponses, "Null multiResponses");
        if (multiResponses.channels() != 1) {
            throw new IllegalArgumentException("ML multiResponses must contain only 1 channel, but it contains " + multiResponses.channels() + " channels: " + multiResponses);
        }
        if (multiResponses.depth() != 5) {
            throw new IllegalArgumentException("ML multiResponses must be CV_32F (float) matrix, but it is " + OTools.toString(multiResponses));
        }
        if (multiResponses.cols() >= 512) {
            throw new IllegalArgumentException("Too large length of every response: " + multiResponses.cols() + "; it muat be in 1..512 range");
        }
        if (multiResponses.cols() == 0) {
            throw new IllegalArgumentException("Zero length of every response (empty matrix");
        }
        int n = multiResponses.rows();
        int sampleLength = multiResponses.cols();
        Mat result = new Mat(n, 1, 4);
        FloatBuffer sourceMultiResponses = AbstractMLOperation.asByteBuffer(multiResponses).asFloatBuffer();
        IntBuffer resultResponses = AbstractMLOperation.asByteBuffer(result).asIntBuffer();
        assert (sourceMultiResponses.capacity() == n * sampleLength);
        assert (resultResponses.capacity() == n);
        IntStream.range(0, n + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int disp = i * sampleLength;
            int to = (int)Math.min((long)i + 256L, (long)n);
            for (i = block << 8; i < to; ++i) {
                float maxValue = sourceMultiResponses.get(disp++);
                int maxIndex = 0;
                for (int j = 1; j < sampleLength; ++j) {
                    int n2 = disp++;
                    float value = sourceMultiResponses.get(n2);
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxIndex = j;
                }
                resultResponses.put(i, maxIndex);
            }
        });
        return result;
    }

    private static Object categoricalToMultiBinaryResponses(PArray array, boolean uMat) {
        assert (array instanceof IntArray);
        int maxValue = (int)Arrays.rangeOf((PArray)array).max();
        if (maxValue >= 512) {
            throw new IllegalArgumentException("Too large value of categorical response: " + maxValue + "; it muat be in 0..511 range");
        }
        int numberOfColumns = Math.max(maxValue + 1, 2);
        long capacity = (long)numberOfColumns * Arrays.sizeOf(Float.TYPE, (long)array.length());
        if (capacity > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of required responcese: " + numberOfColumns + " * " + array.length() + " >= 2^31 / sizeof(float)");
        }
        int[] categories = Arrays.toJavaArray((IntArray)((IntArray)array));
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)capacity);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer resultResponses = byteBuffer.asFloatBuffer();
        int i = 0;
        int disp = 0;
        while (i < categories.length) {
            int category = Math.max(0, categories[i]);
            assert (category < numberOfColumns);
            resultResponses.put(disp + category, 1.0f);
            ++i;
            disp += numberOfColumns;
        }
        return uMat ? OTools.toUMat(numberOfColumns, categories.length, 5, byteBuffer) : OTools.toMat(numberOfColumns, categories.length, 5, byteBuffer);
    }

    private static ByteBuffer asByteBuffer(Mat m) {
        long arraySize = m.arraySize();
        return m.data().position(0L).capacity(arraySize).asByteBuffer();
    }
}

