/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import net.algart.executors.modules.util.opencv.enums.ODepthOrUnchanged;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Laplacian
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private ODepthOrUnchanged resultDepth = ODepthOrUnchanged.UNCHANGED;
    private int kernelSize = 1;
    private double scale = 1.0;
    private double delta = 0.0;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public ODepthOrUnchanged getResultDepth() {
        return this.resultDepth;
    }

    public void setResultDepth(ODepthOrUnchanged resultDepth) {
        this.resultDepth = (ODepthOrUnchanged)((Object)Laplacian.nonNull((Object)((Object)resultDepth)));
    }

    public int getKernelSize() {
        return this.kernelSize;
    }

    public void setKernelSize(int kernelSize) {
        this.kernelSize = Laplacian.positive((int)kernelSize);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)Laplacian.nonNull((Object)((Object)borderType)));
    }

    @Override
    public void process(Mat result, Mat source) {
        opencv_imgproc.Laplacian((Mat)source, (Mat)result, (int)this.resultDepth.code(), (int)this.kernelSize, (double)this.scale, (double)this.delta, (int)this.borderType.code());
    }

    @Override
    public void process(UMat result, UMat source) {
        opencv_imgproc.Laplacian((UMat)source, (UMat)result, (int)this.resultDepth.code(), (int)this.kernelSize, (double)this.scale, (double)this.delta, (int)this.borderType.code());
    }
}

