/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class FastGradient
extends UMatFilter
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DX = "dx";
    public static final String OUTPUT_DY = "dy";
    private static final int RESULT_DEPTH = 5;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;
    private double scale = 1.0;

    public FastGradient() {
        this.addOutputMat(OUTPUT_DX);
        this.addOutputMat(OUTPUT_DY);
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public FastGradient setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)FastGradient.nonNull((Object)((Object)borderType)));
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public FastGradient setScale(double scale) {
        this.scale = scale;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mat process(Mat source) {
        int borderType = this.borderType.code();
        double scale = this.scale / OTools.maxPossibleValue(source);
        Mat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            Mat gx = new Mat();
            opencv_imgproc.Sobel((Mat)mat, (Mat)gx, (int)5, (int)1, (int)0, (int)1, (double)(0.5 * scale), (double)0.0, (int)borderType);
            O2SMat.setTo(this.getMat(OUTPUT_DX), gx);
            Mat gy = new Mat();
            opencv_imgproc.Sobel((Mat)mat, (Mat)gy, (int)5, (int)0, (int)1, (int)1, (double)(0.5 * scale), (double)0.0, (int)borderType);
            O2SMat.setTo(this.getMat(OUTPUT_DY), gy);
            Mat result = new Mat();
            opencv_core.magnitude((Mat)gx, (Mat)gy, (Mat)result);
            Mat mat2 = result;
            return mat2;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UMat process(UMat source) {
        int borderType = this.borderType.code();
        double scale = this.scale / OTools.maxPossibleValue(source);
        UMat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            UMat gx = new UMat();
            opencv_imgproc.Sobel((UMat)mat, (UMat)gx, (int)5, (int)1, (int)0, (int)1, (double)(0.5 * scale), (double)0.0, (int)borderType);
            O2SMat.setTo(this.getMat(OUTPUT_DX), gx);
            UMat gy = new UMat();
            opencv_imgproc.Sobel((UMat)mat, (UMat)gy, (int)5, (int)0, (int)1, (int)1, (double)(0.5 * scale), (double)0.0, (int)borderType);
            O2SMat.setTo(this.getMat(OUTPUT_DY), gy);
            UMat result = new UMat();
            opencv_core.magnitude((UMat)gx, (UMat)gy, (UMat)result);
            UMat uMat = result;
            return uMat;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

