/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.matrices.filtering.AbstractFilterWithGuideImage;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.ODomainTransformMode;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_ximgproc.DTFilter;

public final class DomainTransformFilter
extends AbstractFilterWithGuideImage {
    private double sigmaSpace = 75.0;
    private double sigmaColor = 0.3;
    private ODomainTransformMode mode = ODomainTransformMode.DTF_IC;
    private int numberOfIterations = 3;

    public double getSigmaSpace() {
        return this.sigmaSpace;
    }

    public void setSigmaSpace(double sigmaSpace) {
        this.sigmaSpace = DomainTransformFilter.nonNegative((double)sigmaSpace);
    }

    public double getSigmaColor() {
        return this.sigmaColor;
    }

    public void setSigmaColor(double sigmaColor) {
        this.sigmaColor = DomainTransformFilter.nonNegative((double)sigmaColor);
    }

    public ODomainTransformMode getMode() {
        return this.mode;
    }

    public void setMode(ODomainTransformMode mode) {
        this.mode = (ODomainTransformMode)((Object)DomainTransformFilter.nonNull((Object)((Object)mode)));
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = DomainTransformFilter.nonNegative((int)numberOfIterations);
    }

    @Override
    public void process(Mat result, Mat source, Mat guide) {
        long tStart = System.nanoTime();
        try (DTFilter filter = opencv_ximgproc.createDTFilter((Mat)guide, (double)this.sigmaSpace, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (int)this.mode.code(), (int)this.numberOfIterations);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }

    @Override
    public void process(UMat result, UMat source, UMat guide) {
        long tStart = System.nanoTime();
        try (DTFilter filter = opencv_ximgproc.createDTFilter((UMat)guide, (double)this.sigmaSpace, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (int)this.mode.code(), (int)this.numberOfIterations);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }
}

