/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import net.algart.executors.modules.util.opencv.enums.OInterpolation;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class BilateralFilter
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private int diameterOfNeighborhood = 5;
    private double sigmaSpace = 75.0;
    private double sigmaColor = 0.3;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public BilateralFilter() {
        this.setStretchingInterpolation(OInterpolation.INTER_LINEAR);
    }

    public int getDiameterOfNeighborhood() {
        return this.diameterOfNeighborhood;
    }

    public void setDiameterOfNeighborhood(int diameterOfNeighborhood) {
        this.diameterOfNeighborhood = BilateralFilter.nonNegative((int)diameterOfNeighborhood, (String)"diameter of neighborhood");
    }

    public double getSigmaSpace() {
        return this.sigmaSpace;
    }

    public void setSigmaSpace(double sigmaSpace) {
        this.sigmaSpace = BilateralFilter.nonNegative((double)sigmaSpace);
    }

    public double getSigmaColor() {
        return this.sigmaColor;
    }

    public void setSigmaColor(double sigmaColor) {
        this.sigmaColor = BilateralFilter.nonNegative((double)sigmaColor);
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)BilateralFilter.nonNull((Object)((Object)borderType)));
    }

    @Override
    public void process(Mat result, Mat source) {
        BilateralFilter.logDebug(() -> "Bilateral filter: d = " + this.diameterOfNeighborhood + ", sigmaSpace = " + this.sigmaSpace + ", sigmaColor = " + this.sigmaColor + ", borderType = " + this.borderType + " (source: " + source + ")");
        opencv_imgproc.bilateralFilter((Mat)source, (Mat)result, (int)this.diameterOfNeighborhood, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (double)this.sigmaSpace, (int)this.borderType.code());
    }

    @Override
    public void process(UMat result, UMat source) {
        BilateralFilter.logDebug(() -> "Bilateral filter (GPU): d = " + this.diameterOfNeighborhood + ", sigmaSpace = " + this.sigmaSpace + ", sigmaColor = " + this.sigmaColor + ", borderType = " + this.borderType + " (source: " + source + ")");
        opencv_imgproc.bilateralFilter((UMat)source, (UMat)result, (int)this.diameterOfNeighborhood, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (double)this.sigmaSpace, (int)this.borderType.code());
    }
}

