/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features.detection;

import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class StructuredEdgeDetection
extends VoidResultUMatFilter {
    private String modelFile = "";

    public String getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(String modelFile) {
        this.modelFile = (String)StructuredEdgeDetection.nonNull((Object)modelFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        String modelFile = StructuredEdgeDetection.nonEmpty((String)this.modelFile, (String)"model file name");
        modelFile = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)modelFile, (Executor)this).toString();
        Mat mat = source;
        try {
            mat = OTools.to32FIfNot(source);
            try (org.bytedeco.opencv.opencv_ximgproc.StructuredEdgeDetection detection = opencv_ximgproc.createStructuredEdgeDetection((String)modelFile);){
                detection.detectEdges(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        String modelFile = StructuredEdgeDetection.nonEmpty((String)this.modelFile, (String)"model file name");
        modelFile = PathPropertyReplacement.translatePropertiesAndCurrentDirectory((String)modelFile, (Executor)this).toString();
        UMat mat = source;
        try {
            mat = OTools.to32FIfNot(source);
            try (org.bytedeco.opencv.opencv_ximgproc.StructuredEdgeDetection detection = opencv_ximgproc.createStructuredEdgeDetection((String)modelFile);){
                detection.detectEdges(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

