/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.thresholds;

import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.components.SmartDilatingObjects;
import net.algart.executors.modules.cv.matrices.thresholds.SimpleThreshold;
import net.algart.multimatrix.MultiMatrix2D;

public final class SmartHysteresisThreshold
extends MultiMatrix2DFilter {
    private double surelyMin = Double.NEGATIVE_INFINITY;
    private double surelyMax = Double.POSITIVE_INFINITY;
    private double hysteresisMin = Double.NEGATIVE_INFINITY;
    private double hysteresisMax = Double.POSITIVE_INFINITY;
    private boolean invert = false;
    private boolean checkSurelyBackground = false;
    private double surelyBackgroundMin = Double.NEGATIVE_INFINITY;
    private double surelyBackgroundMax = Double.POSITIVE_INFINITY;
    private boolean invertBackground = true;
    private boolean rawValues = false;
    private MorphologyFilter.Shape surelyDilationShape = MorphologyFilter.Shape.SPHERE;
    private int surelyDilationSize = 11;
    private String surelyCustomPatternSpecification = null;
    private MorphologyFilter.Shape backgroundDilationShape = MorphologyFilter.Shape.SPHERE;
    private int backgroundDilationSize = 31;
    private String backgroundCustomPatternSpecification = null;

    public double getSurelyMin() {
        return this.surelyMin;
    }

    public SmartHysteresisThreshold setSurelyMin(double surelyMin) {
        this.surelyMin = surelyMin;
        return this;
    }

    public SmartHysteresisThreshold setSurelyMin(String surelyMin) {
        this.surelyMin = SmartHysteresisThreshold.doubleOrNegativeInfinity((String)surelyMin);
        return this;
    }

    public double getSurelyMax() {
        return this.surelyMax;
    }

    public SmartHysteresisThreshold setSurelyMax(double surelyMax) {
        this.surelyMax = surelyMax;
        return this;
    }

    public SmartHysteresisThreshold setSurelyMax(String surelyMax) {
        this.surelyMax = SmartHysteresisThreshold.doubleOrPositiveInfinity((String)surelyMax);
        return this;
    }

    public double getHysteresisMin() {
        return this.hysteresisMin;
    }

    public SmartHysteresisThreshold setHysteresisMin(double hysteresisMin) {
        this.hysteresisMin = hysteresisMin;
        return this;
    }

    public SmartHysteresisThreshold setHysteresisMin(String hysteresisMin) {
        this.hysteresisMin = SmartHysteresisThreshold.doubleOrNegativeInfinity((String)hysteresisMin);
        return this;
    }

    public double getHysteresisMax() {
        return this.hysteresisMax;
    }

    public SmartHysteresisThreshold setHysteresisMax(double hysteresisMax) {
        this.hysteresisMax = hysteresisMax;
        return this;
    }

    public SmartHysteresisThreshold setHysteresisMax(String hysteresisMax) {
        this.hysteresisMax = SmartHysteresisThreshold.doubleOrPositiveInfinity((String)hysteresisMax);
        return this;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public SmartHysteresisThreshold setInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public boolean isCheckSurelyBackground() {
        return this.checkSurelyBackground;
    }

    public SmartHysteresisThreshold setCheckSurelyBackground(boolean checkSurelyBackground) {
        this.checkSurelyBackground = checkSurelyBackground;
        return this;
    }

    public double getSurelyBackgroundMin() {
        return this.surelyBackgroundMin;
    }

    public SmartHysteresisThreshold setSurelyBackgroundMin(double surelyBackgroundMin) {
        this.surelyBackgroundMin = surelyBackgroundMin;
        return this;
    }

    public SmartHysteresisThreshold setSurelyBackgroundMin(String surelyBackgroundMin) {
        this.surelyBackgroundMin = SmartHysteresisThreshold.doubleOrNegativeInfinity((String)surelyBackgroundMin);
        return this;
    }

    public double getSurelyBackgroundMax() {
        return this.surelyBackgroundMax;
    }

    public SmartHysteresisThreshold setSurelyBackgroundMax(double surelyBackgroundMax) {
        this.surelyBackgroundMax = surelyBackgroundMax;
        return this;
    }

    public SmartHysteresisThreshold setSurelyBackgroundMax(String surelyBackgroundMax) {
        this.surelyBackgroundMax = SmartHysteresisThreshold.doubleOrPositiveInfinity((String)surelyBackgroundMax);
        return this;
    }

    public boolean isInvertBackground() {
        return this.invertBackground;
    }

    public SmartHysteresisThreshold setInvertBackground(boolean invertBackground) {
        this.invertBackground = invertBackground;
        return this;
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public SmartHysteresisThreshold setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public MorphologyFilter.Shape getSurelyDilationShape() {
        return this.surelyDilationShape;
    }

    public SmartHysteresisThreshold setSurelyDilationShape(MorphologyFilter.Shape surelyDilationShape) {
        this.surelyDilationShape = (MorphologyFilter.Shape)((Object)SmartHysteresisThreshold.nonNull((Object)((Object)surelyDilationShape)));
        return this;
    }

    public int getSurelyDilationSize() {
        return this.surelyDilationSize;
    }

    public SmartHysteresisThreshold setSurelyDilationSize(int surelyDilationSize) {
        this.surelyDilationSize = SmartHysteresisThreshold.nonNegative((int)surelyDilationSize);
        return this;
    }

    public String getSurelyCustomPatternSpecification() {
        return this.surelyCustomPatternSpecification;
    }

    public SmartHysteresisThreshold setSurelyCustomPatternSpecification(String surelyCustomPatternSpecification) {
        this.surelyCustomPatternSpecification = surelyCustomPatternSpecification;
        return this;
    }

    public MorphologyFilter.Shape getBackgroundDilationShape() {
        return this.backgroundDilationShape;
    }

    public SmartHysteresisThreshold setBackgroundDilationShape(MorphologyFilter.Shape backgroundDilationShape) {
        this.backgroundDilationShape = (MorphologyFilter.Shape)((Object)SmartHysteresisThreshold.nonNull((Object)((Object)backgroundDilationShape)));
        return this;
    }

    public int getBackgroundDilationSize() {
        return this.backgroundDilationSize;
    }

    public SmartHysteresisThreshold setBackgroundDilationSize(int backgroundDilationSize) {
        this.backgroundDilationSize = SmartHysteresisThreshold.nonNegative((int)backgroundDilationSize);
        return this;
    }

    public String getBackgroundCustomPatternSpecification() {
        return this.backgroundCustomPatternSpecification;
    }

    public SmartHysteresisThreshold setBackgroundCustomPatternSpecification(String backgroundCustomPatternSpecification) {
        this.backgroundCustomPatternSpecification = backgroundCustomPatternSpecification;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        MultiMatrix2D surely = new SimpleThreshold().setRawValues(this.rawValues).setMin(this.surelyMin).setMax(this.surelyMax).setInvert(this.invert).process(source);
        MultiMatrix2D maybe = new SimpleThreshold().setRawValues(this.rawValues).setMin(this.hysteresisMin).setMax(this.hysteresisMax).setInvert(this.invert).process(source);
        MultiMatrix2D unlikely = this.checkSurelyBackground ? new SimpleThreshold().setRawValues(this.rawValues).setMin(this.surelyBackgroundMin).setMax(this.surelyBackgroundMax).setInvert(!this.invertBackground).process(source) : null;
        return new SmartDilatingObjects().setSurelyDilationShape(this.surelyDilationShape).setSurelyDilationSize(this.surelyDilationSize).setSurelyCustomPatternSpecification(this.surelyCustomPatternSpecification).setUnlikelyErosionShape(this.backgroundDilationShape).setUnlikelyErosionSize(this.backgroundDilationSize).setUnlikelyCustomPatternSpecification(this.backgroundCustomPatternSpecification).process(surely, maybe, unlikely);
    }
}

