/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.JArrays;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsProcessor;

class CardinalitiesCalculator
extends LabelsProcessor {
    final int[] labels;
    final int[][] threadCardinalities;
    private final int[][] requestedCardinalities;
    int[] cardinalities;
    int maxLabel = -1;

    CardinalitiesCalculator(int[] labels) {
        super((Array)SimpleMemoryModel.asUpdatableIntArray((int[])Objects.requireNonNull(labels, "Null labels")));
        this.labels = labels;
        this.requestedCardinalities = CardinalitiesCalculator.requestClearedIntArrays(this.numberOfTasks());
        this.threadCardinalities = (int[][])this.requestedCardinalities.clone();
    }

    @Override
    public void close() {
        CardinalitiesCalculator.releaseAndClearIntArrays(this.requestedCardinalities, this.maxLabel + 1);
    }

    @Override
    protected void processSubArr(int p, int count, int threadIndex) {
        int k;
        int[] cardinalities = this.threadCardinalities[threadIndex];
        int kMax = k + count;
        for (k = p; k < kMax; ++k) {
            int label = this.labels[k];
            if (label <= 0) continue;
            if (label >= cardinalities.length) {
                cardinalities = CardinalitiesCalculator.ensureCapacityForLabel(cardinalities, label);
            }
            int n = label;
            cardinalities[n] = cardinalities[n] + 1;
        }
        this.threadCardinalities[threadIndex] = cardinalities;
    }

    protected void finish() {
        int maxLabel = 0;
        for (int[] threadCardinalities : this.threadCardinalities) {
            int last = 0;
            for (int k = threadCardinalities.length - 1; k >= 0; --k) {
                if (threadCardinalities[k] <= 0) continue;
                last = k;
                break;
            }
            maxLabel = Math.max(maxLabel, last);
        }
        this.cardinalities = new int[maxLabel];
        this.maxLabel = maxLabel;
        for (int[] cardinalities : this.threadCardinalities) {
            int length = Math.min(this.cardinalities.length, cardinalities.length - 1);
            JArrays.addIntArray((int[])this.cardinalities, (int)0, (int[])cardinalities, (int)1, (int)length);
        }
    }
}

