/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class Selector
extends SeveralMultiMatricesChannelOperation {
    public static final String SELECTOR = "selector";
    public static final String INPUT_MATRIX_PORT_PREFIX = "m";
    private SelectorType selectorType = SelectorType.BINARY_MATRIX;
    private int selectorValue = 0;
    private Map<Integer, String> filler = new HashMap<Integer, String>();
    private Matrix<? extends PArray> selector = null;

    public Selector() {
        super(new String[0]);
    }

    public SelectorType getSelectorType() {
        return this.selectorType;
    }

    public Selector setSelectorType(SelectorType selectorType) {
        this.selectorType = (SelectorType)((Object)Selector.nonNull((Object)((Object)selectorType)));
        return this;
    }

    public int getSelectorValue() {
        return this.selectorValue;
    }

    public Selector setSelectorValue(int selectorValue) {
        this.selectorValue = Selector.nonNegative((int)selectorValue);
        return this;
    }

    public String getFiller(int index) {
        return this.filler.getOrDefault(index, "#000000");
    }

    public Selector setFiller(int index, String color) {
        this.filler.put(index, color);
        return this;
    }

    public void onChangeParameter(String name) {
        if (name.startsWith("filler_")) {
            int index;
            try {
                index = Integer.parseInt(name.substring("filler_".length()));
            }
            catch (NumberFormatException ignored) {
                return;
            }
            this.setFiller(index, this.parameters().getString(name));
            return;
        }
        super.onChangeParameter(name);
    }

    public MultiMatrix process(List<MultiMatrix> sources) {
        if (sources.size() > 0) {
            if (this.selectorType == SelectorType.INT_VALUE) {
                if (this.selectorValue > sources.size()) {
                    throw new IllegalArgumentException("Selector value " + this.selectorValue + " > number of source matrices");
                }
                MultiMatrix result = sources.get(this.selectorValue + 1);
                if (result != null) {
                    return result;
                }
            } else if (sources.get(0) == null) {
                throw new IllegalArgumentException("Selector matrix must be initialized in mode " + this.selectorType);
            }
            switch (this.selectorType) {
                case BINARY_MATRIX: {
                    this.selector = sources.get(0).nonZeroRGBMatrix();
                    break;
                }
                case INT_MATRIX: {
                    this.selector = sources.get(0).intensityChannel();
                    break;
                }
                case INT_VALUE: {
                    this.selector = null;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown " + this.selectorType));
                }
            }
        }
        return super.process(sources);
    }

    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> m) {
        int k;
        int n;
        Class requiredType = this.indexOfSampleInputForEqualizing() == 0 ? ByteArray.class : this.sampleType();
        double maxPossibleValue = Arrays.maxPossibleValue((Class)requiredType, (double)1.0);
        if (this.currentChannel() == 0) {
            Selector.logDebug(() -> "Combining " + (m.size() - 1) + " images to " + Arrays.elementType((Class)requiredType) + "[" + this.numberOfChannels() + " channels, " + JArrays.toString((long[])this.sampleMultiMatrix().dimensions(), (String)"x", (int)1000) + "]");
            if (LOGGABLE_DEBUG) {
                n = m.size();
                for (k = 1; k < n; ++k) {
                    if (m.get(k) == null) {
                        Selector.logTrace((String)("    No image #" + k + "/" + (n - 1) + ": filling by color " + this.getFiller(k - 1)));
                        continue;
                    }
                    Selector.logDebug((String)("    Combined image #" + k + "/" + (n - 1) + ": " + m.get(k).elementType()));
                }
            }
        }
        if (this.selector != null) {
            m.set(0, this.selector);
        } else {
            assert (this.selectorType == SelectorType.INT_VALUE);
            m.set(0, (Matrix<? extends PArray>)Matrices.constantMatrix((double)this.selectorValue, IntArray.class, (long[])this.sampleMultiMatrix().dimensions()));
        }
        n = m.size();
        for (k = 1; k < n; ++k) {
            if (m.get(k) != null) continue;
            double filler = this.colorChannel(this.getFiller(k - 1), maxPossibleValue);
            m.set(k, (Matrix<? extends PArray>)Matrices.constantMatrix((double)filler, (Class)requiredType, (long[])this.sampleMultiMatrix().dimensions()));
        }
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)Func.SELECT, (Class)requiredType, m));
    }

    protected String inputPortName(int inputIndex) {
        return inputIndex == 0 ? SELECTOR : INPUT_MATRIX_PORT_PREFIX + (inputIndex - 1);
    }

    protected boolean equalizePrecision() {
        return false;
    }

    protected int findSampleInputForEqualizing(List<MultiMatrix> sources) {
        for (int k = 1; k < sources.size(); ++k) {
            if (sources.get(k) == null) continue;
            return k;
        }
        return 0;
    }

    public static enum SelectorType {
        BINARY_MATRIX,
        INT_MATRIX,
        INT_VALUE;

    }
}

