/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.filtering;

import java.util.Locale;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.math.IRectangularArea;
import net.algart.matrices.morphology.Quick2DAverager;
import net.algart.multimatrix.MultiMatrix;

public class AverageByRectangle
extends MultiMatrixFilter {
    private int sizeX = 15;
    private int sizeY = 15;
    private int centerX = 0;
    private int centerY = 0;
    boolean strictDivision = false;
    private boolean rounding = true;
    boolean twoStage = false;

    public int getSizeX() {
        return this.sizeX;
    }

    public AverageByRectangle setSizeX(int sizeX) {
        this.sizeX = AverageByRectangle.positive((int)sizeX);
        return this;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public AverageByRectangle setSizeY(int sizeY) {
        this.sizeY = AverageByRectangle.nonNegative((int)sizeY);
        return this;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public AverageByRectangle setCenterX(int centerX) {
        this.centerX = centerX;
        return this;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public AverageByRectangle setCenterY(int centerY) {
        this.centerY = centerY;
        return this;
    }

    public boolean isStrictDivision() {
        return this.strictDivision;
    }

    public AverageByRectangle setStrictDivision(boolean strictDivision) {
        this.strictDivision = strictDivision;
        return this;
    }

    public boolean isRounding() {
        return this.rounding;
    }

    public AverageByRectangle setRounding(boolean rounding) {
        this.rounding = rounding;
        return this;
    }

    public boolean isTwoStage() {
        return this.twoStage;
    }

    public AverageByRectangle setTwoStage(boolean twoStage) {
        this.twoStage = twoStage;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        long t1 = AverageByRectangle.debugTime();
        Quick2DAverager averager = Quick2DAverager.newInstance((Class)source.elementType(), (long[])source.dimensions(), (boolean)this.twoStage).setRounding(this.rounding).setStrictDivision(this.strictDivision);
        int sizeX = this.sizeX;
        int sizeY = this.sizeY <= 0 ? this.sizeX : this.sizeY;
        int minX = this.centerX - sizeX / 2;
        int minY = this.centerY - sizeY / 2;
        IRectangularArea rectangle = IRectangularArea.valueOf((long)minX, (long)minY, (long)(minX + sizeX - 1), (long)(minY + sizeY - 1));
        long t2 = AverageByRectangle.debugTime();
        MultiMatrix result = source.mapChannels(m -> averager.filter(m, rectangle));
        long t3 = AverageByRectangle.debugTime();
        AverageByRectangle.logDebug(() -> String.format(Locale.US, "Averaging of %s by %s using %s calculated in %.3f ms: %.3f initializing, %.3f averaging", source, rectangle, averager, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }
}

