/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.algart.executors.modules.opencv.matrices.filtering.GuidedFilter;
import net.algart.executors.modules.opencv.matrices.segmentation.SuperpixelSLIC;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class ComplexFunctionsUMatTest {
    public static void main(String[] args) throws FileNotFoundException {
        System.out.println("OpenCL existence: " + opencv_core.haveOpenCL());
        System.out.println("OpenCL usage: " + opencv_core.useOpenCL());
        System.out.println("OpenCL enabled: " + OTools.isGPUOptimizationEnabled());
        if (args.length == 0) {
            System.out.printf("Usage: %s source_image%n", ComplexFunctionsUMatTest.class.getName());
            return;
        }
        String sourceFile = args[0];
        if (!Files.exists(Paths.get(sourceFile, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(sourceFile);
        }
        for (int testCount = 0; testCount < 10; ++testCount) {
            Mat m = opencv_imgcodecs.imread((String)sourceFile);
            UMat u = OTools.toUMat((Mat)m);
            System.out.println("Test #" + testCount);
            long t1 = System.nanoTime();
            Mat mr = new GuidedFilter().process(new Mat[]{m, null});
            long t2 = System.nanoTime();
            System.out.printf("GuidedFilter for Mat: %.3f ms for %s%n", (double)(t2 - t1) * 1.0E-6, OTools.toString((UMat)u));
            t1 = System.nanoTime();
            UMat ur = new GuidedFilter().process(new UMat[]{u, null});
            t2 = System.nanoTime();
            System.out.printf("GuidedFilter for UMat: %.3f ms for %s%n", (double)(t2 - t1) * 1.0E-6, OTools.toString((UMat)u));
            opencv_imgcodecs.imwrite((String)(sourceFile + ".GuidedFilter.bmp"), (Mat)OTools.toMat((UMat)ur));
            t1 = System.nanoTime();
            mr = new SuperpixelSLIC().process(m);
            t2 = System.nanoTime();
            System.out.printf("SuperpixelSLIC for Mat: %.3f ms for %s%n", (double)(t2 - t1) * 1.0E-6, OTools.toString((UMat)u));
            t1 = System.nanoTime();
            t2 = System.nanoTime();
            System.out.printf("SuperpixelSLIC for UMat: %.3f ms for %s%n", (double)(t2 - t1) * 1.0E-6, OTools.toString((UMat)u));
            opencv_imgcodecs.imwrite((String)(sourceFile + ".SuperpixelSLIC.bmp"), (Mat)OTools.toMat((UMat)ur));
        }
    }
}

