/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;
import net.algart.additions.math.IntArrayAppender;
import net.algart.additions.math.IntArrayTranslatingAppender;
import net.algart.arrays.IntArray;
import net.algart.arrays.MutableIntArray;

public final class SimpleLambdaSpeed {
    private static final int n = 1098304;
    private static int[] progression;
    private static List<IntUnaryOperator> list;

    private static void time(String name, long t1, long t2) {
        System.out.printf("%-48s %.3f ms, %.5f ns/element%n", name + ":", (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1098304.0);
    }

    private static long sumInts(int[] array, int from, int to) {
        long sum = 0L;
        for (int k = from; k < to; ++k) {
            sum += (long)array[k];
        }
        return sum;
    }

    private static long sumInts(int[] array, int from, int to, IntUnaryOperator op) {
        long sum = 0L;
        for (int k = from; k < to; ++k) {
            sum += (long)op.applyAsInt(array[k]);
        }
        return sum;
    }

    private static long sumIntsTransforming(int[] array, int from, int to, IntUnaryOperator op) {
        return SimpleLambdaSpeed.sumInts(array, from, to, operand -> 2 * op.applyAsInt(operand));
    }

    private static void fillIntsByIntArrayAppender(int[] array, int from, int to) {
        IntArrayAppender appender = new IntArrayAppender(array, from);
        for (int k = from; k < to; ++k) {
            appender.accept(k);
        }
    }

    private static void fillIntsByIntArrayTranslatingAppender(int[] array, int from, int to) {
        IntArrayTranslatingAppender appender = new IntArrayTranslatingAppender(array, i -> progression[i], from);
        for (int k = from; k < to; ++k) {
            appender.accept(k);
        }
    }

    private static void fillIntsByIntSequenceConsumer(int[] array, int from, int to) {
        IntSequenceConsumer intSequenceConsumer = IntSequenceConsumer.getArrayFiller(array, from);
        int counter = 0;
        for (int k = from; k < to; ++k) {
            if (!intSequenceConsumer.accept(k, counter)) continue;
            ++counter;
        }
    }

    private static void fillIntArrayByIntConsumer(MutableIntArray array, int from, int to) {
        IntConsumer intConsumer = k -> array.pushInt(k);
        for (int k2 = from; k2 < to; ++k2) {
            intConsumer.accept(k2);
        }
    }

    private static long sumIntsTransformingClass(int[] array, int from, int to, IntUnaryOperator op) {
        class Transformed
        implements IntUnaryOperator {
            long result;

            Transformed() {
            }

            @Override
            public int applyAsInt(int operand) {
                this.result += (long)operand;
                return operand;
            }
        }
        Transformed transformed = new Transformed();
        SimpleLambdaSpeed.sumInts(array, from, to, transformed);
        return transformed.result;
    }

    private static long sumIntsPassing(int[] array, int from, int to, IntUnaryOperator op) {
        return 2L * SimpleLambdaSpeed.sumInts(array, from, to, op);
    }

    public static void main(String[] args) {
        double someInfo = 0.0;
        for (int test = 1; test <= 32; ++test) {
            int k;
            int k2;
            System.gc();
            System.out.printf("%nSpeed test #%d (%d numbers)%n", test, 1098304);
            long t1 = System.nanoTime();
            int[] ints = new int[1098304];
            long t2 = System.nanoTime();
            SimpleLambdaSpeed.time("new int[]", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            for (int k3 = 0; k3 < 1098304; ++k3) {
                ints[k3] = k3;
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop int[k] = k", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            progression = (int[])ints.clone();
            t1 = System.nanoTime();
            Arrays.setAll(ints, j -> j);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("j -> j", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            Arrays.parallelSetAll(ints, j -> j);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("parallel j -> j", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            long sum = 0L;
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += (long)(k2 + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sum += k+1", t1, t2);
            someInfo += (double)sum;
            t1 = System.nanoTime();
            sum = 0L;
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += (long)((IntUnaryOperator)j -> j + 1).applyAsInt(k2);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sum += (j -> j+1)(k)", t1, t2);
            someInfo += (double)sum;
            t1 = System.nanoTime();
            sum = SimpleLambdaSpeed.sumInts(ints, 0, 1098304);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("sumInts", t1, t2);
            someInfo += (double)sum;
            t1 = System.nanoTime();
            sum = SimpleLambdaSpeed.sumInts(ints, 0, 1098304, j -> j);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("sumInts(j -> j)", t1, t2);
            someInfo += (double)sum;
            t1 = System.nanoTime();
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += SimpleLambdaSpeed.sumInts(ints, k2, k2 + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sumInts", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += SimpleLambdaSpeed.sumInts(ints, k2, k2 + 1, j -> j);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sumInts(j -> j)", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += SimpleLambdaSpeed.sumIntsPassing(ints, k2, k2 + 1, j -> j);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sumIntsPassing", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += SimpleLambdaSpeed.sumIntsTransforming(ints, k2, k2 + 1, j -> j);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sumIntsTransforming", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            for (k2 = 0; k2 < 1098304; ++k2) {
                sum += SimpleLambdaSpeed.sumIntsTransformingClass(ints, k2, k2 + 1, j -> j);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop sumIntsTransformingClass", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            Arrays.fill(ints, 0);
            t1 = System.nanoTime();
            SimpleLambdaSpeed.fillIntsByIntArrayAppender(ints, 0, 1098304);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop IntConsumer (filling)", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(ints, progression)) {
                throw new AssertionError();
            }
            Arrays.fill(ints, 0);
            t1 = System.nanoTime();
            SimpleLambdaSpeed.fillIntsByIntSequenceConsumer(ints, 0, 1098304);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop IntSequenceConsumer (filling)", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(ints, progression)) {
                throw new AssertionError();
            }
            MutableIntArray intArray = net.algart.arrays.Arrays.SMM.newEmptyIntArray();
            t1 = System.nanoTime();
            SimpleLambdaSpeed.fillIntArrayByIntConsumer(intArray, 0, 1098304);
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop IntConsumer for MutableArray", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(net.algart.arrays.Arrays.toJavaArray((IntArray)intArray), progression)) {
                throw new AssertionError();
            }
            Arrays.fill(ints, 0);
            t1 = System.nanoTime();
            for (k = 0; k < 1098304; ++k) {
                SimpleLambdaSpeed.fillIntsByIntArrayAppender(ints, k, k + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop fillIntsByIntArrayAppender", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(ints, progression)) {
                throw new AssertionError();
            }
            Arrays.fill(ints, 0);
            t1 = System.nanoTime();
            for (k = 0; k < 1098304; ++k) {
                SimpleLambdaSpeed.fillIntsByIntArrayTranslatingAppender(ints, k, k + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop fillIntsByIntArrayTranslatingAppender", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(ints, progression)) {
                throw new AssertionError();
            }
            Arrays.fill(ints, 0);
            t1 = System.nanoTime();
            for (k = 0; k < 1098304; ++k) {
                SimpleLambdaSpeed.fillIntsByIntSequenceConsumer(ints, k, k + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop fillIntsByIntSequenceConsumer", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            if (!Arrays.equals(ints, progression)) {
                throw new AssertionError();
            }
            intArray.length(0L);
            for (k = 0; k < 1098304; ++k) {
                SimpleLambdaSpeed.fillIntArrayByIntConsumer(intArray, k, k + 1);
            }
            t2 = System.nanoTime();
            SimpleLambdaSpeed.time("loop fillIntArrayByIntConsumer", t1, t2);
            someInfo += (double)System.identityHashCode(intArray);
            if (!Arrays.equals(net.algart.arrays.Arrays.toJavaArray((IntArray)intArray), progression)) {
                throw new AssertionError();
            }
        }
        System.out.printf("%nSome info: %s%n", someInfo);
    }

    static {
        list = new ArrayList<IntUnaryOperator>();
    }

    private static interface IntSequenceConsumer {
        public boolean accept(int var1, int var2);

        public static IntSequenceConsumer getArrayFiller(int[] array, int offset) {
            return (value, currentCount) -> {
                array[offset + currentCount] = value;
                return true;
            };
        }
    }
}

