/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.maps.pyramids.io.formats.common.builders;

import java.util.ArrayList;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidTools;

public abstract class FollowingResolutionsBuilder {
    public static final long RECOMMENDED_TILE_DIM_FOR_MAKING_FOLLOWING_RESOLUTIONS = Math.max(16L, Arrays.SystemSettings.getLongProperty((String)"net.algart.matrices.maps.pyramids.io.formats.common.builders.tileForMakingFollowingResolutions", (long)PlanePyramidSource.DEFAULT_TILE_DIM));
    protected final PlanePyramidSource source;
    protected final int initialResolutionLevel;
    protected final int compression;
    protected final int bandCount;
    protected final long dimX;
    protected final long dimY;
    private final long totalNumberOfElements;
    private int numberOfNewResolutions = 0;
    private PlanePyramidSource.AveragingMode averagingMode = PlanePyramidSource.AveragingMode.DEFAULT;
    private long processingTileDim = RECOMMENDED_TILE_DIM_FOR_MAKING_FOLLOWING_RESOLUTIONS;

    FollowingResolutionsBuilder(PlanePyramidSource source, int initialResolutionLevel, int compression) {
        if (source == null) {
            throw new NullPointerException("Null source");
        }
        if (compression <= 1) {
            throw new IllegalArgumentException("Invalid compression " + compression + " (must be 2 or greater)");
        }
        if (initialResolutionLevel < 0 || initialResolutionLevel >= source.numberOfResolutions()) {
            throw new IndexOutOfBoundsException("Initial resolution level is out of range 0.." + (source.numberOfResolutions() - 1));
        }
        this.source = source;
        this.initialResolutionLevel = initialResolutionLevel;
        this.compression = compression;
        this.bandCount = source.bandCount();
        if (this.bandCount <= 0) {
            throw new AssertionError((Object)("Invalid implementation of " + source.getClass() + ": zero or negative bandCount = " + this.bandCount));
        }
        long[] dimensions = source.dimensions(initialResolutionLevel);
        if ((long)this.bandCount != dimensions[0]) {
            throw new AssertionError((Object)("Invalid implementation of " + source.getClass() + ": bandCount != dimensions[0]"));
        }
        this.dimX = dimensions[1];
        this.dimY = dimensions[2];
        if (this.dimX <= 0L || this.dimY <= 0L) {
            throw new IllegalArgumentException("Illegal initial layer dimensions " + this.dimX + "x" + this.dimY + " (must be positive)");
        }
        this.totalNumberOfElements = Arrays.longMul((long[])dimensions);
        if (this.totalNumberOfElements == Long.MIN_VALUE) {
            throw new TooLargeArrayException("Product of all dimensions >Long.MAX_VALUE");
        }
        this.setMinimalNewResolutionLayerSize(8L);
    }

    public final PlanePyramidSource getSource() {
        return this.source;
    }

    public final int getCompression() {
        return this.compression;
    }

    public int getBandCount() {
        return this.bandCount;
    }

    public long getDimX() {
        return this.dimX;
    }

    public long getDimY() {
        return this.dimY;
    }

    public long getTotalNumberOfElements() {
        return this.totalNumberOfElements;
    }

    public final int getInitialResolutionLevel() {
        return this.initialResolutionLevel;
    }

    public final int getNumberOfNewResolutions() {
        return this.numberOfNewResolutions;
    }

    public final void setNumberOfNewResolutions(int numberOfNewResolutions) {
        if (numberOfNewResolutions < 0) {
            throw new IllegalArgumentException("Negative numberOfNewResolutions");
        }
        this.numberOfNewResolutions = numberOfNewResolutions;
    }

    public final void setMinimalNewResolutionLayerSize(long minimalPyramidSize) {
        this.numberOfNewResolutions = Math.max(0, PlanePyramidTools.numberOfResolutions(this.dimX, this.dimY, this.compression, minimalPyramidSize) - 1);
    }

    public final PlanePyramidSource.AveragingMode getAveragingMode() {
        return this.averagingMode;
    }

    public final void setAveragingMode(PlanePyramidSource.AveragingMode averagingMode) {
        if (averagingMode == null) {
            throw new NullPointerException("Null averagingMode");
        }
        this.averagingMode = averagingMode;
    }

    public final long getProcessingTileDim() {
        return this.processingTileDim;
    }

    public final void setProcessingTileDim(long processingTileDim) {
        if (processingTileDim <= 0L) {
            throw new IllegalArgumentException("Zero or negative processingTileDim");
        }
        this.processingTileDim = Math.max(16L, processingTileDim);
    }

    public void process() {
        if (this.numberOfNewResolutions == 0) {
            return;
        }
        long tileDim = this.compression;
        int nImmediatelyBuilt = 1;
        while (tileDim < this.processingTileDim) {
            tileDim *= (long)this.compression;
            ++nImmediatelyBuilt;
        }
        boolean needToSeparatelyCompressLastLayers = (nImmediatelyBuilt = Math.min(nImmediatelyBuilt, this.numberOfNewResolutions)) != this.numberOfNewResolutions;
        ArrayList<UpdatablePArray> buffers = new ArrayList<UpdatablePArray>();
        Matrix lastLayer = null;
        long tileXCount = (this.dimX - 1L) / tileDim + 1L;
        long tileYCount = (this.dimY - 1L) / tileDim + 1L;
        Class elementType = null;
        for (long yIndex = 0L; yIndex < tileYCount; ++yIndex) {
            for (long xIndex = 0L; xIndex < tileXCount; ++xIndex) {
                long tileToY;
                long tileToX;
                Matrix<? extends PArray> m;
                long tileX = xIndex * tileDim;
                long tileY = yIndex * tileDim;
                long currentTileDimX = Math.min(tileDim, this.dimX - tileX);
                long currentTileDimY = Math.min(tileDim, this.dimY - tileY);
                if ((m = this.source.readSubMatrix(this.initialResolutionLevel, tileX, tileY, tileToX = tileX + (currentTileDimX -= currentTileDimX % (long)this.compression), tileToY = tileY + (currentTileDimY -= currentTileDimY % (long)this.compression))).dim(0) != (long)this.bandCount || m.dim(1) != currentTileDimX || m.dim(2) != currentTileDimY) {
                    throw new AssertionError((Object)("Invalid implementation of " + this.source.getClass() + ".readSubMatrix (fromX = " + tileX + ", fromY = " + tileY + ", toX = " + tileToX + ", toY = " + tileToY + "): incorrect dimensions of the returned matrix " + m));
                }
                if (elementType == null) {
                    elementType = m.elementType();
                    buffers.add((UpdatablePArray)Arrays.SMM.newUnresizableArray(m.elementType(), (long)this.bandCount * Math.min(tileDim, this.dimX) * Math.min(tileDim, this.dimY)));
                    this.allocateNewLayers(elementType);
                    long layerDimX = this.dimX;
                    long layerDimY = this.dimY;
                    long tDim = tileDim;
                    for (int k = 0; k < nImmediatelyBuilt; ++k) {
                        buffers.add((UpdatablePArray)Arrays.SMM.newUnresizableArray(elementType, (long)this.bandCount * Math.min(tDim /= (long)this.compression, layerDimX /= (long)this.compression) * Math.min(tDim, layerDimY /= (long)this.compression)));
                    }
                    assert (buffers.size() == nImmediatelyBuilt + 1);
                    if (needToSeparatelyCompressLastLayers) {
                        lastLayer = Arrays.SMM.newMatrix(UpdatablePArray.class, elementType, new long[]{this.bandCount, layerDimX, layerDimY});
                    }
                }
                Matrix largeBuffer = Matrices.matrixAtSubArray((Array)((UpdatablePArray)buffers.get(0)), (long)0L, (long[])new long[]{this.bandCount, currentTileDimX, currentTileDimY});
                ((UpdatablePArray)largeBuffer.array()).copy(m.array());
                for (int level = 0; level < nImmediatelyBuilt; ++level) {
                    assert (tileX % (long)this.compression == 0L);
                    assert (tileY % (long)this.compression == 0L);
                    Matrix smallBuffer = Matrices.matrixAtSubArray((Array)((UpdatablePArray)buffers.get(level + 1)), (long)0L, (long[])new long[]{this.bandCount, (tileToX /= (long)this.compression) - (tileX /= (long)this.compression), (tileToY /= (long)this.compression) - (tileY /= (long)this.compression)});
                    Matrices.resize(null, (Matrices.ResizingMethod)this.averagingMode.averagingMethod(largeBuffer), (Matrix)smallBuffer, (Matrix)largeBuffer);
                    this.writeNewData((Matrix<? extends PArray>)smallBuffer, level, tileX, tileY);
                    largeBuffer = smallBuffer;
                }
                if (!needToSeparatelyCompressLastLayers) continue;
                ((UpdatablePArray)lastLayer.subMatrix(0L, tileX, tileY, (long)this.bandCount, tileToX, tileToY).array()).copy(largeBuffer.array());
            }
        }
        assert (elementType != null);
        if (needToSeparatelyCompressLastLayers) {
            long layerDimX = lastLayer.dim(1);
            long layerDimY = lastLayer.dim(2);
            boolean k = false;
            for (int level = nImmediatelyBuilt; level < this.numberOfNewResolutions; ++level) {
                Matrix newLayer = Arrays.SMM.newMatrix(UpdatablePArray.class, elementType, new long[]{this.bandCount, layerDimX /= (long)this.compression, layerDimY /= (long)this.compression});
                Matrices.resize(null, (Matrices.ResizingMethod)this.averagingMode.averagingMethod(lastLayer), (Matrix)newLayer, lastLayer);
                this.writeNewData((Matrix<? extends PArray>)newLayer, level, 0L, 0L);
                lastLayer = newLayer;
            }
        }
    }

    protected abstract void allocateNewLayers(Class<?> var1);

    protected abstract void writeNewData(Matrix<? extends PArray> var1, int var2, long var3, long var5);
}

