/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.maps.pyramids.io.formats.common.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.matrices.maps.pyramids.io.formats.common.builders.FollowingResolutionsBuilder;

public class DefaultFollowingResolutionsBuilder
extends FollowingResolutionsBuilder {
    private final List<Matrix<? extends UpdatablePArray>> results = new ArrayList<Matrix<? extends UpdatablePArray>>();
    private List<MemoryModel> customMemoryModelsForNewResolutions = new ArrayList<MemoryModel>();

    public DefaultFollowingResolutionsBuilder(PlanePyramidSource source, int initialResolutionLevel, int compression) {
        super(source, initialResolutionLevel, compression);
    }

    public List<MemoryModel> getCustomMemoryModelsForNewResolutions() {
        return new ArrayList<MemoryModel>(this.customMemoryModelsForNewResolutions);
    }

    public void setCustomMemoryModelsForNewResolutions(List<MemoryModel> customMemoryModelsForNewResolutions) {
        Objects.requireNonNull(customMemoryModelsForNewResolutions, "Null customMemoryModelsForNewResolutions");
        customMemoryModelsForNewResolutions = new ArrayList<MemoryModel>(customMemoryModelsForNewResolutions);
        for (MemoryModel mm : customMemoryModelsForNewResolutions) {
            Objects.requireNonNull(mm, "Null memory model in the list");
        }
        this.customMemoryModelsForNewResolutions = customMemoryModelsForNewResolutions;
    }

    public List<Matrix<? extends UpdatablePArray>> getResults() {
        return new ArrayList<Matrix<? extends UpdatablePArray>>(this.results);
    }

    @Override
    protected void allocateNewLayers(Class<?> elementType) {
        this.results.clear();
        long layerDimX = this.dimX;
        long layerDimY = this.dimY;
        int n = this.getNumberOfNewResolutions();
        for (int k = 0; k < n; ++k) {
            SimpleMemoryModel mm = k < this.customMemoryModelsForNewResolutions.size() ? this.customMemoryModelsForNewResolutions.get(k) : Arrays.SMM;
            Matrix layer = mm.newMatrix(UpdatablePArray.class, elementType, new long[]{this.bandCount, layerDimX /= (long)this.compression, layerDimY /= (long)this.compression});
            if (mm != Arrays.SMM) {
                layer = layer.tile(new long[]{this.bandCount, PlanePyramidSource.DEFAULT_TILE_DIM, PlanePyramidSource.DEFAULT_TILE_DIM});
            }
            this.results.add((Matrix<? extends UpdatablePArray>)layer);
        }
    }

    @Override
    protected void writeNewData(Matrix<? extends PArray> packedBands, int indexOfNewResolutionLevel, long positionX, long positionY) {
        ((UpdatablePArray)this.results.get(indexOfNewResolutionLevel).subMatr(0L, positionX, positionY, (long)this.bandCount, packedBands.dim(1), packedBands.dim(2)).array()).copy(packedBands.array());
    }
}

