/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.maps.pyramids.io.api.sources;

import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidSource;

public final class RotatingPlanePyramidSource
implements PlanePyramidSource {
    private static final boolean DEBUG_MODE = false;
    private static final System.Logger LOG = System.getLogger(RotatingPlanePyramidSource.class.getName());
    private final PlanePyramidSource parent;
    private final RotationMode rotationMode;
    private MemoryModel memoryModel = Arrays.SMM;

    private RotatingPlanePyramidSource(PlanePyramidSource parent, RotationMode rotationMode) {
        Objects.requireNonNull(parent, "Null parent");
        Objects.requireNonNull(rotationMode, "Null rotationMode");
        assert (rotationMode != RotationMode.NONE);
        this.parent = parent;
        this.rotationMode = rotationMode;
    }

    public static PlanePyramidSource newInstance(PlanePyramidSource parent, RotationMode rotationMode) {
        Objects.requireNonNull(parent, "Null parent");
        if (rotationMode == RotationMode.NONE) {
            return parent;
        }
        return new RotatingPlanePyramidSource(parent, rotationMode);
    }

    public MemoryModel getMemoryModel() {
        return this.memoryModel;
    }

    public RotatingPlanePyramidSource setMemoryModel(MemoryModel memoryModel) {
        this.memoryModel = Objects.requireNonNull(memoryModel, "Null memoryModel");
        return this;
    }

    @Override
    public int numberOfResolutions() {
        return this.parent.numberOfResolutions();
    }

    @Override
    public int compression() {
        return this.parent.compression();
    }

    @Override
    public int bandCount() {
        return this.parent.bandCount();
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return this.parent.isResolutionLevelAvailable(resolutionLevel);
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        return this.parent.getResolutionLevelsAvailability();
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        return this.rotationMode.correctDimensions(this.parent.dimensions(resolutionLevel));
    }

    @Override
    public boolean isElementTypeSupported() {
        return this.parent.isElementTypeSupported();
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        return this.parent.elementType();
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        return this.parent.pixelSizeInMicrons();
    }

    @Override
    public OptionalDouble magnification() {
        return this.parent.magnification();
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        List<IRectangularArea> parentRectangles = this.parent.zeroLevelActualRectangles();
        if (parentRectangles == null) {
            return null;
        }
        long[] rotatedDim = this.dimensions(0);
        long rotatedWidth = rotatedDim[1];
        long rotatedHeight = rotatedDim[2];
        RotationMode reverseRotation = this.rotationMode.reverse();
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>(parentRectangles.size());
        for (IRectangularArea parentRectangle : parentRectangles) {
            IRectangularArea rotatedRectangle = reverseRotation.correctRectangle(rotatedWidth, rotatedHeight, parentRectangle);
            LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "Rotating zero-level actual rectangle %s by %d degree to %s inside %dx%d", parentRectangle, this.rotationMode.rotationInDegrees, rotatedRectangle, rotatedWidth, rotatedHeight));
            result.add(rotatedRectangle);
        }
        return result;
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        List<List<List<IPoint>>> boundaries = this.parent.zeroLevelActualAreaBoundaries();
        if (boundaries == null) {
            return null;
        }
        long[] rotatedDim = this.dimensions(0);
        long rotatedWidth = rotatedDim[1];
        long rotatedHeight = rotatedDim[2];
        RotationMode reverseRotation = this.rotationMode.reverse();
        ArrayList<List<List<IPoint>>> result = new ArrayList<List<List<IPoint>>>();
        for (List<List<IPoint>> area : boundaries) {
            ArrayList rotatedArea = new ArrayList();
            for (List<IPoint> boundary : area) {
                ArrayList<IPoint> rotatedBoundary = new ArrayList<IPoint>();
                for (IPoint p : boundary) {
                    rotatedBoundary.add(reverseRotation.correctPoint(rotatedWidth, rotatedHeight, p));
                }
                rotatedArea.add(rotatedBoundary);
            }
            result.add(rotatedArea);
        }
        return result;
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        long t1 = System.nanoTime();
        long[] parentDim = this.parent.dimensions(resolutionLevel);
        long[] fromAndTo = this.rotationMode.correctFromAndTo(parentDim[1], parentDim[2], fromX, fromY, toX, toY);
        Matrix<? extends PArray> parentSubMatrix = this.parent.readSubMatrix(resolutionLevel, fromAndTo[0], fromAndTo[1], fromAndTo[2], fromAndTo[3]);
        long t2 = System.nanoTime();
        Matrix<? extends PArray> rotated = this.rotated(parentSubMatrix);
        long t3 = System.nanoTime();
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s completed reading %d..%d x %d..%d, level %d in %.3f ms (%.3f parent reading + %.3f rotation)", this.getClass().getSimpleName(), fromX, toX, fromY, toY, resolutionLevel, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return rotated;
    }

    @Override
    public boolean isFullMatrixSupported() {
        return this.parent.isFullMatrixSupported();
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) throws UnsupportedOperationException {
        return this.rotated(this.parent.readFullMatrix(resolutionLevel));
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return this.parent.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        if (kind == PlanePyramidSource.SpecialImageKind.NONE) {
            return Optional.empty();
        }
        return this.parent.readSpecialMatrix(kind).map(this::rotated);
    }

    @Override
    public boolean isDataReady() {
        return this.parent.isDataReady();
    }

    @Override
    public Optional<String> metadata() {
        return this.parent.metadata();
    }

    @Override
    public void loadResources() {
        this.parent.loadResources();
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        this.parent.freeResources(flushMode);
    }

    public String toString() {
        return "RotatingPlanePyramidSource-" + this.rotationMode.rotationInDegrees() + ", based on " + this.parent;
    }

    private Matrix<? extends PArray> rotated(Matrix<? extends PArray> m) {
        long[] newDimensions = this.rotationMode.correctDimensions(m.dimensions());
        if (Arrays.isNCopies((Array)m.array())) {
            assert (Arrays.longMul((long[])newDimensions) == m.size());
            return Matrices.matrix((Array)((PArray)m.array()), (long[])newDimensions);
        }
        Matrix<? extends PArray> lazy = this.rotationMode.asRotated(m);
        Matrix actual = this.memoryModel.newMatrix(Arrays.SystemSettings.maxTempJavaMemory(), UpdatablePArray.class, lazy.elementType(), lazy.dimensions());
        Matrices.copy(null, (Matrix)actual, lazy, (int)0, (boolean)false);
        return actual;
    }

    public static final class RotationMode
    extends Enum<RotationMode> {
        public static final /* enum */ RotationMode NONE = new RotationMode(1L, 0L, 0L, 0L, false, 0);
        public static final /* enum */ RotationMode CLOCKWISE_90 = new RotationMode(0L, 1L, 0L, 1L, true, 90);
        public static final /* enum */ RotationMode CLOCKWISE_180 = new RotationMode(-1L, 0L, 1L, 1L, false, 180);
        public static final /* enum */ RotationMode CLOCKWISE_270 = new RotationMode(0L, -1L, 1L, 0L, true, 270);
        final int rotationInDegrees;
        final long cos;
        final long sin;
        final long bX;
        final long bY;
        final boolean switchWidthAndHeight;
        private static final /* synthetic */ RotationMode[] $VALUES;

        public static RotationMode[] values() {
            return (RotationMode[])$VALUES.clone();
        }

        public static RotationMode valueOf(String name) {
            return Enum.valueOf(RotationMode.class, name);
        }

        private RotationMode(long cos, long sin, long bX, long bY, boolean switchWidthAndHeight, int rotationInDegrees) {
            assert (bX == 0L || bX == 1L || bY == 0L || bY == 1L);
            this.cos = cos;
            this.sin = sin;
            this.bX = bX;
            this.bY = bY;
            this.switchWidthAndHeight = switchWidthAndHeight;
            this.rotationInDegrees = rotationInDegrees;
        }

        public static RotationMode valueOf(int clockwiseRotationInDegrees) {
            return switch (clockwiseRotationInDegrees) {
                case 0 -> NONE;
                case 90 -> CLOCKWISE_90;
                case 180 -> CLOCKWISE_180;
                case 270 -> CLOCKWISE_270;
                default -> throw new IllegalArgumentException(RotationMode.class.getCanonicalName() + " does not support rotation by " + clockwiseRotationInDegrees + " degree");
            };
        }

        public static boolean isAngleSupported(int clockwiseRotationInDegrees) {
            return switch (clockwiseRotationInDegrees) {
                case 0, 90, 180, 270 -> true;
                default -> false;
            };
        }

        public int rotationInDegrees() {
            return this.rotationInDegrees;
        }

        public RotationMode reverse() {
            return this.rotationInDegrees == 0 ? this : RotationMode.valueOf(360 - this.rotationInDegrees);
        }

        public LinearOperator operator(long width, long height) {
            return LinearOperator.getInstance((double[])this.a(), (double[])this.b(width, height));
        }

        public boolean isSwitchWidthAndHeight() {
            return this.switchWidthAndHeight;
        }

        public long[] correctDimensions(long[] dimensionsToCorrect) {
            if (this.switchWidthAndHeight) {
                dimensionsToCorrect = (long[])dimensionsToCorrect.clone();
                long temp = dimensionsToCorrect[2];
                dimensionsToCorrect[2] = dimensionsToCorrect[1];
                dimensionsToCorrect[1] = temp;
            }
            return dimensionsToCorrect;
        }

        public int[] correctDimensions(int[] dimensionsToCorrect) {
            if (this.switchWidthAndHeight) {
                dimensionsToCorrect = (int[])dimensionsToCorrect.clone();
                int temp = dimensionsToCorrect[2];
                dimensionsToCorrect[2] = dimensionsToCorrect[1];
                dimensionsToCorrect[1] = temp;
            }
            return dimensionsToCorrect;
        }

        public long[] correctWidthAndHeight(long[] widthAndHeightToCorrect) {
            if (this.switchWidthAndHeight) {
                widthAndHeightToCorrect = (long[])widthAndHeightToCorrect.clone();
                long temp = widthAndHeightToCorrect[1];
                widthAndHeightToCorrect[1] = widthAndHeightToCorrect[0];
                widthAndHeightToCorrect[0] = temp;
            }
            return widthAndHeightToCorrect;
        }

        public int[] correctWidthAndHeight(int[] widthAndHeightToCorrect) {
            if (this.switchWidthAndHeight) {
                widthAndHeightToCorrect = (int[])widthAndHeightToCorrect.clone();
                int temp = widthAndHeightToCorrect[1];
                widthAndHeightToCorrect[1] = widthAndHeightToCorrect[0];
                widthAndHeightToCorrect[0] = temp;
            }
            return widthAndHeightToCorrect;
        }

        public long[] correctFromAndTo(long parentImageWidth, long parentImageHeight, long fromX, long fromY, long toX, long toY) {
            long rotatedFromX = this.cos * fromX + this.sin * fromY + this.bX * parentImageWidth;
            long rotatedFromY = -this.sin * fromX + this.cos * fromY + this.bY * parentImageHeight;
            long rotatedSizeX = this.cos * (toX - fromX) + this.sin * (toY - fromY);
            long rotatedSizeY = -this.sin * (toX - fromX) + this.cos * (toY - fromY);
            long newFromX = rotatedSizeX >= 0L ? rotatedFromX : rotatedFromX + rotatedSizeX;
            long newFromY = rotatedSizeY >= 0L ? rotatedFromY : rotatedFromY + rotatedSizeY;
            long newToX = newFromX + Math.abs(rotatedSizeX);
            long newToY = newFromY + Math.abs(rotatedSizeY);
            return new long[]{newFromX, newFromY, newToX, newToY};
        }

        public IPoint correctPoint(long parentImageWidth, long parentImageHeight, IPoint point) {
            long rotatedX = this.cos * point.x() + this.sin * point.y() + this.bX * parentImageWidth;
            long rotatedY = -this.sin * point.x() + this.cos * point.y() + this.bY * parentImageHeight;
            return IPoint.valueOf((long)rotatedX, (long)rotatedY);
        }

        public IRectangularArea correctRectangle(long parentImageWidth, long parentImageHeight, IRectangularArea rectangle) {
            long fromX = rectangle.min(0);
            long fromY = rectangle.min(1);
            long toX = rectangle.max(0) + 1L;
            long toY = rectangle.max(1) + 1L;
            long[] fromAndTo = this.correctFromAndTo(parentImageWidth, parentImageHeight, fromX, fromY, toX, toY);
            return IRectangularArea.valueOf((IPoint)IPoint.valueOf((long)fromAndTo[0], (long)fromAndTo[1]), (IPoint)IPoint.valueOf((long)(fromAndTo[2] - 1L), (long)(fromAndTo[3] - 1L)));
        }

        public Matrix<? extends PArray> asRotated(Matrix<? extends PArray> m) {
            long[] newDimensions = this.correctDimensions(m.dimensions());
            if (Arrays.isNCopies((Array)m.array())) {
                assert (Arrays.longMul((long[])newDimensions) == m.size());
                return Matrices.matrix((Array)((PArray)m.array()), (long[])newDimensions);
            }
            LinearOperator operator = this.operator(m.dim(1), m.dim(2));
            Func source = Matrices.asInterpolationFunc(m, (Matrices.InterpolationMethod)Matrices.InterpolationMethod.STEP_FUNCTION, (boolean)false);
            Func rotated = operator.apply(source);
            return Matrices.asCoordFuncMatrix((Func)rotated, (Class)m.type(PArray.class), (long[])newDimensions);
        }

        private double[] a() {
            return new double[]{1.0, 0.0, 0.0, 0.0, this.cos, this.sin, 0.0, -this.sin, this.cos};
        }

        private double[] b(long width, long height) {
            return new double[]{0.0, this.bX * (width - 1L), this.bY * (height - 1L)};
        }

        private static /* synthetic */ RotationMode[] $values() {
            return new RotationMode[]{NONE, CLOCKWISE_90, CLOCKWISE_180, CLOCKWISE_270};
        }

        static {
            $VALUES = RotationMode.$values();
        }
    }
}

