/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.maps.pyramids.io.api.sources;

import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidSource;

public final class DelayedPlanePyramidSource
implements PlanePyramidSource {
    private final int bandCount;
    private final int compression;
    private final boolean[] resolutionLevelsAvailability;
    private final List<long[]> dimensions;
    private PlanePyramidSource parent = null;
    private final Object lock = new Object();

    private DelayedPlanePyramidSource(long[] zeroLevelDimensions, int compression, boolean[] resolutionLevelsAvailability) {
        if (zeroLevelDimensions == null) {
            throw new NullPointerException("Null array of zero-level dimensions");
        }
        if (resolutionLevelsAvailability == null) {
            throw new NullPointerException("Null array of availability of resolution levels");
        }
        if (zeroLevelDimensions.length != 3) {
            throw new IllegalArgumentException("Illegal length of zero-level dimensions array " + zeroLevelDimensions.length);
        }
        long bandCount = zeroLevelDimensions[0];
        long dimX = zeroLevelDimensions[1];
        long dimY = zeroLevelDimensions[2];
        if (dimX <= 0L || dimY <= 0L) {
            throw new IllegalArgumentException("Illegal zero-level dimensions " + dimX + "x" + dimY + " (must be positive)");
        }
        if (bandCount <= 0L) {
            throw new IllegalArgumentException("Number of bands must be positive");
        }
        if (bandCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large number of bands (>Integer.MAX_VALUE)");
        }
        if (compression <= 1) {
            throw new IllegalArgumentException("Compression must be 2 or greater");
        }
        this.bandCount = (int)bandCount;
        this.compression = compression;
        this.resolutionLevelsAvailability = (boolean[])resolutionLevelsAvailability.clone();
        this.dimensions = new ArrayList<long[]>();
        for (int k = 0; k < resolutionLevelsAvailability.length; ++k) {
            this.dimensions.add(new long[]{bandCount, dimX, dimY});
            dimX /= (long)compression;
            dimY /= (long)compression;
        }
    }

    public static DelayedPlanePyramidSource newInstance(long dimX, long dimY, int bandCount, int compression, boolean[] resolutionLevelsAvailability) {
        return DelayedPlanePyramidSource.newInstance(new long[]{dimX, dimY, bandCount}, compression, resolutionLevelsAvailability);
    }

    public static DelayedPlanePyramidSource newInstance(long[] zeroLevelDimensions, int compression, boolean[] resolutionLevelsAvailability) {
        return new DelayedPlanePyramidSource(zeroLevelDimensions, compression, resolutionLevelsAvailability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanePyramidSource getParent() {
        Object object = this.lock;
        synchronized (object) {
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(PlanePyramidSource parent) {
        Objects.requireNonNull(parent, "Cannot change the parent back to null value");
        if (parent.numberOfResolutions() != this.numberOfResolutions()) {
            throw new IllegalArgumentException("parent.numberOfResolutions() != numberOfResolutions()");
        }
        if (parent.bandCount() != this.bandCount) {
            throw new IllegalArgumentException("parent.bandCount() != bandCount()");
        }
        for (int level = 0; level < this.resolutionLevelsAvailability.length; ++level) {
            if (parent.isResolutionLevelAvailable(level) != this.resolutionLevelsAvailability[level]) {
                throw new IllegalArgumentException("parent.isResolutionLevelAvailable(" + level + ") != resolutionLevelsAvailability[" + level + "]");
            }
            if (!this.resolutionLevelsAvailability[level] || Arrays.equals(parent.dimensions(level), this.dimensions.get(level))) continue;
            throw new IllegalArgumentException("parent.dimensions(" + level + ") != dimensions(" + level + ")");
        }
        Object object = this.lock;
        synchronized (object) {
            this.parent = parent;
        }
    }

    @Override
    public int numberOfResolutions() {
        return this.resolutionLevelsAvailability.length;
    }

    @Override
    public int compression() {
        return this.compression;
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return this.resolutionLevelsAvailability[resolutionLevel];
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        return (boolean[])this.resolutionLevelsAvailability.clone();
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        return (long[])this.dimensions.get(resolutionLevel).clone();
    }

    @Override
    public long dim(int resolutionLevel, int index) {
        return this.dimensions.get(resolutionLevel)[index];
    }

    @Override
    public boolean isElementTypeSupported() {
        PlanePyramidSource parent = this.getParent();
        return parent != null && parent.isElementTypeSupported();
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("elementType() method is not supported yet, because the parent is not set yet");
        }
        return parent.elementType();
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("pixelSizeInMicrons() method is not supported yet, because the parent is not set yet");
        }
        return parent.pixelSizeInMicrons();
    }

    @Override
    public OptionalDouble magnification() {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("magnification() method is not supported yet, because the parent is not set yet");
        }
        return parent.magnification();
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("zeroLevelActualRectangles() method is not supported yet, because the parent is not set yet");
        }
        return parent.zeroLevelActualRectangles();
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("zeroLevelActualAreaBoundaries() method is not supported yet, because the parent is not set yet");
        }
        return parent.zeroLevelActualAreaBoundaries();
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) throws NoSuchElementException, NotYetConnectedException {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new NotYetConnectedException();
        }
        return parent.readSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
    }

    @Override
    public boolean isFullMatrixSupported() {
        PlanePyramidSource parent = this.getParent();
        return parent != null && parent.isFullMatrixSupported();
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) throws NoSuchElementException, NotYetConnectedException, UnsupportedOperationException {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new NotYetConnectedException();
        }
        return parent.readFullMatrix(resolutionLevel);
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new NotYetConnectedException();
        }
        return parent.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new NotYetConnectedException();
        }
        return parent.readSpecialMatrix(kind);
    }

    @Override
    public boolean isDataReady() {
        PlanePyramidSource parent = this.getParent();
        return parent != null && parent.isDataReady();
    }

    @Override
    public Optional<String> metadata() {
        PlanePyramidSource parent = this.getParent();
        if (parent == null) {
            throw new UnsupportedOperationException("metadata() method is not supported yet, because the parent is not set yet");
        }
        return parent.metadata();
    }

    @Override
    public void loadResources() {
        PlanePyramidSource parent = this.getParent();
        if (parent != null) {
            parent.loadResources();
        }
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        PlanePyramidSource parent = this.getParent();
        if (parent != null) {
            parent.freeResources(flushMode);
        }
    }
}

