/*
 * Decompiled with CFR 0.152.
 */
package net.algart.matrices.maps.pyramids.io.api.sources;

import java.nio.channels.NotYetConnectedException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.matrices.maps.pyramids.io.api.PlanePyramidTools;

public final class CombinedPlanePyramidSource
implements PlanePyramidSource {
    private PlanePyramidSource mainParent;
    private PlanePyramidSource overridingParent;
    private final int numberOfResolutions;

    private CombinedPlanePyramidSource(PlanePyramidSource mainParent, PlanePyramidSource overridingParent) {
        if (mainParent == null) {
            throw new NullPointerException("Null mainParent");
        }
        if (overridingParent == null) {
            throw new NullPointerException("Null overridingParent");
        }
        if (mainParent.bandCount() != overridingParent.bandCount()) {
            throw new IllegalArgumentException("bandCount mismatch in mainParent (" + mainParent.bandCount() + ") and overridingParent (" + overridingParent.bandCount() + ")");
        }
        this.mainParent = mainParent;
        this.overridingParent = overridingParent;
        this.numberOfResolutions = Math.max(mainParent.numberOfResolutions(), overridingParent.numberOfResolutions());
    }

    public static PlanePyramidSource newInstance(PlanePyramidSource mainParent, PlanePyramidSource overridingParent) {
        if (mainParent == null && overridingParent == null) {
            throw new NullPointerException("Both mainParent and overridingParent are null");
        }
        if (overridingParent == null) {
            return mainParent;
        }
        if (mainParent == null) {
            return overridingParent;
        }
        return new CombinedPlanePyramidSource(mainParent, overridingParent);
    }

    @Override
    public int numberOfResolutions() {
        return this.numberOfResolutions;
    }

    @Override
    public int compression() {
        return PlanePyramidTools.defaultCompression(this);
    }

    @Override
    public int bandCount() {
        return this.mainParent.bandCount();
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return this.existInMain(resolutionLevel) || this.existInOverriding(resolutionLevel);
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        boolean[] result = new boolean[this.numberOfResolutions()];
        for (int k = 0; k < result.length; ++k) {
            result[k] = this.isResolutionLevelAvailable(k);
        }
        return result;
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        return this.existInOverriding(resolutionLevel) ? this.overridingParent.dimensions(resolutionLevel) : this.mainParent.dimensions(resolutionLevel);
    }

    @Override
    public boolean isElementTypeSupported() {
        return this.mainParent.isElementTypeSupported() || this.overridingParent.isElementTypeSupported();
    }

    @Override
    public Class<?> elementType() throws UnsupportedOperationException {
        return this.mainParent.isElementTypeSupported() ? this.mainParent.elementType() : this.overridingParent.elementType();
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        return this.existInOverriding(0) ? this.overridingParent.pixelSizeInMicrons() : this.mainParent.pixelSizeInMicrons();
    }

    @Override
    public OptionalDouble magnification() {
        return this.existInOverriding(0) ? this.overridingParent.magnification() : this.mainParent.magnification();
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        return this.existInOverriding(0) ? this.overridingParent.zeroLevelActualRectangles() : this.mainParent.zeroLevelActualRectangles();
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        return this.existInOverriding(0) ? this.overridingParent.zeroLevelActualAreaBoundaries() : this.mainParent.zeroLevelActualAreaBoundaries();
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        return this.existInOverriding(resolutionLevel) ? this.overridingParent.readSubMatrix(resolutionLevel, fromX, fromY, toX, toY) : this.mainParent.readSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
    }

    @Override
    public boolean isFullMatrixSupported() {
        return this.mainParent.isFullMatrixSupported() && this.overridingParent.isFullMatrixSupported();
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) throws UnsupportedOperationException {
        return this.existInOverriding(resolutionLevel) ? this.overridingParent.readFullMatrix(resolutionLevel) : this.mainParent.readFullMatrix(resolutionLevel);
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        int resolutionLevel = this.numberOfResolutions() - 1;
        return this.existInOverriding(resolutionLevel) ? this.overridingParent.isSpecialMatrixSupported(kind) : this.mainParent.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) throws NotYetConnectedException {
        int resolutionLevel = this.numberOfResolutions() - 1;
        return this.existInOverriding(resolutionLevel) ? this.overridingParent.readSpecialMatrix(kind) : this.mainParent.readSpecialMatrix(kind);
    }

    @Override
    public boolean isDataReady() {
        return this.mainParent.isDataReady() && this.overridingParent.isDataReady();
    }

    @Override
    public Optional<String> metadata() {
        return this.existInOverriding(0) ? this.overridingParent.metadata() : this.mainParent.metadata();
    }

    @Override
    public void loadResources() {
        this.mainParent.loadResources();
        this.overridingParent.loadResources();
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        this.mainParent.freeResources(flushMode);
        this.overridingParent.freeResources(flushMode);
    }

    private boolean existInMain(int level) {
        return level < this.mainParent.numberOfResolutions() && this.mainParent.isResolutionLevelAvailable(level);
    }

    private boolean existInOverriding(int level) {
        return level < this.overridingParent.numberOfResolutions() && this.overridingParent.isResolutionLevelAvailable(level);
    }
}

