/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.util.opencv.enums;

public enum ODepth {
    CV_8U(0, 255.0),
    CV_8S(1, 127.0),
    CV_16U(2, 65535.0),
    CV_16S(3, 32767.0),
    CV_32S(4, 2.147483647E9),
    CV_32F(5, 1.0),
    CV_64F(6, 1.0);

    private final int code;
    private final double maxValue;

    public int code() {
        return this.code;
    }

    public double maxValue() {
        return this.maxValue;
    }

    public static ODepth valueOf(int code) {
        for (ODepth value : ODepth.values()) {
            if (value.code != code) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown depth code " + code);
    }

    private ODepth(int code, double maxValue) {
        this.code = code;
        this.maxValue = maxValue;
    }
}

