/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import java.awt.Color;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.matrices.segmentation.BoundariesExtractor;
import net.algart.executors.modules.opencv.matrices.segmentation.DrawingBoundariesStyle;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class AbstractSegmentationWithBoundaries
extends UMatFilter {
    public static final String OUTPUT_BOUNDARIES = "boundaries";
    DrawingBoundariesStyle drawingBoundariesStyle = DrawingBoundariesStyle.BOUNDARIES;
    private Color drawingBoundariesColor = Color.WHITE;
    private boolean visibleBoundaries = false;

    public AbstractSegmentationWithBoundaries() {
        this.addOutputMat(OUTPUT_BOUNDARIES);
    }

    public DrawingBoundariesStyle getDrawingBoundariesStyle() {
        return this.drawingBoundariesStyle;
    }

    public void setDrawingBoundariesStyle(DrawingBoundariesStyle drawingBoundariesStyle) {
        this.drawingBoundariesStyle = (DrawingBoundariesStyle)((Object)AbstractSegmentationWithBoundaries.nonNull((Object)((Object)drawingBoundariesStyle)));
    }

    public Color getDrawingBoundariesColor() {
        return this.drawingBoundariesColor;
    }

    public void setDrawingBoundariesColor(Color drawingBoundariesColor) {
        this.drawingBoundariesColor = (Color)AbstractSegmentationWithBoundaries.nonNull((Object)drawingBoundariesColor);
    }

    public boolean isVisibleBoundaries() {
        return this.visibleBoundaries;
    }

    public void setVisibleBoundaries(boolean visibleBoundaries) {
        this.visibleBoundaries = visibleBoundaries;
    }

    public String visibleOutputPortName() {
        return this.visibleBoundaries ? OUTPUT_BOUNDARIES : super.visibleOutputPortName();
    }

    public void setToOutputBoundaries(BoundariesExtractor boundariesExtractor, Mat source, Mat labels) {
        if (this.isBoundariesRequested()) {
            Mat stretchedBoundaries;
            this.setEndProcessingTimeStamp();
            Mat boundaries = new Mat();
            boundariesExtractor.findBoundaries(boundaries, labels, this.drawingBoundariesStyle.thickBoundaries);
            Mat drawnBoundaries = this.drawingBoundariesStyle.drawOnSourceIfRequested(boundaries, source, this.drawingBoundariesColor);
            if (drawnBoundaries != boundaries) {
                boundaries.close();
                boundaries = drawnBoundaries;
            }
            if ((stretchedBoundaries = this.stretchToOriginal(boundaries)) != boundaries) {
                boundaries.close();
            }
            boundaries = stretchedBoundaries;
            if (this.drawingBoundariesStyle.binary) {
                this.getMat(OUTPUT_BOUNDARIES).setTo((MultiMatrix)O2SMat.toBinaryMatrix(boundaries));
            } else {
                O2SMat.setTo(this.getMat(OUTPUT_BOUNDARIES), boundaries);
            }
        }
    }

    public void setToOutputBoundaries(BoundariesExtractor boundariesExtractor, UMat source, UMat labels) {
        if (this.isBoundariesRequested()) {
            try (Mat sourceMat = OTools.toMat(source);
                 Mat labelsMat = OTools.toMat(labels);){
                this.setToOutputBoundaries(boundariesExtractor, sourceMat, labelsMat);
            }
        }
    }

    private boolean isBoundariesRequested() {
        return this.hasOutputPort(OUTPUT_BOUNDARIES) && (this.visibleBoundaries || this.isOutputNecessary(OUTPUT_BOUNDARIES));
    }
}

