/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.misc;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.common.MatToNumbers;
import org.bytedeco.opencv.opencv_core.Mat;

public class TestBorderPixels
extends MatToNumbers
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String OUTPUT_MAX_BORDER = "max_border";
    public static final String OUTPUT_MAX_TOP = "max_top";
    public static final String OUTPUT_MAX_BOTTOM = "max_bottom";
    public static final String OUTPUT_MAX_LEFT = "max_left";
    public static final String OUTPUT_MAX_RIGHT = "max_right";
    private int outsideIndent = 0;

    public TestBorderPixels() {
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputScalar(OUTPUT_MAX_BORDER);
        this.addOutputScalar(OUTPUT_MAX_TOP);
        this.addOutputScalar(OUTPUT_MAX_BOTTOM);
        this.addOutputScalar(OUTPUT_MAX_LEFT);
        this.addOutputScalar(OUTPUT_MAX_RIGHT);
    }

    public int getOutsideIndent() {
        return this.outsideIndent;
    }

    public TestBorderPixels setOutsideIndent(int outsideIndent) {
        this.outsideIndent = TestBorderPixels.nonNegative((int)outsideIndent);
        return this;
    }

    @Override
    public SNumbers analyse(Mat source) {
        BorderStatistics statistics = TestBorderPixels.findBorderStatistics(source, this.outsideIndent);
        this.getScalar(OUTPUT_DIM_X).setTo(statistics.dimX());
        this.getScalar(OUTPUT_DIM_Y).setTo(statistics.dimY());
        SNumbers result = SNumbers.valueOfArray((Object)statistics.elementsAtBounds());
        if (statistics.isEmpty()) {
            return result;
        }
        this.getScalar(OUTPUT_MAX_BORDER).setTo(statistics.max());
        this.getScalar(OUTPUT_MAX_TOP).setTo(statistics.maxTop());
        this.getScalar(OUTPUT_MAX_BOTTOM).setTo(statistics.maxBottom());
        this.getScalar(OUTPUT_MAX_LEFT).setTo(statistics.maxLeft());
        this.getScalar(OUTPUT_MAX_RIGHT).setTo(statistics.maxRight());
        return result;
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }

    public static BorderStatistics findBorderStatistics(Mat source, int outsideIndent) {
        byte[] bounds = TestBorderPixels.extractBorder(source, outsideIndent);
        int analysedDimX = TestBorderPixels.analysedDimX(source, outsideIndent);
        int analysedDimY = TestBorderPixels.analysedDimY(source, outsideIndent);
        return new BorderStatistics(bounds, analysedDimX, analysedDimY);
    }

    public static byte[] extractBorder(Mat source, int outsideIndent) {
        int reducedDimY;
        Objects.requireNonNull(source, "Null source");
        if (outsideIndent < 0) {
            throw new IllegalArgumentException("Negative outsideIndent = " + outsideIndent);
        }
        if (source.channels() != 1 || source.depth() != 0) {
            throw new IllegalArgumentException("Unsupported matrix type: " + source + "; only monochrome byte matrices can be processed");
        }
        int dimX = source.cols();
        int dimY = source.rows();
        if ((long)dimX <= 2L * (long)outsideIndent || (long)dimY <= 2L * (long)outsideIndent) {
            return new byte[0];
        }
        int reducedDimX = TestBorderPixels.analysedDimX(source, outsideIndent);
        long resultSize = 2L * ((long)reducedDimX + (long)(reducedDimY = TestBorderPixels.analysedDimY(source, outsideIndent)));
        if (resultSize > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large result");
        }
        ByteBuffer byteBuffer = TestBorderPixels.asByteBuffer(source);
        byte[] result = new byte[(int)resultSize];
        int disp = 0;
        int p = outsideIndent * dimX + outsideIndent;
        int to = disp + reducedDimX;
        while (disp < to) {
            result[disp] = byteBuffer.get(p);
            ++disp;
            ++p;
        }
        assert (--p == outsideIndent * dimX + dimX - outsideIndent - 1);
        to = disp + reducedDimY;
        while (disp < to) {
            result[disp] = byteBuffer.get(p);
            ++disp;
            p += dimX;
        }
        assert ((p -= dimX) == (dimY - outsideIndent - 1) * dimX + dimX - outsideIndent - 1);
        to = disp + reducedDimX;
        while (disp < to) {
            result[disp] = byteBuffer.get(p);
            ++disp;
            --p;
        }
        assert (++p == (dimY - outsideIndent - 1) * dimX + outsideIndent);
        to = disp + reducedDimY;
        while (disp < to) {
            result[disp] = byteBuffer.get(p);
            ++disp;
            p -= dimX;
        }
        assert ((p += dimX) == outsideIndent * dimX + outsideIndent);
        return result;
    }

    public static int analysedDimX(Mat source, int outsideIndent) {
        return source.cols() - 2 * outsideIndent;
    }

    public static int analysedDimY(Mat source, int outsideIndent) {
        return source.rows() - 2 * outsideIndent;
    }

    static ByteBuffer asByteBuffer(Mat m) {
        long arraySize = m.arraySize();
        return m.data().position(0L).capacity(arraySize).asByteBuffer();
    }

    public static class BorderStatistics {
        private final byte[] elementsAtBounds;
        private final int dimX;
        private final int dimY;
        private final int maxTop;
        private final int maxRight;
        private final int maxBottom;
        private final int maxLeft;

        public BorderStatistics(byte[] elementsAtBounds, int dimX, int dimY) {
            Objects.requireNonNull(elementsAtBounds, "Null elementsAtBounds array");
            if (dimX < 0) {
                throw new IllegalArgumentException("Negative dimX = " + dimX);
            }
            if (dimY < 0) {
                throw new IllegalArgumentException("Negative dimY = " + dimY);
            }
            if ((long)elementsAtBounds.length != 2L * ((long)dimX + (long)dimY)) {
                throw new IllegalArgumentException("elementsAtBounds length " + elementsAtBounds.length + " and matrix sizes " + dimX + "x" + dimY + " mismatch: length must be = 2 * (dimX + dimY))");
            }
            this.elementsAtBounds = elementsAtBounds;
            this.dimX = dimX;
            this.dimY = dimY;
            this.maxTop = BorderStatistics.maxInRange(elementsAtBounds, 0, dimX);
            this.maxRight = BorderStatistics.maxInRange(elementsAtBounds, dimX, dimY);
            this.maxBottom = BorderStatistics.maxInRange(elementsAtBounds, dimX + dimY, dimX);
            this.maxLeft = BorderStatistics.maxInRange(elementsAtBounds, 2 * dimX + dimY, dimY);
        }

        public boolean isEmpty() {
            return this.elementsAtBounds.length == 0;
        }

        public byte[] elementsAtBounds() {
            return this.elementsAtBounds;
        }

        public int dimX() {
            return this.dimX;
        }

        public int dimY() {
            return this.dimY;
        }

        public int maxTop() {
            return this.maxTop;
        }

        public int maxRight() {
            return this.maxRight;
        }

        public int maxBottom() {
            return this.maxBottom;
        }

        public int maxLeft() {
            return this.maxLeft;
        }

        public int max() {
            return Math.max(Math.max(this.maxTop, this.maxBottom), Math.max(this.maxLeft, this.maxRight));
        }

        private static int maxInRange(byte[] array, int offset, int count) {
            int max = Integer.MIN_VALUE;
            int to = offset + count;
            while (offset < to) {
                int value = array[offset] & 0xFF;
                if (value > max) {
                    max = value;
                }
                ++offset;
            }
            return max;
        }
    }
}

