/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import java.util.ArrayList;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.common.SeveralMatOperation;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class SeveralUMatOperation
extends SeveralMatOperation {
    @Override
    public void process() {
        if (!this.useGPU()) {
            super.process();
            return;
        }
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        ArrayList<UMat> sourceMats = new ArrayList<UMat>();
        for (int k = 0; requiredNumberOfInputs == null || k < requiredNumberOfInputs; ++k) {
            String portName = this.inputPortName(k);
            if (requiredNumberOfInputs == null && !this.hasInputPort(portName)) break;
            sourceMats.add(this.getInputUMat(k));
        }
        if (this.dimensionsEqualityRequired()) {
            OTools.checkDimensionOfNonNullUMatEquality(sourceMats);
        }
        this.setStartProcessingTimeStamp();
        UMat target = this.process(sourceMats.toArray(new UMat[0]));
        this.setEndProcessingTimeStamp();
        this.setOutputTo(target);
    }

    public UMat getInputUMat(int inputIndex) {
        SMat inputMat = this.getInputMat(this.inputPortName(inputIndex), this.allowUninitializedInput(inputIndex));
        return inputMat.isInitialized() ? O2SMat.toUMat(inputMat, this.allowInputPackedBits(inputIndex)) : null;
    }

    public void setOutputTo(UMat result) {
        if (this.packOutputBits()) {
            this.getMat().setTo((MultiMatrix)O2SMat.toBinaryMatrix(result));
        } else {
            O2SMat.setTo(this.getMat(), result);
        }
    }

    public abstract UMat process(UMat[] var1);
}

