/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import java.util.ArrayList;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.opencv_core.Mat;

public abstract class SeveralMatOperation
extends OpenCVExecutor {
    public static final int DEFAULT_REQUIRED_NUMBER_OF_INPUTS = 2;
    public static final String INPUT_PORT_PREFIX = "input_";

    protected SeveralMatOperation() {
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public void process() {
        Integer requiredNumberOfInputs = this.requiredNumberOfInputs();
        ArrayList<Mat> sourceMats = new ArrayList<Mat>();
        for (int k = 0; requiredNumberOfInputs == null || k < requiredNumberOfInputs; ++k) {
            String portName = this.inputPortName(k);
            if (requiredNumberOfInputs == null && !this.hasInputPort(portName)) break;
            sourceMats.add(this.getInputMat(k));
        }
        if (this.dimensionsEqualityRequired()) {
            OTools.checkDimensionOfNonNullMatEquality(sourceMats);
        }
        this.setStartProcessingTimeStamp();
        Mat target = this.process(sourceMats.toArray(new Mat[0]));
        this.setEndProcessingTimeStamp();
        this.setOutputTo(target);
    }

    public Mat getInputMat(int inputIndex) {
        SMat inputMat = this.getInputMat(this.inputPortName(inputIndex), this.allowUninitializedInput(inputIndex));
        return inputMat.isInitialized() ? O2SMat.toMat(inputMat, this.allowInputPackedBits(inputIndex)) : null;
    }

    public void setOutputTo(Mat result) {
        if (this.packOutputBits()) {
            this.getMat().setTo((MultiMatrix)O2SMat.toBinaryMatrix(result));
        } else {
            O2SMat.setTo(this.getMat(), result);
        }
    }

    public abstract Mat process(Mat[] var1);

    protected Integer requiredNumberOfInputs() {
        return 2;
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return true;
    }

    protected String inputPortName(int inputIndex) {
        return INPUT_PORT_PREFIX + (inputIndex + 1);
    }

    protected boolean allowInputPackedBits(int inputIndex) {
        return false;
    }

    protected boolean dimensionsEqualityRequired() {
        return true;
    }

    protected boolean packOutputBits() {
        return false;
    }
}

