/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.enums.OInterpolation;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;

public abstract class MatFilter
extends OpenCVExecutor {
    double optimizingScale = 1.0;
    OInterpolation compressionInterpolation = OInterpolation.INTER_AREA;
    OInterpolation stretchingInterpolation = OInterpolation.INTER_NEAREST;
    int sourceDimX;
    int sourceDimY;

    protected MatFilter() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public final double getOptimizingScale() {
        return this.optimizingScale;
    }

    public final MatFilter setOptimizingScale(double optimizingScale) {
        if (optimizingScale < 1.0) {
            throw new IllegalArgumentException("Scale for faster processing " + optimizingScale + " must be >= 1.0");
        }
        this.optimizingScale = optimizingScale;
        return this;
    }

    public OInterpolation getCompressionInterpolation() {
        return this.compressionInterpolation;
    }

    public MatFilter setCompressionInterpolation(OInterpolation compressionInterpolation) {
        this.compressionInterpolation = (OInterpolation)((Object)MatFilter.nonNull((Object)((Object)compressionInterpolation)));
        return this;
    }

    public OInterpolation getStretchingInterpolation() {
        return this.stretchingInterpolation;
    }

    public MatFilter setStretchingInterpolation(OInterpolation stretchingInterpolation) {
        this.stretchingInterpolation = (OInterpolation)((Object)MatFilter.nonNull((Object)((Object)stretchingInterpolation)));
        return this;
    }

    public void process() {
        Mat source = O2SMat.toMat(this.getInputMat(this.allowUninitializedInput()), this.allowInputPackedBits());
        this.setOutputTo(this.processWithCompression(source));
    }

    public Mat processWithCompression(Mat source) {
        this.sourceDimX = source != null ? source.cols() : -1;
        this.sourceDimY = source != null ? source.rows() : -1;
        Mat compressedSource = this.compressOriginal(source);
        this.setStartProcessingTimeStamp();
        Mat compressedResult = this.process(compressedSource);
        this.setEndProcessingTimeStamp();
        Mat result = this.stretchToOriginal(compressedResult);
        if (result != compressedResult) {
            compressedResult.close();
            if (compressedSource != null) {
                compressedSource.close();
            }
        }
        return result;
    }

    public void setOutputTo(Mat result) {
        if (this.packOutputBits()) {
            this.getMat().setTo((MultiMatrix)O2SMat.toBinaryMatrix(result));
        } else {
            O2SMat.setTo(this.getMat(), result);
        }
    }

    public abstract Mat process(Mat var1);

    public final Mat compressOriginal(Mat mat) {
        if (mat == null || this.optimizingScale <= 1.0) {
            return mat;
        }
        Mat result = new Mat();
        double fxy = 1.0 / this.optimizingScale;
        try (Size size = new Size();){
            opencv_imgproc.resize((Mat)mat, (Mat)result, (Size)size, (double)fxy, (double)fxy, (int)this.compressionInterpolation.code());
        }
        return result;
    }

    public final Mat stretchToOriginal(Mat mat) {
        if (mat == null || this.optimizingScale <= 1.0 || this.sourceDimX == mat.cols() && this.sourceDimY == mat.rows()) {
            return mat;
        }
        Mat result = new Mat();
        try (Size size = new Size(this.sourceDimX, this.sourceDimY);){
            opencv_imgproc.resize((Mat)mat, (Mat)result, (Size)size, (double)0.0, (double)0.0, (int)this.stretchingInterpolation.code());
        }
        return result;
    }

    protected boolean allowUninitializedInput() {
        return false;
    }

    protected boolean allowInputPackedBits() {
        return false;
    }

    protected boolean packOutputBits() {
        return false;
    }
}

