/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutablePNumberArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.AbstractScanAndMeasureBoundaries;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundariesScanner;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryParameter;
import net.algart.math.functions.Func;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DSimpleMeasurer;
import net.algart.matrices.scanning.ContourLineType;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ScanAndMeasureBoundaries
extends AbstractScanAndMeasureBoundaries {
    public static final String OUTPUT_OBJECT_LABEL = "object_label";
    public static final String OUTPUT_AREA = "area";
    public static final String OUTPUT_SQRT_AREA = "sqrt_area";
    public static final String OUTPUT_PERIMETER = "perimeter";
    public static final String OUTPUT_SIZE = "size";
    public static final String OUTPUT_SHAPE_FACTOR = "shape_factor";
    public static final String OUTPUT_CONTAINING_OCTAGON_AREA = "containing_octagon_area";
    public static final String OUTPUT_CENTROID = "centroid";
    public static final String OUTPUT_CONTAINING_RECTANGLE = "containing_rectangle";
    public static final String OUTPUT_INTERNAL_BOUNDARY = "internal_boundary";
    public static final String OUTPUT_NESTING_LEVEL = "nesting_level";
    public static final String OUTPUT_NUMBER_OF_OBJECTS = "number_of_objects";
    private static final Map<String, BoundaryParameter> OUTPUT_STATISTICS = new LinkedHashMap<String, BoundaryParameter>();

    public ScanAndMeasureBoundaries() {
        for (String port : OUTPUT_STATISTICS.keySet()) {
            this.addOutputNumbers(port);
        }
        this.addOutputNumbers(OUTPUT_OBJECT_LABEL);
        this.addOutputNumbers(OUTPUT_INTERNAL_BOUNDARY);
        this.addOutputScalar(OUTPUT_NUMBER_OF_OBJECTS);
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        Map<BoundaryParameter, SNumbers> resultStatistics = ScanAndMeasureBoundaries.convertMap(this.allOutputContainers(SNumbers.class, true));
        return this.analyse(resultStatistics, BoundariesScanner.toObjects((MultiMatrix)source, this.objectsInterpretation.binaryOnly()), this.isOutputNecessary(this.defaultOutputPortName()));
    }

    public MultiMatrix2D analyse(Map<BoundaryParameter, SNumbers> resultStatistics, Matrix<? extends PFixedArray> objects, boolean resultLabelsRequired) {
        int k;
        Set<BoundaryParameter> parameters = resultStatistics.keySet();
        BoundaryParameter[] parametersArray = parameters.toArray(new BoundaryParameter[0]);
        MutablePNumberArray[] statisticsArray = new MutablePNumberArray[resultStatistics.size()];
        for (int k2 = 0; k2 < parametersArray.length; ++k2) {
            statisticsArray[k2] = parametersArray[k2] == BoundaryParameter.NESTING_LEVEL ? Arrays.SMM.newIntArray(0L) : Arrays.SMM.newFloatArray(0L);
        }
        MutableIntArray objectLabelArray = Arrays.SMM.newEmptyIntArray();
        MutableBitArray internalBoundaryFlags = Arrays.SMM.newEmptyBitArray();
        BoundariesScanner scanner = new BoundariesScanner(objects, this.getConnectivityType(), this.getBoundaryType(), BoundaryParameter.needSecondBuffer(parameters), resultLabelsRequired, this.getMaxLabelLevelOrMaxValue());
        Boundary2DSimpleMeasurer measurer = Boundary2DSimpleMeasurer.getInstance((Boundary2DScanner)scanner.getBoundaryScanner(), (ContourLineType)this.getContourLineType(), BoundaryParameter.objectParameters(parameters));
        scanner.setBoundaryMeasurer((Boundary2DScanner)measurer);
        scanner.setProcessBackgroundAsObject(this.getObjectsInterpretation().processBackgroundAsObject());
        while (scanner.nextBoundary()) {
            scanner.scanAndProcess();
            if (!scanner.needToAnalyseThisBoundary()) continue;
            objectLabelArray.pushInt(scanner.currentLabel());
            internalBoundaryFlags.pushBit(scanner.internalBoundary());
            for (k = 0; k < parametersArray.length; ++k) {
                parametersArray[k].getStatistics(statisticsArray[k], measurer, this.getPixelSize());
            }
        }
        ScanAndMeasureBoundaries.uploadSimpleOutputs((Executor)this, scanner, (IntArray)objectLabelArray, (BitArray)internalBoundaryFlags);
        ScanAndMeasureBoundaries.logDebug(() -> "Scanned " + scanner.objectCounter() + " boundaries, " + scanner.sideCounter() + " pixel sides for calculating " + parametersArray.length + " parameters " + parameters + " at " + objects);
        for (k = 0; k < parametersArray.length; ++k) {
            BoundaryParameter p = parametersArray[k];
            resultStatistics.get((Object)p).setTo((PNumberArray)statisticsArray[k], p.parameterLength());
        }
        return ScanAndMeasureBoundaries.getLabels(scanner);
    }

    static void uploadSimpleOutputs(Executor executor, BoundariesScanner scanner, IntArray objectLabelArray, BitArray internalBoundaryFlags) {
        if (executor.isOutputNecessary(OUTPUT_OBJECT_LABEL)) {
            executor.getNumbers(OUTPUT_OBJECT_LABEL).setTo((PNumberArray)objectLabelArray, 1);
        }
        if (executor.isOutputNecessary(OUTPUT_INTERNAL_BOUNDARY)) {
            executor.getNumbers(OUTPUT_INTERNAL_BOUNDARY).setTo((PNumberArray)Arrays.asFuncArray((Func)Func.IDENTITY, ByteArray.class, (PArray[])new PArray[]{internalBoundaryFlags}), 1);
        }
        executor.getScalar(OUTPUT_NUMBER_OF_OBJECTS).setTo(scanner.objectCounter());
    }

    static MultiMatrix2D getLabels(BoundariesScanner scanner) {
        Matrix<? extends PArray> labels = scanner.getLabels();
        return labels == null ? null : MultiMatrix.valueOf2DMono(labels);
    }

    private static Map<BoundaryParameter, SNumbers> convertMap(Map<String, SNumbers> statistics) {
        LinkedHashMap<BoundaryParameter, SNumbers> result = new LinkedHashMap<BoundaryParameter, SNumbers>();
        statistics.forEach((s, numbers) -> {
            BoundaryParameter parameter = OUTPUT_STATISTICS.get(s);
            if (parameter != null) {
                result.put(parameter, (SNumbers)numbers);
            }
        });
        return result;
    }

    static {
        OUTPUT_STATISTICS.put(OUTPUT_AREA, BoundaryParameter.AREA);
        OUTPUT_STATISTICS.put(OUTPUT_SQRT_AREA, BoundaryParameter.SQRT_AREA);
        OUTPUT_STATISTICS.put(OUTPUT_PERIMETER, BoundaryParameter.PERIMETER);
        OUTPUT_STATISTICS.put(OUTPUT_SIZE, BoundaryParameter.SIZE);
        OUTPUT_STATISTICS.put(OUTPUT_SHAPE_FACTOR, BoundaryParameter.SHAPE_FACTOR);
        OUTPUT_STATISTICS.put(OUTPUT_CONTAINING_OCTAGON_AREA, BoundaryParameter.CONTAINING_OCTAGON_AREA);
        OUTPUT_STATISTICS.put(OUTPUT_CENTROID, BoundaryParameter.CENTROID);
        OUTPUT_STATISTICS.put(OUTPUT_CONTAINING_RECTANGLE, BoundaryParameter.CONTAINING_RECTANGLE);
        OUTPUT_STATISTICS.put(OUTPUT_NESTING_LEVEL, BoundaryParameter.NESTING_LEVEL);
    }
}

