/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Collection;
import java.util.Objects;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutablePNumberArray;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryParameter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.SecondProjectionValue;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ThirdProjectionValue;
import net.algart.matrices.scanning.Boundary2DProjectionMeasurer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProjectionParameter {
    AREA{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            return measurer.area() * (pixelSize * pixelSize);
        }
    }
    ,
    PERIMETER{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            return measurer.perimeter() * pixelSize;
        }
    }
    ,
    ALL_PROJECTIONS{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            if (result instanceof FloatArray) {
                MutableFloatArray a = (MutableFloatArray)result;
                int m = measurer.numberOfDirections();
                for (int k = 0; k < m; ++k) {
                    a.pushFloat((float)(measurer.projectionLength(k) * pixelSize));
                }
            } else if (result instanceof DoubleArray) {
                MutableDoubleArray a = (MutableDoubleArray)result;
                int m = measurer.numberOfDirections();
                for (int k = 0; k < m; ++k) {
                    a.pushDouble(measurer.projectionLength(k) * pixelSize);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported type of " + result);
            }
        }
    }
    ,
    SELECTED_PROJECTION{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            ProjectionParameter.pushProjectionPair(result, measurer, 0, pixelSize, second, third);
        }
    }
    ,
    MEAN_PROJECTION{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            return measurer.meanProjectionLength() * pixelSize;
        }
    }
    ,
    MAX_PROJECTION{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            ProjectionParameter.pushProjectionPair(result, measurer, measurer.indexOfMaxProjectionLength(), pixelSize, second, third);
        }
    }
    ,
    MIN_PROJECTION{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            ProjectionParameter.pushProjectionPair(result, measurer, measurer.indexOfMinProjectionLength(), pixelSize, second, third);
        }
    }
    ,
    MAX_SIZE_RELATION{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            int m = measurer.numberOfDirections();
            int index = -1;
            double maxRelation = Double.NEGATIVE_INFINITY;
            int i = m / 2;
            for (int k = 0; k < m; ++k) {
                double relation = measurer.projectionLength(k) / measurer.projectionLength(i);
                if (relation > maxRelation) {
                    index = k;
                    maxRelation = relation;
                }
                i = (i + 1) % m;
            }
            ProjectionParameter.pushProjectionPair(result, measurer, index, pixelSize, second, third);
        }
    }
    ,
    MIN_CIRCUMSCRIBED_SQUARE_SIDE{

        @Override
        public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
            ProjectionParameter.pushProjectionPair(result, measurer, measurer.indexOfMinCircumscribedRhombus(measurer.numberOfDirections() / 2), pixelSize, second, third);
        }
    }
    ,
    SHAPE_FACTOR{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            return BoundaryParameter.shapeFactorCircularity(measurer.area(), measurer.perimeter());
        }
    }
    ,
    COMPACT_FACTOR{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            double meanProjection = measurer.meanProjectionLength();
            double meanCircleArea = 0.7853981633974483 * meanProjection * meanProjection;
            return measurer.area() / meanCircleArea;
        }
    }
    ,
    IRREGULARITY_FACTOR{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            double meanCircleLength = Math.PI * measurer.meanProjectionLength();
            return meanCircleLength / measurer.perimeter();
        }
    }
    ,
    NESTING_LEVEL{

        @Override
        double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
            return measurer.nestingLevel();
        }
    };


    double getStatistics(Boundary2DProjectionMeasurer measurer, double pixelSize) {
        throw new UnsupportedOperationException();
    }

    public void getStatistics(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
        if (result instanceof IntArray) {
            ((MutableIntArray)result).pushInt((int)this.getStatistics(measurer, pixelSize));
        } else if (result instanceof FloatArray) {
            ((MutableFloatArray)result).pushFloat((float)this.getStatistics(measurer, pixelSize));
        } else if (result instanceof DoubleArray) {
            ((MutableDoubleArray)result).pushDouble(this.getStatistics(measurer, pixelSize));
        } else {
            throw new UnsupportedOperationException("Unsupported type of " + result);
        }
    }

    public static boolean needSecondBuffer(Collection<ProjectionParameter> parameters) {
        Objects.requireNonNull(parameters, "Null parameters");
        return parameters.contains((Object)NESTING_LEVEL);
    }

    private static void pushProjectionPair(MutablePNumberArray result, Boundary2DProjectionMeasurer measurer, int i1, double pixelSize, SecondProjectionValue second, ThirdProjectionValue third) {
        int m = measurer.numberOfDirections();
        int i2 = (i1 + m / 2) % m;
        double pr1 = measurer.projectionLength(i1) * pixelSize;
        double pr2 = measurer.projectionLength(i2) * pixelSize;
        if (result instanceof FloatArray) {
            MutableFloatArray a = (MutableFloatArray)result;
            a.pushFloat((float)pr1);
            a.pushFloat((float)second.secondProjectionValue(pr1, pr2));
            Double thirdProjectionValue = third.thirdProjectionValue(measurer, i1, pixelSize);
            if (thirdProjectionValue != null) {
                a.pushFloat((float)thirdProjectionValue.doubleValue());
            }
        } else if (result instanceof DoubleArray) {
            MutableDoubleArray a = (MutableDoubleArray)result;
            a.pushDouble(pr1);
            a.pushDouble(second.secondProjectionValue(pr1, pr2));
            Double thirdProjectionValue = third.thirdProjectionValue(measurer, i1, pixelSize);
            if (thirdProjectionValue != null) {
                a.pushDouble(thirdProjectionValue.doubleValue());
            }
        } else {
            throw new UnsupportedOperationException("Unsupported type of " + result);
        }
    }
}

