/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.executors.modules.core.matrices.io.ReadImage;
import net.algart.executors.modules.core.matrices.io.WriteImage;
import net.algart.executors.modules.core.matrices.misc.Contrast;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ScanAndMeasureBoundaries;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ScanAndMeasureBoundariesTest {
    public static void main(String[] args) {
        MultiMatrix2D labels;
        MultiMatrix2D multiMatrix;
        if (args.length < 2) {
            System.out.printf("Usage: %s source_image target_labels_image%n", ScanAndMeasureBoundariesTest.class.getName());
            return;
        }
        double sum1 = 0.0;
        sum1 += 5.0;
        sum1 += Boundary2DScanner.Step.DIAGONAL_LENGTH;
        sum1 += 3.0;
        sum1 += Boundary2DScanner.Step.DIAGONAL_LENGTH;
        sum1 += 5.0;
        sum1 += Boundary2DScanner.Step.DIAGONAL_LENGTH;
        sum1 += 3.0;
        double sum2 = 16.0 + 4.0 * Boundary2DScanner.Step.DIAGONAL_LENGTH;
        System.out.printf("sum1: %.20f%nsum2: %.20f%n", sum1 += Boundary2DScanner.Step.DIAGONAL_LENGTH, sum2);
        try (ReadImage readImage = new ReadImage().setFile(args[0]);){
            readImage.process();
            multiMatrix = readImage.getMat().toMultiMatrix2D();
        }
        try (ScanAndMeasureBoundaries scan = new ScanAndMeasureBoundaries();){
            scan.requestOutput(new String[]{"labels"});
            scan.requestOutput(new String[]{"area", "perimeter"});
            scan.process(multiMatrix);
            System.out.printf("Areas:%n%s%n", scan.getNumbers("area"));
            System.out.printf("Perimeters:%n%s%n", scan.getNumbers("perimeter"));
            labels = scan.process(multiMatrix);
        }
        labels = new Contrast().process((MultiMatrix)labels).asMultiMatrix2D();
        try (WriteImage writeImage = new WriteImage();){
            writeImage.getInputMatContainer().setTo((MultiMatrix)labels);
            writeImage.setFile(args[1]).process();
        }
    }
}

