/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.editor.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.akehurst.language.api.processor.LanguageProcessor;
import net.akehurst.language.api.sppt.SPPTLeaf;
import net.akehurst.language.api.sppt.SharedPackedParseTree;
import net.akehurst.language.editor.common.AglComponents;
import net.akehurst.language.editor.common.AglLineState;
import net.akehurst.language.editor.common.AglToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rJ\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\rJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lnet/akehurst/language/editor/common/AglTokenizer;", "", "agl", "Lnet/akehurst/language/editor/common/AglComponents;", "(Lnet/akehurst/language/editor/common/AglComponents;)V", "getAgl", "()Lnet/akehurst/language/editor/common/AglComponents;", "getLineTokens", "Lnet/akehurst/language/editor/common/AglLineState;", "lineText", "", "pState", "line", "", "getLineTokensByParse", "state", "row", "getLineTokensByScan", "mapToCssClasses", "", "leaf", "Lnet/akehurst/language/api/sppt/SPPTLeaf;", "mapTokenTypeToClass", "tokenType", "transformToTokens", "Lnet/akehurst/language/editor/common/AglToken;", "leafs", "agl-editor-common"})
public final class AglTokenizer {
    @NotNull
    private final AglComponents agl;

    public AglTokenizer(@NotNull AglComponents agl) {
        Intrinsics.checkNotNullParameter((Object)agl, (String)"agl");
        this.agl = agl;
    }

    @NotNull
    public final AglComponents getAgl() {
        return this.agl;
    }

    @NotNull
    public final AglLineState getLineTokens(@NotNull String lineText, @NotNull AglLineState pState, int line) {
        Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        SharedPackedParseTree sppt = this.agl.getSppt();
        return sppt == null ? this.getLineTokensByScan(lineText, pState, line) : this.getLineTokensByParse(lineText, pState, line);
    }

    private final String mapTokenTypeToClass(String tokenType) {
        String cssClass = this.agl.getStyleHandler().mapClass(tokenType);
        return cssClass;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> mapToCssClasses(SPPTLeaf leaf) {
        List list;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = leaf.getMetaTags();
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            string = this.mapTokenTypeToClass((String)it);
            collection.add(string);
        }
        List metaTagClasses = (List)destination$iv$iv2;
        if (!leaf.getTagList().isEmpty()) {
            $this$map$iv = leaf.getTagList();
            $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                string = this.mapTokenTypeToClass((String)it);
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            $this$map$iv = CollectionsKt.listOf((Object)this.mapTokenTypeToClass(leaf.getName()));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = it;
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        List otherClasses = list;
        List classes = CollectionsKt.plus((Collection)metaTagClasses, (Iterable)otherClasses);
        return classes.isEmpty() ? CollectionsKt.listOf((Object)"nostyle") : CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)classes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AglToken> transformToTokens(@NotNull List<? extends SPPTLeaf> leafs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(leafs, (String)"leafs");
        Iterable $this$map$iv = leafs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void leaf;
            SPPTLeaf sPPTLeaf = (SPPTLeaf)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<String> cssClasses = this.mapToCssClasses((SPPTLeaf)leaf);
            String beforeEOL = leaf.getMatchedText();
            int eolIndex = StringsKt.indexOf$default((CharSequence)leaf.getMatchedText(), (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (-1 != eolIndex) {
                String string = leaf.getMatchedText();
                int n = 0;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, eolIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                beforeEOL = string3;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.toSet((Iterable)cssClasses);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            AglToken aglToken = new AglToken(stringArray, beforeEOL, leaf.getLocation().getLine(), leaf.getLocation().getColumn());
            collection.add(aglToken);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final AglLineState getLineTokensByScan(@NotNull String lineText, @NotNull AglLineState state, int row) {
        Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        LanguageProcessor proc = this.agl.getLanguageDefinition().getProcessor();
        if (proc != null) {
            AglLineState aglLineState;
            String text = Intrinsics.stringPlus((String)state.getLeftOverText(), (Object)lineText);
            List leafs = proc.scan(text);
            List<AglToken> tokens = this.transformToTokens(leafs);
            if (leafs.isEmpty()) {
                aglLineState = new AglLineState(row, "", CollectionsKt.emptyList());
            } else {
                SPPTLeaf lastLeaf = (SPPTLeaf)CollectionsKt.last((List)leafs);
                int endOfLastLeaf = lastLeaf.getLocation().getColumn() + lastLeaf.getLocation().getLength();
                String string = lineText;
                int n = lineText.length();
                boolean bl = false;
                String string2 = string.substring(endOfLastLeaf, n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String leftOverText = string2;
                aglLineState = new AglLineState(row, leftOverText, tokens);
            }
            AglLineState endState = aglLineState;
            return endState;
        }
        boolean $i$f$emptyArray = false;
        return new AglLineState(row, "", CollectionsKt.listOf((Object)new AglToken((String[])((Object[])new String[0]), lineText, row, 0)));
    }

    @NotNull
    public final AglLineState getLineTokensByParse(@NotNull String lineText, @NotNull AglLineState state, int row) {
        Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SharedPackedParseTree sharedPackedParseTree = this.agl.getSppt();
        Intrinsics.checkNotNull((Object)sharedPackedParseTree);
        SharedPackedParseTree sppt = sharedPackedParseTree;
        List leafs = sppt.tokensByLine(row);
        List<AglToken> tokens = this.transformToTokens(leafs);
        AglLineState endState = new AglLineState(row, "", tokens);
        return endState;
    }
}

