/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.editor.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.akehurst.language.api.sppt.SPPTLeaf;
import net.akehurst.language.editor.common.AglToken;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u0014R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/akehurst/language/editor/common/AglStyleHandler;", "", "languageId", "", "cssClassPrefixStart", "(Ljava/lang/String;Ljava/lang/String;)V", "aglStyleClass", "getAglStyleClass", "()Ljava/lang/String;", "cssClassPrefix", "getCssClassPrefixStart", "cssLanguageId", "getCssLanguageId", "nextCssClassNum", "", "tokenToClassMap", "", "mapClass", "aglSelector", "mapToCssClasses", "", "leaf", "Lnet/akehurst/language/api/sppt/SPPTLeaf;", "mapTokenTypeToClass", "tokenType", "reset", "", "transformToTokens", "Lnet/akehurst/language/editor/common/AglToken;", "leafs", "Companion", "agl-editor-common"})
public final class AglStyleHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String cssClassPrefixStart;
    @NotNull
    private final String cssLanguageId;
    @NotNull
    private final String aglStyleClass;
    private int nextCssClassNum;
    @NotNull
    private final String cssClassPrefix;
    @NotNull
    private final Map<String, String> tokenToClassMap;

    public AglStyleHandler(@NotNull String languageId, @NotNull String cssClassPrefixStart) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)cssClassPrefixStart, (String)"cssClassPrefixStart");
        this.cssClassPrefixStart = cssClassPrefixStart;
        CharSequence charSequence = languageId;
        Regex regex = new Regex("[^a-z0-9A-Z_-]");
        String string = "_";
        boolean bl = false;
        this.cssLanguageId = regex.replace(charSequence, string);
        this.aglStyleClass = Companion.languageIdToStyleClass(this.cssClassPrefixStart, languageId);
        this.nextCssClassNum = 1;
        this.cssClassPrefix = Intrinsics.stringPlus((String)this.aglStyleClass, (Object)"-");
        boolean bl2 = false;
        this.tokenToClassMap = new LinkedHashMap();
    }

    public /* synthetic */ AglStyleHandler(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "agl";
        }
        this(string, string2);
    }

    @NotNull
    public final String getCssClassPrefixStart() {
        return this.cssClassPrefixStart;
    }

    @NotNull
    public final String getCssLanguageId() {
        return this.cssLanguageId;
    }

    @NotNull
    public final String getAglStyleClass() {
        return this.aglStyleClass;
    }

    private final String mapTokenTypeToClass(String tokenType) {
        String cssClass = this.tokenToClassMap.get(tokenType);
        return cssClass;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> mapToCssClasses(SPPTLeaf leaf) {
        List list;
        boolean bl;
        Object element$iv$iv$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        boolean bl2;
        void $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv2 = leaf.getMetaTags();
        boolean $i$f$mapNotNull2 = false;
        Iterable iterable = $this$mapNotNull$iv2;
        Iterable<String> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl3 = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            if (this.mapTokenTypeToClass(it) == null) continue;
            boolean bl5 = false;
            bl2 = false;
            String it$iv$iv = string;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List metaTagClasses = (List)destination$iv$iv2;
        if (!leaf.getTagList().isEmpty()) {
            $this$mapNotNull$iv = leaf.getTagList();
            $i$f$mapNotNull = false;
            destination$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl7 = false;
                String it = (String)element$iv$iv;
                boolean bl8 = false;
                if (this.mapTokenTypeToClass(it) == null) continue;
                bl2 = false;
                boolean bl9 = false;
                String it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            $this$mapNotNull$iv = CollectionsKt.listOf((Object)this.mapTokenTypeToClass(leaf.getName()));
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl10 = false;
                String it = (String)element$iv$iv;
                boolean bl11 = false;
                if (it == null) continue;
                bl2 = false;
                boolean bl12 = false;
                String it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List otherClasses = list;
        List classes = CollectionsKt.plus((Collection)metaTagClasses, (Iterable)otherClasses);
        return classes.isEmpty() ? CollectionsKt.listOf((Object)"nostyle") : CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)classes));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AglToken> transformToTokens(@NotNull List<? extends SPPTLeaf> leafs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(leafs, (String)"leafs");
        Iterable $this$map$iv = leafs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void leaf;
            SPPTLeaf sPPTLeaf = (SPPTLeaf)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<String> cssClasses = this.mapToCssClasses((SPPTLeaf)leaf);
            String beforeEOL = leaf.getMatchedText();
            int eolIndex = StringsKt.indexOf$default((CharSequence)leaf.getMatchedText(), (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (-1 != eolIndex) {
                String string = leaf.getMatchedText();
                int n = 0;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, eolIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                beforeEOL = string3;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.toSet((Iterable)cssClasses);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            AglToken aglToken = new AglToken(stringArray, beforeEOL, leaf.getLocation().getLine(), leaf.getLocation().getColumn());
            collection.add(aglToken);
        }
        return (List)destination$iv$iv;
    }

    public final void reset() {
        this.tokenToClassMap.clear();
        this.nextCssClassNum = 1;
    }

    @NotNull
    public final String mapClass(@NotNull String aglSelector) {
        Intrinsics.checkNotNullParameter((Object)aglSelector, (String)"aglSelector");
        String cssClass = this.tokenToClassMap.get(aglSelector);
        if (cssClass == null) {
            Object object = this;
            int n = ((AglStyleHandler)object).nextCssClassNum;
            ((AglStyleHandler)object).nextCssClassNum = n + 1;
            cssClass = Intrinsics.stringPlus((String)this.cssClassPrefix, (Object)n);
            object = this.tokenToClassMap;
            n = 0;
            object.put(aglSelector, cssClass);
        }
        return cssClass;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lnet/akehurst/language/editor/common/AglStyleHandler$Companion;", "", "()V", "languageIdToStyleClass", "", "cssClassPrefixStart", "languageId", "agl-editor-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String languageIdToStyleClass(@NotNull String cssClassPrefixStart, @NotNull String languageId) {
            Intrinsics.checkNotNullParameter((Object)cssClassPrefixStart, (String)"cssClassPrefixStart");
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            CharSequence charSequence = languageId;
            Regex regex = new Regex("[^a-z0-9A-Z_-]");
            String string = "_";
            boolean bl = false;
            String cssLangId = regex.replace(charSequence, string);
            return cssClassPrefixStart + '_' + cssLangId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

