/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.editor.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.akehurst.language.api.processor.LanguageDefinition;
import net.akehurst.language.editor.api.AglEditor;
import net.akehurst.language.editor.api.AglEditorLogger;
import net.akehurst.language.editor.api.LogLevel;
import net.akehurst.language.editor.api.ParseEvent;
import net.akehurst.language.editor.api.ProcessEvent;
import net.akehurst.language.editor.common.AglComponents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JJ\u0010'\u001a4\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(-\u0012\u0004\u0012\u00020\u000b\u0018\u00010(2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0003H\u0004J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\nH\u0004J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\rH\u0004J\u001c\u00101\u001a\u00020\u000b2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\u001c\u00103\u001a\u00020\u000b2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\b\u00104\u001a\u00020\u000bH$J\u0012\u00105\u001a\u00020\u000b2\b\u00106\u001a\u0004\u0018\u00010\u0003H$J\b\u00107\u001a\u00020\u000bH$R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0018R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lnet/akehurst/language/editor/common/AglEditorAbstract;", "Lnet/akehurst/language/editor/api/AglEditor;", "languageId", "", "editorId", "(Ljava/lang/String;Ljava/lang/String;)V", "_editorSpecificStyleStr", "_onParseHandler", "", "Lkotlin/Function1;", "Lnet/akehurst/language/editor/api/ParseEvent;", "", "_onProcessHandler", "Lnet/akehurst/language/editor/api/ProcessEvent;", "agl", "Lnet/akehurst/language/editor/common/AglComponents;", "getAgl", "()Lnet/akehurst/language/editor/common/AglComponents;", "getEditorId", "()Ljava/lang/String;", "value", "editorSpecificStyleStr", "getEditorSpecificStyleStr", "setEditorSpecificStyleStr", "(Ljava/lang/String;)V", "goalRuleName", "getGoalRuleName", "setGoalRuleName", "languageDefinition", "Lnet/akehurst/language/api/processor/LanguageDefinition;", "getLanguageDefinition", "()Lnet/akehurst/language/api/processor/LanguageDefinition;", "languageIdentity", "getLanguageIdentity", "setLanguageIdentity", "logger", "Lnet/akehurst/language/editor/api/AglEditorLogger;", "getLogger", "()Lnet/akehurst/language/editor/api/AglEditorLogger;", "log", "Lkotlin/Function2;", "Lnet/akehurst/language/editor/api/LogLevel;", "Lkotlin/ParameterName;", "name", "level", "message", "notifyParse", "event", "notifyProcess", "onParse", "handler", "onProcess", "updateGrammar", "updateLanguage", "oldId", "updateStyle", "agl-editor-common"})
public abstract class AglEditorAbstract
implements AglEditor {
    @NotNull
    private final String editorId;
    @NotNull
    private final AglEditorLogger logger;
    @NotNull
    private final AglComponents agl;
    @NotNull
    private final List<Function1<ParseEvent, Unit>> _onParseHandler;
    @NotNull
    private final List<Function1<ProcessEvent, Unit>> _onProcessHandler;
    @Nullable
    private String _editorSpecificStyleStr;

    public AglEditorAbstract(@NotNull String languageId, @NotNull String editorId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        this.editorId = editorId;
        this.logger = new AglEditorLogger();
        this.agl = new AglComponents(languageId, this.getEditorId(), this.getLogger());
        this.agl.getLanguageDefinition().getGrammarObservers().add(new Function2<String, String, Unit>(){

            public final void invoke(@Nullable String $noName_0, @Nullable String $noName_1) {
                this.updateGrammar();
                this.updateStyle();
            }
        });
        this.agl.getLanguageDefinition().getStyleObservers().add(new Function2<String, String, Unit>(){

            public final void invoke(@Nullable String $noName_0, @Nullable String $noName_1) {
                this.updateStyle();
            }
        });
        boolean bl = false;
        this._onParseHandler = new ArrayList();
        bl = false;
        this._onProcessHandler = new ArrayList();
    }

    @NotNull
    public String getEditorId() {
        return this.editorId;
    }

    @NotNull
    public AglEditorLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final AglComponents getAgl() {
        return this.agl;
    }

    @NotNull
    public String getLanguageIdentity() {
        return this.agl.getLanguageIdentity();
    }

    public void setLanguageIdentity(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String oldId = this.agl.getLanguageIdentity();
        this.agl.setLanguageIdentity(value);
        this.updateLanguage(oldId);
        this.updateStyle();
    }

    @NotNull
    public LanguageDefinition getLanguageDefinition() {
        return this.agl.getLanguageDefinition();
    }

    @Nullable
    public String getGoalRuleName() {
        return this.agl.getGoalRule();
    }

    public void setGoalRuleName(@Nullable String value) {
        this.agl.setGoalRule(value);
    }

    @Nullable
    public String getEditorSpecificStyleStr() {
        String string = this._editorSpecificStyleStr;
        return string == null ? this.agl.getLanguageDefinition().getStyle() : string;
    }

    public void setEditorSpecificStyleStr(@Nullable String value) {
        this._editorSpecificStyleStr = value;
        this.updateStyle();
    }

    public void onParse(@NotNull Function1<? super ParseEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this._onParseHandler.add(handler);
    }

    @Nullable
    protected final Function2<LogLevel, String, Unit> log(@NotNull LogLevel level, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.getLogger().log(level, message);
    }

    protected final void notifyParse(@NotNull ParseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = this._onParseHandler;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)event);
        }
    }

    public void onProcess(@NotNull Function1<? super ProcessEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this._onProcessHandler.add(handler);
    }

    protected final void notifyProcess(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = this._onProcessHandler;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)event);
        }
    }

    protected abstract void updateLanguage(@Nullable String var1);

    protected abstract void updateGrammar();

    protected abstract void updateStyle();
}

