/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.collections;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB\u0015\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0013\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0013\u001a\u00020\rH\u0016J\u000b\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\r\u0010\u0016\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lnet/akehurst/language/collections/Stack;", "T", "", "elements", "", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "isEmpty", "", "()Z", "isNotEmpty", "size", "", "getSize", "()I", "clone", "equals", "other", "hashCode", "peek", "()Ljava/lang/Object;", "peekOrNull", "pop", "Lnet/akehurst/language/collections/Stack$PopResult;", "push", "item", "(Ljava/lang/Object;)Lnet/akehurst/language/collections/Stack;", "pushAll", "items", "PopResult", "agl-processor"})
public final class Stack<T> {
    @NotNull
    private final List<T> elements;

    public Stack(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.elements = elements;
    }

    public /* synthetic */ Stack(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final List<T> getElements() {
        return this.elements;
    }

    public final int getSize() {
        return this.elements.size();
    }

    public final boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public final boolean isNotEmpty() {
        return this.elements.size() != 0;
    }

    @NotNull
    public final Stack<T> push(T item) {
        return new Stack<T>(CollectionsKt.plus((Collection)this.elements, item));
    }

    @NotNull
    public final Stack<T> pushAll(@NotNull List<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return new Stack<T>(CollectionsKt.plus((Collection)this.elements, (Iterable)items));
    }

    public final T peek() {
        return (T)CollectionsKt.last(this.elements);
    }

    @Nullable
    public final T peekOrNull() {
        return (T)CollectionsKt.lastOrNull(this.elements);
    }

    @NotNull
    public final PopResult<T> pop() {
        return new PopResult<T>(this.peek(), new Stack<T>(this.elements.subList(0, this.getSize() - 1)));
    }

    @NotNull
    public final Stack<T> clone() {
        return new Stack<T>(this.elements);
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof Stack) ? false : Intrinsics.areEqual(this.elements, ((Stack)other).elements);
    }

    public Stack() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/akehurst/language/collections/Stack$PopResult;", "T", "", "item", "stack", "Lnet/akehurst/language/collections/Stack;", "(Ljava/lang/Object;Lnet/akehurst/language/collections/Stack;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStack", "()Lnet/akehurst/language/collections/Stack;", "agl-processor"})
    public static final class PopResult<T> {
        private final T item;
        @NotNull
        private final Stack<T> stack;

        public PopResult(T item, @NotNull Stack<T> stack) {
            Intrinsics.checkNotNullParameter(stack, (String)"stack");
            this.item = item;
            this.stack = stack;
        }

        public final T getItem() {
            return this.item;
        }

        @NotNull
        public final Stack<T> getStack() {
            return this.stack;
        }
    }
}

