/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.api.asm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.akehurst.language.api.asm.AsmElementPath;
import net.akehurst.language.api.asm.AsmElementProperty;
import net.akehurst.language.api.asm.AsmElementReference;
import net.akehurst.language.api.asm.AsmSimple;
import net.akehurst.language.typemodel.api.PropertyDeclaration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\b\b\u0002\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000J\u0013\u0010!\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010%\u001a\u0004\u0018\u00010\u00002\u0006\u0010#\u001a\u00020\u0005J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010#\u001a\u00020\u0005J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\r2\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\r2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u0005J\u0010\u0010.\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0005J\b\u00100\u001a\u000201H\u0016J(\u00102\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000201J \u00105\u001a\u00020\u00192\u0006\u00106\u001a\u0002072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u001fJ\b\u00108\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lnet/akehurst/language/api/asm/AsmElementSimple;", "", "asmPath", "Lnet/akehurst/language/api/asm/AsmElementPath;", "typeName", "", "(Lnet/akehurst/language/api/asm/AsmElementPath;Ljava/lang/String;)V", "_properties", "", "Lnet/akehurst/language/api/asm/AsmElementProperty;", "getAsmPath", "()Lnet/akehurst/language/api/asm/AsmElementPath;", "children", "", "getChildren", "()Ljava/util/List;", "properties", "", "getProperties", "()Ljava/util/Map;", "propertiesOrdered", "getPropertiesOrdered", "getTypeName", "()Ljava/lang/String;", "addAllProperty", "", "value", "asString", "indent", "currentIndent", "equalTo", "", "other", "equals", "getProperty", "name", "getPropertyAsAsmElement", "getPropertyAsAsmElementOrNull", "getPropertyAsList", "getPropertyAsListOfElement", "getPropertyAsListOrNull", "getPropertyAsReference", "Lnet/akehurst/language/api/asm/AsmElementReference;", "getPropertyAsReferenceOrNull", "getPropertyAsString", "getPropertyAsStringOrNull", "getPropertyOrNull", "hasProperty", "hashCode", "", "setProperty", "isReference", "childIndex", "setPropertyFromDeclaration", "declaration", "Lnet/akehurst/language/typemodel/api/PropertyDeclaration;", "toString", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nasmSimple.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asmSimple.kt\nnet/akehurst/language/api/asm/AsmElementSimple\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,289:1\n1045#2:290\n819#2:291\n847#2,2:292\n1360#2:294\n1446#2,5:295\n800#2,11:300\n1855#2,2:311\n167#3,3:313\n*S KotlinDebug\n*F\n+ 1 asmSimple.kt\nnet/akehurst/language/api/asm/AsmElementSimple\n*L\n123#1:290\n131#1:291\n131#1:292,2\n132#1:294\n132#1:295,5\n133#1:300,11\n174#1:311,2\n183#1:313,3\n*E\n"})
public final class AsmElementSimple {
    @NotNull
    private final AsmElementPath asmPath;
    @NotNull
    private final String typeName;
    @NotNull
    private Map<String, AsmElementProperty> _properties;
    @NotNull
    private final Map<String, AsmElementProperty> properties;

    public AsmElementSimple(@NotNull AsmElementPath asmPath, @NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)asmPath, (String)"asmPath");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.asmPath = asmPath;
        this.typeName = typeName;
        this._properties = new LinkedHashMap();
        this.properties = this._properties;
    }

    @NotNull
    public final AsmElementPath getAsmPath() {
        return this.asmPath;
    }

    @NotNull
    public final String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final Map<String, AsmElementProperty> getProperties() {
        return this.properties;
    }

    @NotNull
    public final List<AsmElementProperty> getPropertiesOrdered() {
        Iterable $this$sortedBy$iv = this.properties.values();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AsmElementProperty it = (AsmElementProperty)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getChildIndex());
                it = (AsmElementProperty)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getChildIndex()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AsmElementSimple> getChildren() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        AsmElementProperty it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.properties.values();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AsmElementProperty)element$iv$iv;
            boolean bl = false;
            if (it.isReference()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (AsmElementProperty)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getValue() instanceof List ? (List)it.getValue() : CollectionsKt.listOf((Object)it.getValue());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AsmElementSimple)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.properties.containsKey(name);
    }

    @Nullable
    public final Object getPropertyOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AsmElementProperty asmElementProperty = this.properties.get(name);
        return asmElementProperty != null ? asmElementProperty.getValue() : null;
    }

    @Nullable
    public final String getPropertyAsStringOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (String)this.getPropertyOrNull(name);
    }

    @Nullable
    public final AsmElementSimple getPropertyAsAsmElementOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (AsmElementSimple)this.getPropertyOrNull(name);
    }

    @Nullable
    public final AsmElementReference getPropertyAsReferenceOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (AsmElementReference)this.getPropertyOrNull(name);
    }

    @Nullable
    public final List<Object> getPropertyAsListOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (List)this.getPropertyOrNull(name);
    }

    @NotNull
    public final Object getProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.properties.get(name);
        if (object == null || (object = ((AsmElementProperty)object).getValue()) == null) {
            throw new IllegalStateException(("Cannot find property '" + name + "' in element type '" + this.typeName + "' with path '" + this.asmPath + "' ").toString());
        }
        return object;
    }

    @NotNull
    public final String getPropertyAsString(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getProperty(name);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @NotNull
    public final AsmElementSimple getPropertyAsAsmElement(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getProperty(name);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.akehurst.language.api.asm.AsmElementSimple");
        return (AsmElementSimple)object;
    }

    @NotNull
    public final AsmElementReference getPropertyAsReference(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getProperty(name);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.akehurst.language.api.asm.AsmElementReference");
        return (AsmElementReference)object;
    }

    @NotNull
    public final List<Object> getPropertyAsList(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getProperty(name);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        return (List)object;
    }

    @NotNull
    public final List<AsmElementSimple> getPropertyAsListOfElement(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getProperty(name);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<net.akehurst.language.api.asm.AsmElementSimple>");
        return (List)object;
    }

    public final void setProperty(@NotNull String name, @Nullable Object value, boolean isReference, int childIndex) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (isReference) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            AsmElementReference ref2 = new AsmElementReference((String)value, null);
            this._properties.put(name, new AsmElementProperty(name, childIndex, ref2, true));
        } else {
            this._properties.put(name, new AsmElementProperty(name, childIndex, value, false));
        }
    }

    public final void setPropertyFromDeclaration(@NotNull PropertyDeclaration declaration, @Nullable Object value, boolean isReference) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (isReference) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            AsmElementReference ref2 = new AsmElementReference((String)value, null);
            this._properties.put(declaration.getName(), new AsmElementProperty(declaration.getName(), declaration.getIndex(), ref2, true));
        } else {
            this._properties.put(declaration.getName(), new AsmElementProperty(declaration.getName(), declaration.getIndex(), value, false));
        }
    }

    public final void addAllProperty(@NotNull List<AsmElementProperty> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsmElementProperty it = (AsmElementProperty)element$iv;
            boolean bl = false;
            this._properties.put(it.getName(), it);
        }
    }

    public final boolean equalTo(@NotNull AsmElementSimple other) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!Intrinsics.areEqual((Object)this.asmPath, (Object)other.asmPath)) {
                bl = false;
            } else if (!Intrinsics.areEqual((Object)this.typeName, (Object)other.typeName)) {
                bl = false;
            } else if (this.properties.size() != other.properties.size()) {
                bl = false;
            } else {
                Map<String, AsmElementProperty> $this$all$iv = this.properties;
                boolean $i$f$all = false;
                if ($this$all$iv.isEmpty()) {
                    bl = true;
                } else {
                    Iterator<Map.Entry<String, AsmElementProperty>> iterator2 = $this$all$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, AsmElementProperty> element$iv;
                        Map.Entry<String, AsmElementProperty> entry = element$iv = iterator2.next();
                        boolean bl2 = false;
                        String k = entry.getKey();
                        AsmElementProperty v = entry.getValue();
                        AsmElementProperty o = other.properties.get(k);
                        if (o == null ? false : v.equalTo(o)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @NotNull
    public final String asString(@NotNull String indent, @NotNull String currentIndent) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)currentIndent, (String)"currentIndent");
        String newIndent = currentIndent + indent;
        String propsStr2 = CollectionsKt.joinToString$default((Iterable)this.properties.values(), (CharSequence)('\n' + newIndent), (CharSequence)("{\n" + newIndent), (CharSequence)('\n' + currentIndent + '}'), (int)0, null, (Function1)((Function1)new Function1<AsmElementProperty, CharSequence>(indent, newIndent){
            final /* synthetic */ String $indent;
            final /* synthetic */ String $newIndent;
            {
                this.$indent = $indent;
                this.$newIndent = $newIndent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull AsmElementProperty it) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.isReference()) {
                    Object object = it.getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.akehurst.language.api.asm.AsmElementReference");
                    AsmElementReference ref2 = (AsmElementReference)object;
                    charSequence = it.getName() + " = " + ref2;
                } else {
                    charSequence = it.getValue() == null ? (CharSequence)(it.getName() + " = null") : (CharSequence)(it.getName() + " = " + AsmSimple.Companion.asStringAny$agl_processor(it.getValue(), this.$indent, this.$newIndent));
                }
                return charSequence;
            }
        }), (int)24, null);
        return ':' + this.typeName + ' ' + propsStr2;
    }

    public static /* synthetic */ String asString$default(AsmElementSimple asmElementSimple, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return asmElementSimple.asString(string, string2);
    }

    public int hashCode() {
        return this.asmPath.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof AsmElementSimple ? Intrinsics.areEqual((Object)this.asmPath, (Object)((AsmElementSimple)other).asmPath) : false;
    }

    @NotNull
    public String toString() {
        return ':' + this.typeName + '(' + this.asmPath + ')';
    }
}

