/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.api.asm;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.akehurst.language.api.asm.AsmElementReference;
import net.akehurst.language.api.asm.AsmElementSimple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0000J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lnet/akehurst/language/api/asm/AsmElementProperty;", "", "name", "", "childIndex", "", "value", "isReference", "", "(Ljava/lang/String;ILjava/lang/Object;Z)V", "getChildIndex", "()I", "()Z", "getName", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "equalTo", "other", "toString", "agl-processor"})
public final class AsmElementProperty {
    @NotNull
    private final String name;
    private final int childIndex;
    @Nullable
    private final Object value;
    private final boolean isReference;

    public AsmElementProperty(@NotNull String name, int childIndex, @Nullable Object value, boolean isReference) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.childIndex = childIndex;
        this.value = value;
        this.isReference = isReference;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getChildIndex() {
        return this.childIndex;
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    public final boolean isReference() {
        return this.isReference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equalTo(@NotNull AsmElementProperty other) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (this.isReference != other.isReference) {
            return false;
        }
        Object t = this.value;
        Object o = other.value;
        if (this.isReference) {
            if (!(t instanceof AsmElementReference)) throw new IllegalStateException(("Cannot compare property values: " + t + " and " + o).toString());
            if (!(o instanceof AsmElementReference)) throw new IllegalStateException(("Cannot compare property values: " + t + " and " + o).toString());
            bl = ((AsmElementReference)t).equalTo((AsmElementReference)o);
            return bl;
        } else {
            bl = t instanceof AsmElementSimple && o instanceof AsmElementSimple ? ((AsmElementSimple)t).equalTo((AsmElementSimple)o) : Intrinsics.areEqual((Object)t, (Object)o);
        }
        return bl;
    }

    @NotNull
    public String toString() {
        Object object = this.value;
        return object instanceof AsmElementSimple ? this.name + " = :" + ((AsmElementSimple)this.value).getTypeName() : (object instanceof List ? this.name + " = [...]" : (object instanceof String ? (this.isReference ? this.name + " = &" + this.value : this.name + " = " + this.value) : this.name + " = " + this.value));
    }
}

