/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.sppt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.akehurst.language.api.sppt.SPPTBranch;
import net.akehurst.language.api.sppt.SPPTLeaf;
import net.akehurst.language.api.sppt.SPPTNode;
import net.akehurst.language.api.sppt.SharedPackedParseTree;
import net.akehurst.language.collections.MutableStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lnet/akehurst/language/agl/sppt/ToStringVisitor;", "", "lineSeparator", "", "indentIncrement", "(Ljava/lang/String;Ljava/lang/String;)V", "getIndentIncrement", "()Ljava/lang/String;", "getLineSeparator", "branchPrefix", "target", "Lnet/akehurst/language/api/sppt/SPPTBranch;", "indent", "onlyChild", "", "handleLeaf", "Lnet/akehurst/language/api/sppt/SPPTLeaf;", "visitNode", "", "start", "Lnet/akehurst/language/api/sppt/SPPTNode;", "indentText", "visitTree", "Lnet/akehurst/language/api/sppt/SharedPackedParseTree;", "Item", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nToStringVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToStringVisitor.kt\nnet/akehurst/language/agl/sppt/ToStringVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1045#2:203\n1855#2,2:204\n1045#2:206\n1549#2:207\n1620#2,3:208\n*S KotlinDebug\n*F\n+ 1 ToStringVisitor.kt\nnet/akehurst/language/agl/sppt/ToStringVisitor\n*L\n55#1:203\n60#1:204,2\n68#1:206\n85#1:207\n85#1:208,3\n*E\n"})
public final class ToStringVisitor {
    @NotNull
    private final String lineSeparator;
    @NotNull
    private final String indentIncrement;

    public ToStringVisitor(@NotNull String lineSeparator, @NotNull String indentIncrement) {
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Intrinsics.checkNotNullParameter((Object)indentIncrement, (String)"indentIncrement");
        this.lineSeparator = lineSeparator;
        this.indentIncrement = indentIncrement;
    }

    @NotNull
    public final String getLineSeparator() {
        return this.lineSeparator;
    }

    @NotNull
    public final String getIndentIncrement() {
        return this.indentIncrement;
    }

    @NotNull
    public final Set<String> visitTree(@NotNull SharedPackedParseTree target, @NotNull String indentText) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)indentText, (String)"indentText");
        throw new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> visitNode(@NotNull SPPTNode start, @NotNull String indentText) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)indentText, (String)"indentText");
        MutableStack<Set> result = new MutableStack<Set>();
        MutableStack<Item> stack = new MutableStack<Item>();
        stack.push(new Item(start, "", true, null));
        while (!stack.isEmpty()) {
            Object it;
            List children2;
            int alt;
            boolean $i$f$sortedBy;
            Object $this$sortedBy$iv2;
            Item item = (Item)stack.pop();
            SPPTNode node = item.component1();
            String indent = item.component2();
            boolean onlyChild = item.component3();
            String prefix = item.component4();
            SPPTNode sPPTNode = node;
            if (sPPTNode instanceof SPPTLeaf) {
                String s = this.handleLeaf((SPPTLeaf)node, indent, onlyChild);
                result.push(SetsKt.setOf((Object)s));
                continue;
            }
            if (!(sPPTNode instanceof SPPTBranch)) continue;
            if (prefix == null) {
                String prefix2 = this.branchPrefix((SPPTBranch)node, indent, onlyChild);
                stack.push(new Item(node, indent, onlyChild, prefix2));
                $this$sortedBy$iv2 = ((SPPTBranch)node).getChildrenAlternatives().entrySet();
                $i$f$sortedBy = false;
                for (Object $this$sortedBy$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)it.getKey();
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
                    }
                })) {
                    alt = ((Number)$this$sortedBy$iv2.getKey()).intValue();
                    children2 = (List)$this$sortedBy$iv2.getValue();
                    if (children2.isEmpty()) continue;
                    if (1 == children2.size()) {
                        stack.push(new Item((SPPTNode)children2.get(0), indent, true, null));
                        continue;
                    }
                    Iterable $this$forEach$iv = children2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (SPPTNode)element$iv;
                        boolean bl = false;
                        stack.push(new Item((SPPTNode)it, indent + indentText, false, null));
                    }
                }
                continue;
            }
            HashSet<String> r = new HashSet<String>();
            $this$sortedBy$iv2 = ((SPPTBranch)node).getChildrenAlternatives().entrySet();
            $i$f$sortedBy = false;
            for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
                }
            })) {
                void $this$mapTo$iv$iv;
                alt = ((Number)entry.getKey()).intValue();
                children2 = (List)entry.getValue();
                String prefix2 = 1 == ((SPPTBranch)node).getChildrenAlternatives().size() ? prefix + " {" : prefix + '|' + alt + " {";
                if (children2.isEmpty()) {
                    r.add(prefix2 + " }");
                    continue;
                }
                if (1 == children2.size()) {
                    Set childrenStr = (Set)result.pop();
                    r.add(prefix2 + ' ' + (String)CollectionsKt.first((Iterable)childrenStr) + " }");
                    continue;
                }
                Iterable $this$map$iv = children2;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    SPPTNode sPPTNode2 = (SPPTNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Set)result.pop());
                }
                List childs = (List)destination$iv$iv;
                String cs2 = CollectionsKt.joinToString$default((Iterable)childs, (CharSequence)this.lineSeparator, null, null, (int)0, null, (Function1)((Function1)new Function1<Set<? extends String>, CharSequence>(this){
                    final /* synthetic */ ToStringVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Set<String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)this.this$0.getLineSeparator(), null, null, (int)0, null, null, (int)62, null);
                    }
                }), (int)30, null);
                String rs = prefix2 + this.lineSeparator + cs2 + this.lineSeparator + indent + '}';
                r.add(rs);
            }
            result.push(r);
        }
        return (Set)result.pop();
    }

    @NotNull
    public final String handleLeaf(@NotNull SPPTLeaf target, @NotNull String indent, boolean onlyChild) {
        String string;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        if (target.isEmptyLeaf()) {
            string = target.getName();
        } else if (target.isLiteral()) {
            string = '\'' + StringsKt.replace$default((String)StringsKt.replace$default((String)target.getMatchedText(), (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null), (String)"\t", (String)"\u2b72", (boolean)false, (int)4, null) + '\'';
        } else if (target.isPattern()) {
            string = target.getName() + " : '" + StringsKt.replace$default((String)StringsKt.replace$default((String)target.getMatchedText(), (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null), (String)"\t", (String)"\u2b72", (boolean)false, (int)4, null) + '\'';
        } else {
            throw new RuntimeException("should not happen");
        }
        String t = string;
        String s = (onlyChild ? "" : indent) + t;
        return s;
    }

    @NotNull
    public final String branchPrefix(@NotNull SPPTBranch target, @NotNull String indent, boolean onlyChild) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        String s = onlyChild ? "" : indent;
        s = s + target.getName();
        if (target.getOption() != 0) {
            // empty if block
        }
        return s;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lnet/akehurst/language/agl/sppt/ToStringVisitor$Item;", "", "node", "Lnet/akehurst/language/api/sppt/SPPTNode;", "indent", "", "onlyChild", "", "prefix", "(Lnet/akehurst/language/api/sppt/SPPTNode;Ljava/lang/String;ZLjava/lang/String;)V", "getIndent", "()Ljava/lang/String;", "getNode", "()Lnet/akehurst/language/api/sppt/SPPTNode;", "getOnlyChild", "()Z", "getPrefix", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "agl-processor"})
    private static final class Item {
        @NotNull
        private final SPPTNode node;
        @NotNull
        private final String indent;
        private final boolean onlyChild;
        @Nullable
        private final String prefix;

        public Item(@NotNull SPPTNode node, @NotNull String indent, boolean onlyChild, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            this.node = node;
            this.indent = indent;
            this.onlyChild = onlyChild;
            this.prefix = prefix;
        }

        @NotNull
        public final SPPTNode getNode() {
            return this.node;
        }

        @NotNull
        public final String getIndent() {
            return this.indent;
        }

        public final boolean getOnlyChild() {
            return this.onlyChild;
        }

        @Nullable
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final SPPTNode component1() {
            return this.node;
        }

        @NotNull
        public final String component2() {
            return this.indent;
        }

        public final boolean component3() {
            return this.onlyChild;
        }

        @Nullable
        public final String component4() {
            return this.prefix;
        }

        @NotNull
        public final Item copy(@NotNull SPPTNode node, @NotNull String indent, boolean onlyChild, @Nullable String prefix) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
            return new Item(node, indent, onlyChild, prefix);
        }

        public static /* synthetic */ Item copy$default(Item item, SPPTNode sPPTNode, String string, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                sPPTNode = item.node;
            }
            if ((n & 2) != 0) {
                string = item.indent;
            }
            if ((n & 4) != 0) {
                bl = item.onlyChild;
            }
            if ((n & 8) != 0) {
                string2 = item.prefix;
            }
            return item.copy(sPPTNode, string, bl, string2);
        }

        @NotNull
        public String toString() {
            return "Item(node=" + this.node + ", indent=" + this.indent + ", onlyChild=" + this.onlyChild + ", prefix=" + this.prefix + ')';
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.indent.hashCode();
            int n = this.onlyChild ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.prefix == null ? 0 : this.prefix.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)item.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.indent, (Object)item.indent)) {
                return false;
            }
            if (this.onlyChild != item.onlyChild) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prefix, (Object)item.prefix);
        }
    }
}

