/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.sppt;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.akehurst.language.api.regex.RegexMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u001f\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0019\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lnet/akehurst/language/agl/sppt/SimpleScanner;", "", "input", "", "skip", "Lnet/akehurst/language/api/regex/RegexMatcher;", "(Ljava/lang/CharSequence;Lnet/akehurst/language/api/regex/RegexMatcher;)V", "column", "", "getColumn", "()I", "line", "getLine", "position", "getPosition", "setPosition", "(I)V", "consumeSkipAt", "Lkotlin/Pair;", "", "at", "hasMore", "", "hasNext", "patterns", "", "([Lnet/akehurst/language/api/regex/RegexMatcher;)Z", "next", "pattern", "toString", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nSPPTParserDefault.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SPPTParserDefault.kt\nnet/akehurst/language/agl/sppt/SimpleScanner\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,376:1\n1099#2,3:377\n*S KotlinDebug\n*F\n+ 1 SPPTParserDefault.kt\nnet/akehurst/language/agl/sppt/SimpleScanner\n*L\n53#1:377,3\n*E\n"})
public final class SimpleScanner {
    @NotNull
    private final CharSequence input;
    @NotNull
    private final RegexMatcher skip;
    private int position;

    public SimpleScanner(@NotNull CharSequence input, @NotNull RegexMatcher skip) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)skip, (String)"skip");
        this.input = input;
        this.skip = skip;
        this.position = ((Number)this.consumeSkipAt(0).getSecond()).intValue();
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    public final int getLine() {
        CharSequence parsed;
        CharSequence $this$count$iv = parsed = this.input.subSequence(0, this.position);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return count$iv;
    }

    public final int getColumn() {
        CharSequence parsed = this.input.subSequence(0, this.position);
        return parsed.length() - StringsKt.lastIndexOf$default((CharSequence)parsed, (char)'\n', (int)0, (boolean)false, (int)6, null);
    }

    public final boolean hasMore() {
        return this.position < this.input.length();
    }

    public final boolean hasNext(RegexMatcher ... patterns) {
        Intrinsics.checkNotNullParameter((Object)patterns, (String)"patterns");
        int pos = this.position;
        for (RegexMatcher pat : patterns) {
            RegexMatcher.MatchResult match = pat.match(this.input, pos);
            if (match == null) {
                return false;
            }
            pos += match.getMatchedText().length();
            pos = ((Number)this.consumeSkipAt(pos).getSecond()).intValue();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String next(@NotNull RegexMatcher pattern2) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        RegexMatcher.MatchResult match = pattern2.match(this.input, this.position);
        if (match != null) {
            String matchStr = match.getMatchedText();
            this.position += matchStr.length();
        } else {
            throw new IllegalStateException(("Error scanning for pattern " + pattern2 + " at Position " + this.position).toString());
        }
        this.position = ((Number)this.consumeSkipAt(this.position).getSecond()).intValue();
        return var3_3;
    }

    @NotNull
    public final Pair<String, Integer> consumeSkipAt(int at) {
        Pair pair;
        int pos = at;
        RegexMatcher.MatchResult match = this.skip.match(this.input, pos);
        if (match != null) {
            String matchStr = match.getMatchedText();
            pair = new Pair((Object)matchStr, (Object)(pos += matchStr.length()));
        } else {
            pair = new Pair((Object)"", (Object)pos);
        }
        return pair;
    }

    @NotNull
    public String toString() {
        int x = 5;
        String before2 = ((Object)this.input.subSequence(Math.max(0, this.position - x), this.position)).toString();
        String after = ((Object)this.input.subSequence(this.position, Math.min(this.input.length(), this.position + x))).toString();
        return before2 + '^' + after;
    }
}

