/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.regex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.akehurst.language.agl.regex.CharacterMatcher;
import net.akehurst.language.agl.regex.MatcherKind;
import net.akehurst.language.agl.regex.RegexMatcherBuilder;
import net.akehurst.language.agl.regex.RegexParser;
import net.akehurst.language.api.regex.RegexMatcher;
import net.akehurst.language.collections.MutableStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00010\u001fH\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lnet/akehurst/language/agl/regex/RegexParser;", "", "pattern", "", "(Ljava/lang/String;)V", "matcherBuilder", "Lnet/akehurst/language/agl/regex/RegexMatcherBuilder;", "getMatcherBuilder", "()Lnet/akehurst/language/agl/regex/RegexMatcherBuilder;", "getPattern", "()Ljava/lang/String;", "patternX", "getPatternX", "pp", "", "getPp", "()I", "setPp", "(I)V", "next", "", "parse", "Lnet/akehurst/language/api/regex/RegexMatcher;", "parseCharacterClass", "Lnet/akehurst/language/agl/regex/CharacterMatcher;", "parseCharacterClassEscape", "parseHex", "parseNextCharOrEscape", "parsePattern", "", "parsePatternEscape", "Lkotlin/Pair;", "Lnet/akehurst/language/agl/regex/RegexParser$EscapeKind;", "parseUnicode", "toHexInt", "c", "power", "(CI)Ljava/lang/Integer;", "Companion", "EscapeKind", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nRegexParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexParser.kt\nnet/akehurst/language/agl/regex/RegexParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,511:1\n1855#2,2:512\n37#3,2:514\n37#3,2:516\n*S KotlinDebug\n*F\n+ 1 RegexParser.kt\nnet/akehurst/language/agl/regex/RegexParser\n*L\n352#1:512,2\n456#1:514,2\n458#1:516,2\n*E\n"})
public final class RegexParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final String patternX;
    private int pp;
    @NotNull
    private final RegexMatcherBuilder matcherBuilder;
    private static final int PREC_GROUP_OPEN = 1;
    private static final int PREC_GROUP_CLOSE = 1;
    private static final int PREC_LITERAL = 2;
    private static final int PREC_MULTI_01 = 3;
    private static final int PREC_MULTI_0n = 4;
    private static final int PREC_MULTI_1n = 5;
    private static final int PREC_REP = 6;
    private static final int PREC_CONCAT = 7;
    private static final int PREC_CHOICE = 8;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_DIGIT = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.RANGE, '0', '9', null, 8, null));
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_DIGIT_NEGATED;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_UNICODE_LINEBREAK;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_WHITESPACE;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_WHITESPACE_NEGATED;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_WORD;
    @NotNull
    private static final Pair<EscapeKind, CharacterMatcher> PREDEFINED_WORD_NEGATED;

    public RegexParser(@NotNull String pattern2) {
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        this.pattern = pattern2;
        this.patternX = this.pattern + '\u0000';
        this.matcherBuilder = new RegexMatcherBuilder(this.pattern);
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    @NotNull
    public final String getPatternX() {
        return this.patternX;
    }

    public final int getPp() {
        return this.pp;
    }

    public final void setPp(int n) {
        this.pp = n;
    }

    @NotNull
    public final RegexMatcherBuilder getMatcherBuilder() {
        return this.matcherBuilder;
    }

    @NotNull
    public final RegexMatcher parse() {
        this.parsePattern();
        return this.matcherBuilder.build();
    }

    private final char next() {
        char c = this.patternX.charAt(this.pp);
        int n = this.pp;
        this.pp = n + 1;
        return c;
    }

    private final void parsePattern() {
        MutableStack<Object> postfix = new MutableStack<Object>();
        MutableStack<Pair> opStack = new MutableStack<Pair>();
        MutableStack<Boolean> needConcat = new MutableStack<Boolean>();
        needConcat.push(false);
        if (this.pattern.length() > 0) {
            char c = this.next();
            try {
                while (this.pp <= this.pattern.length()) {
                    char c2 = c;
                    if (c2 == '\\') {
                        Pair<EscapeKind, Object> escaped_matchers = this.parsePatternEscape();
                        switch (WhenMappings.$EnumSwitchMapping$0[((EscapeKind)((Object)escaped_matchers.getFirst())).ordinal()]) {
                            case 1: {
                                Object object = escaped_matchers.getSecond();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.akehurst.language.agl.regex.CharacterMatcher");
                                CharacterMatcher matcher = (CharacterMatcher)object;
                                postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this, matcher){
                                    final /* synthetic */ RegexParser this$0;
                                    final /* synthetic */ CharacterMatcher $matcher;
                                    {
                                        this.this$0 = $receiver;
                                        this.$matcher = $matcher;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getMatcherBuilder().characterClass(this.$matcher);
                                    }
                                }));
                                if (((Boolean)needConcat.pop()).booleanValue()) {
                                    while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                        postfix.push(opStack.pop());
                                    }
                                    opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                        final /* synthetic */ RegexParser this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.this$0.getMatcherBuilder().concatenate();
                                        }
                                    }));
                                }
                                needConcat.push(true);
                                break;
                            }
                            case 2: {
                                Object object = escaped_matchers.getSecond();
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.CharSequence");
                                CharSequence literal2 = (CharSequence)object;
                                if (literal2.length() <= 0) break;
                                char cc = literal2.charAt(0);
                                postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this, cc){
                                    final /* synthetic */ RegexParser this$0;
                                    final /* synthetic */ char $cc;
                                    {
                                        this.this$0 = $receiver;
                                        this.$cc = $cc;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getMatcherBuilder().character(this.$cc);
                                    }
                                }));
                                if (((Boolean)needConcat.pop()).booleanValue()) {
                                    while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                        postfix.push(opStack.pop());
                                    }
                                    opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                        final /* synthetic */ RegexParser this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.this$0.getMatcherBuilder().concatenate();
                                        }
                                    }));
                                }
                                for (int i = 1; i < literal2.length(); ++i) {
                                    char d = literal2.charAt(i);
                                    postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this, d){
                                        final /* synthetic */ RegexParser this$0;
                                        final /* synthetic */ char $d;
                                        {
                                            this.this$0 = $receiver;
                                            this.$d = $d;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.this$0.getMatcherBuilder().character(this.$d);
                                        }
                                    }));
                                    opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                        final /* synthetic */ RegexParser this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.this$0.getMatcherBuilder().concatenate();
                                        }
                                    }));
                                }
                                needConcat.push(true);
                                break;
                            }
                            case 3: {
                                throw new NotImplementedError(null, 1, null);
                            }
                        }
                        c = this.next();
                        continue;
                    }
                    if (c2 == '.') {
                        postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().matchAny();
                            }
                        }));
                        if (((Boolean)needConcat.pop()).booleanValue()) {
                            while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                postfix.push(opStack.pop());
                            }
                            opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                final /* synthetic */ RegexParser this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getMatcherBuilder().concatenate();
                                }
                            }));
                        }
                        needConcat.push(true);
                        c = this.next();
                        continue;
                    }
                    if (c2 == '$') {
                        postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().matchEndOfLineOrInput();
                            }
                        }));
                        if (((Boolean)needConcat.pop()).booleanValue()) {
                            while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                postfix.push(opStack.pop());
                            }
                            opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                final /* synthetic */ RegexParser this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getMatcherBuilder().concatenate();
                                }
                            }));
                        }
                        needConcat.push(true);
                        c = this.next();
                        continue;
                    }
                    if (c2 == '[') {
                        CharacterMatcher options = this.parseCharacterClass();
                        postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this, options){
                            final /* synthetic */ RegexParser this$0;
                            final /* synthetic */ CharacterMatcher $options;
                            {
                                this.this$0 = $receiver;
                                this.$options = $options;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().characterClass(this.$options);
                            }
                        }));
                        if (((Boolean)needConcat.pop()).booleanValue()) {
                            while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                postfix.push(opStack.pop());
                            }
                            opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                final /* synthetic */ RegexParser this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getMatcherBuilder().concatenate();
                                }
                            }));
                        }
                        needConcat.push(true);
                        c = this.next();
                        continue;
                    }
                    if (c2 == '(') {
                        needConcat.push(false);
                        opStack.push(new Pair((Object)PREC_GROUP_OPEN, (Object)parsePattern.13.INSTANCE));
                        c = this.next();
                        if (c != '?') continue;
                        String string = this.pattern;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    if (c2 == '|') {
                        while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CHOICE) {
                            postfix.push(opStack.pop());
                        }
                        opStack.push(new Pair((Object)PREC_CHOICE, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().choice();
                            }
                        }));
                        needConcat.pop();
                        needConcat.push(false);
                        c = this.next();
                        continue;
                    }
                    if (c2 == '?') {
                        postfix.push(new Pair((Object)PREC_MULTI_01, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().multi01();
                            }
                        }));
                        char options = c = this.next();
                        if (options == '?') {
                            throw new NotImplementedError(null, 1, null);
                        }
                        if (options != '+') continue;
                        throw new NotImplementedError(null, 1, null);
                    }
                    if (c2 == '+') {
                        postfix.push(new Pair((Object)PREC_MULTI_1n, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().multi1n();
                            }
                        }));
                        char options = c = this.next();
                        if (options == '?') {
                            String string = this.pattern;
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                        if (options != '+') continue;
                        String string = this.pattern;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    if (c2 == '*') {
                        postfix.push(new Pair((Object)PREC_MULTI_0n, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().multi0n();
                            }
                        }));
                        char options = c = this.next();
                        if (options == '?') {
                            String string = this.pattern;
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                        if (options != '+') continue;
                        String string = this.pattern;
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    if (c2 == '{') {
                        StringBuilder nb = new StringBuilder();
                        c = this.next();
                        while (true) {
                            boolean bl = '0' <= c ? c < ':' : false;
                            if (!bl) break;
                            nb.append(c);
                            c = this.next();
                        }
                        String string = nb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        Integer n = StringsKt.toIntOrNull((String)string, (int)10);
                        if (n == null) {
                            throw new IllegalStateException("Counted repetition must be one of the forms {n} | {n,} | {n,m} where n and m are numbers".toString());
                        }
                        int n2 = n;
                        char c3 = c;
                        if (c3 == '}') {
                            postfix.push(new Pair((Object)PREC_REP, (Object)new Function0<Unit>(this, n2){
                                final /* synthetic */ RegexParser this$0;
                                final /* synthetic */ int $n;
                                {
                                    this.this$0 = $receiver;
                                    this.$n = $n;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getMatcherBuilder().repetition(this.$n, this.$n);
                                }
                            }));
                            c = this.next();
                            continue;
                        }
                        if (c3 == ',') {
                            c = this.next();
                            if (c == '}') {
                                postfix.push(new Pair((Object)PREC_REP, (Object)new Function0<Unit>(this, n2){
                                    final /* synthetic */ RegexParser this$0;
                                    final /* synthetic */ int $n;
                                    {
                                        this.this$0 = $receiver;
                                        this.$n = $n;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getMatcherBuilder().repetition(this.$n, -1);
                                    }
                                }));
                                c = this.next();
                                continue;
                            }
                            StringBuilder mb = new StringBuilder();
                            mb.append(c);
                            c = this.next();
                            while (true) {
                                boolean bl = '0' <= c ? c < ':' : false;
                                if (!bl) break;
                                mb.append(c);
                                c = this.next();
                            }
                            String string2 = mb.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                            Integer n3 = StringsKt.toIntOrNull((String)string2, (int)10);
                            if (n3 == null) {
                                throw new IllegalStateException("Counted repetition must be one of the forms {n} | {n,} | {n,m} where n and m are numbers".toString());
                            }
                            int m = n3;
                            if (c == '}') {
                                postfix.push(new Pair((Object)PREC_REP, (Object)new Function0<Unit>(this, n2, m){
                                    final /* synthetic */ RegexParser this$0;
                                    final /* synthetic */ int $n;
                                    final /* synthetic */ int $m;
                                    {
                                        this.this$0 = $receiver;
                                        this.$n = $n;
                                        this.$m = $m;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getMatcherBuilder().repetition(this.$n, this.$m);
                                    }
                                }));
                                c = this.next();
                                continue;
                            }
                            throw new IllegalStateException("Counted repetition must be one of the forms {n} | {n,} | {n,m} where n and m are numbers".toString());
                        }
                        throw new IllegalStateException("Counted repetition must be one of the forms {n} | {n,} | {n,m} where n and m are numbers".toString());
                    }
                    if (c2 == ')') {
                        while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN) {
                            postfix.push(opStack.pop());
                        }
                        if (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() == PREC_GROUP_OPEN) {
                            opStack.pop();
                        }
                        needConcat.pop();
                        if (((Boolean)needConcat.pop()).booleanValue()) {
                            while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                                postfix.push(opStack.pop());
                            }
                            opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                                final /* synthetic */ RegexParser this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.getMatcherBuilder().concatenate();
                                }
                            }));
                        }
                        needConcat.push(true);
                        c = this.next();
                        continue;
                    }
                    char cc = c;
                    postfix.push(new Pair((Object)PREC_LITERAL, (Object)new Function0<Unit>(this, cc){
                        final /* synthetic */ RegexParser this$0;
                        final /* synthetic */ char $cc;
                        {
                            this.this$0 = $receiver;
                            this.$cc = $cc;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.getMatcherBuilder().character(this.$cc);
                        }
                    }));
                    if (((Boolean)needConcat.pop()).booleanValue()) {
                        while (!opStack.isEmpty() && ((Number)((Pair)opStack.peek()).getFirst()).intValue() != PREC_GROUP_OPEN && ((Number)((Pair)opStack.peek()).getFirst()).intValue() < PREC_CONCAT) {
                            postfix.push(opStack.pop());
                        }
                        opStack.push(new Pair((Object)PREC_CONCAT, (Object)new Function0<Unit>(this){
                            final /* synthetic */ RegexParser this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getMatcherBuilder().concatenate();
                            }
                        }));
                    }
                    needConcat.push(true);
                    c = this.next();
                }
            }
            catch (Throwable t) {
                String string = this.pattern.substring(Math.max(0, this.pp - 5), Math.min(this.pattern.length(), this.pp));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String before2 = string;
                String string3 = this.pattern.substring(Math.max(this.pattern.length(), this.pp - 5), Math.min(this.pattern.length(), this.pp + 5));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String after = string3;
                String posStr = before2 + '^' + after;
                throw new IllegalStateException(("Failed to parse regex \"" + this.pattern + "\" at position " + this.pp + ", \"" + posStr + "\", " + t.getMessage()).toString());
            }
            while (!opStack.isEmpty()) {
                postfix.push(opStack.pop());
            }
            Iterable $this$forEach$iv = postfix.getElements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                ((Function0)it.getSecond()).invoke();
            }
        }
        this.matcherBuilder.concatenateGoal();
    }

    private final Pair<EscapeKind, Object> parsePatternEscape() {
        Pair pair;
        char c = this.next();
        char c2 = c;
        if (c2 == '\\') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '(') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '|') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '[') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '.') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '$') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '?') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '+') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == '*') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, c, '\u0000', null, 12, null));
        } else if (c2 == 't') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\t', '\u0000', null, 12, null));
        } else if (c2 == 'n') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\n', '\u0000', null, 12, null));
        } else if (c2 == 'r') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\r', '\u0000', null, 12, null));
        } else if (c2 == 'f') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\f', '\u0000', null, 12, null));
        } else if (c2 == 'a') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\u0007', '\u0000', null, 12, null));
        } else if (c2 == 'e') {
            pair = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.LITERAL, '\u001b', '\u0000', null, 12, null));
        } else {
            if (c2 == 'c') {
                String string = "Control char";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (c2 == 'd') {
                pair = PREDEFINED_DIGIT;
            } else if (c2 == 'D') {
                pair = PREDEFINED_DIGIT_NEGATED;
            } else if (c2 == 'R') {
                pair = PREDEFINED_UNICODE_LINEBREAK;
            } else if (c2 == 's') {
                pair = PREDEFINED_WHITESPACE;
            } else if (c2 == 'S') {
                pair = PREDEFINED_WHITESPACE_NEGATED;
            } else if (c2 == 'w') {
                pair = PREDEFINED_WORD;
            } else if (c2 == 'W') {
                pair = PREDEFINED_WORD_NEGATED;
            } else {
                if (c2 == '0') {
                    String string = "Octal value";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (c2 == 'x') {
                    String string = "hex value";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (c2 == 'u') {
                    String string = "unicode hex value";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (c2 == 'Q') {
                    StringBuilder sb = new StringBuilder();
                    boolean end = false;
                    c = this.next();
                    while (!end) {
                        if (c == '\\') {
                            c = this.next();
                            if ('E' == c) {
                                end = true;
                                continue;
                            }
                            sb.append(c);
                            continue;
                        }
                        sb.append(c);
                        c = this.next();
                    }
                    pair = new Pair((Object)EscapeKind.LITERAL, (Object)sb.toString());
                } else {
                    String string = c + " at " + this.pp + " in " + this.pattern;
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
            }
        }
        return pair;
    }

    private final CharacterMatcher parseCharacterClass() {
        CharacterMatcher characterMatcher;
        boolean bl;
        List options = new ArrayList();
        char c = this.parseNextCharOrEscape();
        if ('^' == c) {
            c = this.parseNextCharOrEscape();
            bl = true;
        } else {
            bl = false;
        }
        boolean negated = bl;
        char f = c;
        while (c != ']') {
            c = this.parseNextCharOrEscape();
            char c2 = c;
            if (c2 == ']') {
                options.add(new CharacterMatcher(MatcherKind.LITERAL, f, '\u0000', null, 12, null));
                continue;
            }
            if (c2 == '-') {
                c = this.parseNextCharOrEscape();
                if (c == ']') {
                    options.add(new CharacterMatcher(MatcherKind.LITERAL, f, '\u0000', null, 12, null));
                    options.add(new CharacterMatcher(MatcherKind.LITERAL, '-', '\u0000', null, 12, null));
                    continue;
                }
                options.add(new CharacterMatcher(MatcherKind.RANGE, f, c, null, 8, null));
                f = c = this.parseNextCharOrEscape();
                continue;
            }
            options.add(new CharacterMatcher(MatcherKind.LITERAL, f, '\u0000', null, 12, null));
            f = c;
        }
        if (negated) {
            CharacterMatcher[] characterMatcherArray = new CharacterMatcher[1];
            Collection $this$toTypedArray$iv = options;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            characterMatcherArray[0] = new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', thisCollection$iv.toArray(new CharacterMatcher[0]), 6, null);
            CharacterMatcher characterMatcher2 = new CharacterMatcher(MatcherKind.NEGATED, '\u0000', '\u0000', characterMatcherArray, 6, null);
            characterMatcher = characterMatcher2;
        } else {
            Collection $this$toTypedArray$iv = options;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CharacterMatcher characterMatcher3 = new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', thisCollection$iv.toArray(new CharacterMatcher[0]), 6, null);
            characterMatcher = characterMatcher3;
        }
        return characterMatcher;
    }

    private final char parseNextCharOrEscape() {
        char c = this.next();
        return c == '\\' ? this.parseCharacterClassEscape() : c;
    }

    /*
     * WARNING - void declaration
     */
    private final char parseCharacterClassEscape() {
        int n;
        char c = this.next();
        char c2 = c;
        if (c2 == '\\') {
            n = 92;
        } else if (c2 == '$') {
            n = 36;
        } else if (c2 == 't') {
            n = 9;
        } else if (c2 == 'n') {
            n = 10;
        } else if (c2 == 'r') {
            n = 13;
        } else if (c2 == 'f') {
            n = 12;
        } else if (c2 == 'a') {
            n = 7;
        } else if (c2 == 'e') {
            n = 27;
        } else {
            if (c2 == 'c') {
                String string = "Control char";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (c2 == 'u') {
                void var3_4;
                char unicodeChar = this.parseUnicode();
                n = var3_4;
            } else if (c2 == 'x') {
                n = this.parseHex();
            } else {
                throw new IllegalStateException(("Unknown escape code '" + c + "' in character class, at position " + this.pp + " in " + this.pattern + ", ").toString());
            }
        }
        return (char)n;
    }

    private final char parseHex() {
        Integer n = this.toHexInt(this.next(), 16);
        if (n == null) {
            throw new IllegalStateException(("Cannot parse Hex, at position " + this.pp).toString());
        }
        int hex = n;
        Integer n2 = this.toHexInt(this.next(), 1);
        if (n2 == null) {
            throw new IllegalStateException(("Cannot parse Hex, at position " + this.pp).toString());
        }
        return (char)(hex += n2.intValue());
    }

    private final char parseUnicode() {
        Integer n = this.toHexInt(this.next(), 4096);
        if (n == null) {
            throw new IllegalStateException(("Cannot parse Unicode, at position " + this.pp).toString());
        }
        int unicode = n;
        Integer n2 = this.toHexInt(this.next(), 256);
        if (n2 == null) {
            throw new IllegalStateException(("Cannot parse Unicode, at position " + this.pp).toString());
        }
        unicode += n2.intValue();
        Integer n3 = this.toHexInt(this.next(), 16);
        if (n3 == null) {
            throw new IllegalStateException(("Cannot parse Unicode, at position " + this.pp).toString());
        }
        unicode += n3.intValue();
        Integer n4 = this.toHexInt(this.next(), 1);
        if (n4 == null) {
            throw new IllegalStateException(("Cannot parse Unicode, at position " + this.pp).toString());
        }
        return (char)(unicode += n4.intValue());
    }

    private final Integer toHexInt(char c, int power) {
        Integer v;
        Integer n = v = StringsKt.toIntOrNull((String)String.valueOf(c), (int)16);
        return n == null ? null : Integer.valueOf(n * power);
    }

    static {
        CharacterMatcher[] characterMatcherArray = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.RANGE, '0', '9', null, 8, null)};
        PREDEFINED_DIGIT_NEGATED = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.NEGATED, '\u0000', '\u0000', characterMatcherArray, 6, null));
        characterMatcherArray = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.LITERAL, '\n', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\u000b', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\f', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\r', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\u0085', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\u2029', '\u0000', null, 12, null)};
        PREDEFINED_UNICODE_LINEBREAK = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', characterMatcherArray, 6, null));
        characterMatcherArray = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.LITERAL, ' ', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\t', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\n', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\u000b', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\f', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\r', '\u0000', null, 12, null)};
        PREDEFINED_WHITESPACE = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', characterMatcherArray, 6, null));
        characterMatcherArray = new CharacterMatcher[1];
        CharacterMatcher[] characterMatcherArray2 = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.LITERAL, ' ', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\t', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\n', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\u000b', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\f', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.LITERAL, '\r', '\u0000', null, 12, null)};
        characterMatcherArray[0] = new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', characterMatcherArray2, 6, null);
        PREDEFINED_WHITESPACE_NEGATED = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.NEGATED, '\u0000', '\u0000', characterMatcherArray, 6, null));
        characterMatcherArray = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.RANGE, 'a', 'z', null, 8, null), new CharacterMatcher(MatcherKind.RANGE, 'A', 'Z', null, 8, null), new CharacterMatcher(MatcherKind.LITERAL, '_', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.RANGE, '0', '9', null, 8, null)};
        PREDEFINED_WORD = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', characterMatcherArray, 6, null));
        characterMatcherArray = new CharacterMatcher[1];
        characterMatcherArray2 = new CharacterMatcher[]{new CharacterMatcher(MatcherKind.RANGE, 'a', 'z', null, 8, null), new CharacterMatcher(MatcherKind.RANGE, 'A', 'Z', null, 8, null), new CharacterMatcher(MatcherKind.LITERAL, '_', '\u0000', null, 12, null), new CharacterMatcher(MatcherKind.RANGE, '0', '9', null, 8, null)};
        characterMatcherArray[0] = new CharacterMatcher(MatcherKind.ONE_OF, '\u0000', '\u0000', characterMatcherArray2, 6, null);
        PREDEFINED_WORD_NEGATED = new Pair((Object)EscapeKind.SINGLE, (Object)new CharacterMatcher(MatcherKind.NEGATED, '\u0000', '\u0000', characterMatcherArray, 6, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u001d\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR\u001d\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u001d\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001c\u00a8\u0006)"}, d2={"Lnet/akehurst/language/agl/regex/RegexParser$Companion;", "", "()V", "PREC_CHOICE", "", "getPREC_CHOICE", "()I", "PREC_CONCAT", "getPREC_CONCAT", "PREC_GROUP_CLOSE", "getPREC_GROUP_CLOSE", "PREC_GROUP_OPEN", "getPREC_GROUP_OPEN", "PREC_LITERAL", "getPREC_LITERAL", "PREC_MULTI_01", "getPREC_MULTI_01", "PREC_MULTI_0n", "getPREC_MULTI_0n", "PREC_MULTI_1n", "getPREC_MULTI_1n", "PREC_REP", "getPREC_REP", "PREDEFINED_DIGIT", "Lkotlin/Pair;", "Lnet/akehurst/language/agl/regex/RegexParser$EscapeKind;", "Lnet/akehurst/language/agl/regex/CharacterMatcher;", "getPREDEFINED_DIGIT", "()Lkotlin/Pair;", "PREDEFINED_DIGIT_NEGATED", "getPREDEFINED_DIGIT_NEGATED", "PREDEFINED_UNICODE_LINEBREAK", "getPREDEFINED_UNICODE_LINEBREAK", "PREDEFINED_WHITESPACE", "getPREDEFINED_WHITESPACE", "PREDEFINED_WHITESPACE_NEGATED", "getPREDEFINED_WHITESPACE_NEGATED", "PREDEFINED_WORD", "getPREDEFINED_WORD", "PREDEFINED_WORD_NEGATED", "getPREDEFINED_WORD_NEGATED", "agl-processor"})
    public static final class Companion {
        private Companion() {
        }

        public final int getPREC_GROUP_OPEN() {
            return PREC_GROUP_OPEN;
        }

        public final int getPREC_GROUP_CLOSE() {
            return PREC_GROUP_CLOSE;
        }

        public final int getPREC_LITERAL() {
            return PREC_LITERAL;
        }

        public final int getPREC_MULTI_01() {
            return PREC_MULTI_01;
        }

        public final int getPREC_MULTI_0n() {
            return PREC_MULTI_0n;
        }

        public final int getPREC_MULTI_1n() {
            return PREC_MULTI_1n;
        }

        public final int getPREC_REP() {
            return PREC_REP;
        }

        public final int getPREC_CONCAT() {
            return PREC_CONCAT;
        }

        public final int getPREC_CHOICE() {
            return PREC_CHOICE;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_DIGIT() {
            return PREDEFINED_DIGIT;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_DIGIT_NEGATED() {
            return PREDEFINED_DIGIT_NEGATED;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_UNICODE_LINEBREAK() {
            return PREDEFINED_UNICODE_LINEBREAK;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_WHITESPACE() {
            return PREDEFINED_WHITESPACE;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_WHITESPACE_NEGATED() {
            return PREDEFINED_WHITESPACE_NEGATED;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_WORD() {
            return PREDEFINED_WORD;
        }

        @NotNull
        public final Pair<EscapeKind, CharacterMatcher> getPREDEFINED_WORD_NEGATED() {
            return PREDEFINED_WORD_NEGATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lnet/akehurst/language/agl/regex/RegexParser$EscapeKind;", "", "(Ljava/lang/String;I)V", "SINGLE", "OPTIONS", "LITERAL", "agl-processor"})
    public static final class EscapeKind
    extends Enum<EscapeKind> {
        public static final /* enum */ EscapeKind SINGLE = new EscapeKind();
        public static final /* enum */ EscapeKind OPTIONS = new EscapeKind();
        public static final /* enum */ EscapeKind LITERAL = new EscapeKind();
        private static final /* synthetic */ EscapeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static EscapeKind[] values() {
            return (EscapeKind[])$VALUES.clone();
        }

        public static EscapeKind valueOf(String value) {
            return Enum.valueOf(EscapeKind.class, value);
        }

        @NotNull
        public static EnumEntries<EscapeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = escapeKindArray = new EscapeKind[]{EscapeKind.SINGLE, EscapeKind.OPTIONS, EscapeKind.LITERAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EscapeKind.values().length];
            try {
                nArray[EscapeKind.SINGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EscapeKind.LITERAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EscapeKind.OPTIONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

