/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.akehurst.language.agl.collections.MutableOrderedSet;
import net.akehurst.language.agl.collections.OrderedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0015\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0019\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0013\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\u0016\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0096\u0002J\u0015\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010%\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010&\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lnet/akehurst/language/agl/collections/MutableOrderedSetImpl;", "E", "Lnet/akehurst/language/agl/collections/MutableOrderedSet;", "()V", "collection", "", "(Ljava/util/Collection;)V", "initialCapacity", "", "(I)V", "_impl", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "clear", "", "contains", "containsAll", "equals", "other", "", "get", "index", "(I)Ljava/lang/Object;", "hashCode", "isEmpty", "iterator", "", "remove", "removeAll", "retainAll", "toString", "", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nOrderedSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedSet.kt\nnet/akehurst/language/agl/collections/MutableOrderedSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1864#2,3:172\n*S KotlinDebug\n*F\n+ 1 OrderedSet.kt\nnet/akehurst/language/agl/collections/MutableOrderedSetImpl\n*L\n111#1:172,3\n*E\n"})
public final class MutableOrderedSetImpl<E>
implements MutableOrderedSet<E> {
    @NotNull
    private final LinkedHashSet<E> _impl;

    public MutableOrderedSetImpl() {
        this._impl = new LinkedHashSet();
    }

    public MutableOrderedSetImpl(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this._impl = new LinkedHashSet<E>(collection);
    }

    public MutableOrderedSetImpl(int initialCapacity) {
        this._impl = new LinkedHashSet(initialCapacity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E get(int index) {
        Iterable $this$forEachIndexed$iv = this._impl;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void e;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            if (index != i) continue;
            return e;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public int getSize() {
        return this._impl.size();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator iterator2 = this._impl.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    @Override
    public boolean isEmpty() {
        return this._impl.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this._impl.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this._impl.containsAll(elements);
    }

    @Override
    public boolean add(E element) {
        return this._impl.add(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this._impl.addAll(elements);
    }

    @Override
    public boolean remove(Object element) {
        return this._impl.remove(element);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this._impl.removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this._impl.retainAll(elements);
    }

    @Override
    public void clear() {
        this._impl.clear();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof OrderedSet)) {
            bl = false;
        } else if (((OrderedSet)other).size() != this.size()) {
            bl = false;
        } else {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                if (Intrinsics.areEqual(this.get(i), ((OrderedSet)other).get(i))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this._impl.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this._impl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

