/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.akehurst.language.agl.collections.BinaryHeapFifo;
import net.akehurst.language.agl.collections.BinaryHeapFifoComparable;
import net.akehurst.language.agl.collections.FifoQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001bH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002J\u000f\u0010\"\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010*H\u0096\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0002J\u0017\u0010/\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u001b\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u00102\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0002J\u001e\u00103\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0016\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u0017J\b\u00107\u001a\u000208H\u0016J\u001d\u00109\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010:\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010;R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00018\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006<"}, d2={"Lnet/akehurst/language/agl/collections/BinaryHeapFifoComparable;", "K", "V", "Lnet/akehurst/language/agl/collections/BinaryHeapFifo;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "_elements", "", "Lnet/akehurst/language/agl/collections/FifoQueue;", "_keys", "", "getComparator", "()Ljava/util/Comparator;", "keys", "", "getKeys", "()Ljava/util/List;", "peekRoot", "getPeekRoot", "()Ljava/lang/Object;", "size", "", "getSize", "()I", "addElement", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "clear", "downHeap", "index", "extractRoot", "get", "(Ljava/lang/Object;)Ljava/util/List;", "insert", "isEmpty", "", "isNotEmpty", "iterator", "", "leftChildIndexOf", "parentIndex", "parentIndexOf", "childIndex", "peek", "(Ljava/lang/Object;)Ljava/lang/Object;", "peekAll", "rightChildIndexOf", "set", "swap", "i1", "i2", "toString", "", "upHeap", "elementKey", "(ILjava/lang/Object;)I", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nbinaryHeapFifo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 binaryHeapFifo.kt\nnet/akehurst/language/agl/collections/BinaryHeapFifoComparable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1#2:264\n1549#3:265\n1620#3,3:266\n*S KotlinDebug\n*F\n+ 1 binaryHeapFifo.kt\nnet/akehurst/language/agl/collections/BinaryHeapFifoComparable\n*L\n261#1:265\n261#1:266,3\n*E\n"})
public final class BinaryHeapFifoComparable<K, V>
implements BinaryHeapFifo<K, V> {
    @NotNull
    private final Comparator<K> comparator;
    @NotNull
    private final Map<K, FifoQueue<V>> _elements;
    @NotNull
    private final List<K> _keys;

    public BinaryHeapFifoComparable(@NotNull Comparator<K> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.comparator = comparator;
        this._elements = new LinkedHashMap();
        this._keys = new ArrayList();
    }

    @NotNull
    public final Comparator<K> getComparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSize() {
        Iterable iterable = this._elements.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            FifoQueue fifoQueue = (FifoQueue)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getSize();
            n = n2 + n3;
        }
        return n;
    }

    @Override
    @Nullable
    public V getPeekRoot() {
        V v;
        if (this._elements.size() == 0) {
            v = null;
        } else {
            K k = this._keys.get(0);
            Intrinsics.checkNotNull(k);
            FifoQueue<V> fifoQueue = this._elements.get(k);
            Intrinsics.checkNotNull(fifoQueue);
            v = fifoQueue.getBack();
        }
        return v;
    }

    @Override
    @NotNull
    public List<K> getKeys() {
        return this._keys;
    }

    @Override
    public void set(K key, V value) {
        this.insert(key, value);
    }

    @Override
    @NotNull
    public List<V> get(K key) {
        return this.peekAll(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.getSize() != 0;
    }

    @Override
    public void insert(K key, V value) {
        if (this._elements.containsKey(key)) {
            FifoQueue<V> fifoQueue = this._elements.get(key);
            Intrinsics.checkNotNull(fifoQueue);
            fifoQueue.addFront(value);
        } else {
            this.addElement(key, value);
            this._keys.add(key);
            this.upHeap(this._elements.size() - 1, key);
        }
    }

    @Override
    @Nullable
    public V extractRoot() {
        if (this._keys.size() != 0) {
            V v;
            K rootKey = this._keys.get(0);
            FifoQueue<V> fifoQueue = this._elements.get(rootKey);
            Intrinsics.checkNotNull(fifoQueue);
            FifoQueue<V> q = fifoQueue;
            if (1 == q.getSize()) {
                this._elements.remove(rootKey);
                this.swap(0, this._keys.size() - 1);
                CollectionsKt.removeLastOrNull(this._keys);
                this.downHeap(0);
                v = q.removeBack();
            } else {
                v = q.removeBack();
            }
            return v;
        }
        return null;
    }

    @Override
    @Nullable
    public V peek(K key) {
        FifoQueue<V> fifoQueue = this._elements.get(key);
        return (V)(fifoQueue != null ? fifoQueue.getBack() : null);
    }

    @Override
    @NotNull
    public List<V> peekAll(K key) {
        Iterable<Object> iterable = this._elements.get(key);
        if (iterable == null || (iterable = CollectionsKt.toList((Iterable)iterable)) == null) {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    @Override
    public void clear() {
        this._elements.clear();
    }

    private final int parentIndexOf(int childIndex) {
        return (childIndex - 1) / 2;
    }

    private final int leftChildIndexOf(int parentIndex) {
        return 2 * parentIndex + 1;
    }

    private final int rightChildIndexOf(int parentIndex) {
        return 2 * parentIndex + 2;
    }

    private final void addElement(K key, V value) {
        FifoQueue<Object> q = this._elements.get(key);
        if (q == null) {
            q = new FifoQueue();
            this._elements.put(key, q);
        }
        q.addFront(value);
    }

    private final int upHeap(int index, K elementKey) {
        int elementIndex = index;
        int parentIndex = this.parentIndexOf(elementIndex);
        K parentKey = this._keys.get(parentIndex);
        while (0 > this.comparator.compare(parentKey, elementKey)) {
            this.swap(parentIndex, elementIndex);
            elementIndex = parentIndex;
            parentIndex = this.parentIndexOf(elementIndex);
            parentKey = this._keys.get(parentIndex);
        }
        return elementIndex;
    }

    private final int downHeap(int index) {
        int n;
        int leftChildIndex = this.leftChildIndexOf(index);
        int rightChildIndex = this.rightChildIndexOf(index);
        int smallest = index;
        if (leftChildIndex < this._elements.size() && 0 < this.comparator.compare(this._keys.get(leftChildIndex), this._keys.get(smallest))) {
            smallest = leftChildIndex;
        }
        if (rightChildIndex < this._elements.size() && 0 < this.comparator.compare(this._keys.get(rightChildIndex), this._keys.get(smallest))) {
            smallest = rightChildIndex;
        }
        if (smallest != index) {
            this.swap(index, smallest);
            n = this.downHeap(smallest);
        } else {
            n = index;
        }
        return n;
    }

    public final void swap(int i1, int i2) {
        K t = this._keys.get(i1);
        this._keys.set(i1, this._keys.get(i2));
        this._keys.set(i2, t);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new Iterator<V>(this){
            @NotNull
            private List<? extends Map.Entry<K, FifoQueue<V>>> _sortedQueues;
            @NotNull
            private List<? extends V> _sorted;
            private int _nextIndex;
            {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                this._sortedQueues = CollectionsKt.sortedWith((Iterable)BinaryHeapFifoComparable.access$get_elements$p($receiver).entrySet(), (arg_0, arg_1) -> iterator.1._sortedQueues$lambda$0((Function2)new Function2<Map.Entry<K, FifoQueue<V>>, Map.Entry<K, FifoQueue<V>>, Integer>($receiver){
                    final /* synthetic */ BinaryHeapFifoComparable<K, V> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final Integer invoke(Map.Entry<K, FifoQueue<V>> a, Map.Entry<K, FifoQueue<V>> b) {
                        return this.this$0.getComparator().compare(b.getKey(), a.getKey());
                    }
                }, arg_0, arg_1));
                Iterable iterable = this._sortedQueues;
                iterator.1 var11_3 = this;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Map.Entry it = (Map.Entry)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)it.getValue()));
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                var11_3._sorted = (List)destination$iv$iv;
            }

            public boolean hasNext() {
                return this._nextIndex < this._sorted.size();
            }

            public V next() {
                V v;
                V it = v = this._sorted.get(this._nextIndex);
                boolean bl = false;
                int n = this._nextIndex;
                this._nextIndex = n + 1;
                return v;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            private static final int _sortedQueues$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        if (this.getSize() == 0) {
            string = "{}";
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this._keys;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)it, this._elements.get(it)));
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.2.INSTANCE, (int)30, null);
        }
        return string;
    }

    public static final /* synthetic */ Map access$get_elements$p(BinaryHeapFifoComparable $this) {
        return $this._elements;
    }
}

