/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.akehurst.language.agl.collections.BinaryHeap;
import net.akehurst.language.agl.collections.BinaryHeapComparable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001@B\u001d\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u000f\u0010\u001c\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u001e\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010 J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010*H\u0096\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0002J\u001b\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\"J\u0017\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0017\u00102\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\u0010\u00103\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015H\u0002J#\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u00105\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106J\u001e\u00107\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010$J\u0016\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u0015J\b\u0010;\u001a\u00020<H\u0016J\u001d\u0010=\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010>\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010?R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00018\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006A"}, d2={"Lnet/akehurst/language/agl/collections/BinaryHeapComparable;", "K", "V", "Lnet/akehurst/language/agl/collections/BinaryHeap;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "_elements", "", "Lnet/akehurst/language/agl/collections/BinaryHeap$Entry;", "getComparator", "()Ljava/util/Comparator;", "entries", "", "getEntries", "()Ljava/util/List;", "peekRoot", "getPeekRoot", "()Ljava/lang/Object;", "size", "", "getSize", "()I", "clear", "", "downHeap", "index", "extractRoot", "extractRootAndThenInsert", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/util/List;", "insert", "(Ljava/lang/Object;Ljava/lang/Object;)V", "insertAndThenExtractRoot", "isEmpty", "", "isNotEmpty", "iterator", "", "leftChildIndexOf", "parentIndex", "parentIndexOf", "childIndex", "peekAll", "peekOneOf", "(Ljava/lang/Object;)Ljava/lang/Object;", "remove", "rightChildIndexOf", "searchSubTreeFor", "startEntryIndex", "(ILjava/lang/Object;)Ljava/util/List;", "set", "swap", "i1", "i2", "toString", "", "upHeap", "elementKey", "(ILjava/lang/Object;)I", "Entry", "agl-processor"})
@SourceDebugExtension(value={"SMAP\nbinaryHeap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 binaryHeap.kt\nnet/akehurst/language/agl/collections/BinaryHeapComparable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n350#2,7:277\n*S KotlinDebug\n*F\n+ 1 binaryHeap.kt\nnet/akehurst/language/agl/collections/BinaryHeapComparable\n*L\n175#1:277,7\n*E\n"})
public final class BinaryHeapComparable<K, V>
implements BinaryHeap<K, V> {
    @NotNull
    private final Comparator<K> comparator;
    @NotNull
    private final List<BinaryHeap.Entry<K, V>> _elements;

    public BinaryHeapComparable(@NotNull Comparator<K> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.comparator = comparator;
        this._elements = new ArrayList();
    }

    @NotNull
    public final Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public int getSize() {
        return this._elements.size();
    }

    @Override
    @Nullable
    public V getPeekRoot() {
        return this._elements.size() == 0 ? null : (V)this._elements.get(0).getValue();
    }

    @Override
    @NotNull
    public List<BinaryHeap.Entry<K, V>> getEntries() {
        return this._elements;
    }

    @Override
    public void set(K key, V value) {
        this.insert(key, value);
    }

    @Override
    @NotNull
    public List<V> get(K key) {
        return this.peekAll(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public boolean isNotEmpty() {
        return this.getSize() != 0;
    }

    @Override
    public void insert(K key, V value) {
        Entry<K, V> e = new Entry<K, V>(key, value);
        this._elements.add(e);
        this.upHeap(this._elements.size() - 1, key);
    }

    @Override
    @Nullable
    public V extractRoot() {
        Object v0;
        if (this.getSize() == 0) {
            v0 = null;
        } else {
            this.swap(0, this._elements.size() - 1);
            BinaryHeap.Entry oldRoot = (BinaryHeap.Entry)CollectionsKt.removeLastOrNull(this._elements);
            this.downHeap(0);
            BinaryHeap.Entry entry = oldRoot;
            v0 = entry != null ? entry.getValue() : null;
        }
        return v0;
    }

    @Override
    @Nullable
    public V extractRootAndThenInsert(K key, V value) {
        Object v0;
        switch (this.getSize()) {
            case 0: {
                this._elements.add(new Entry<K, V>(key, value));
                v0 = null;
                break;
            }
            case 1: {
                BinaryHeap.Entry<K, V> oldRoot = this._elements.get(0);
                this._elements.set(0, new Entry<K, V>(key, value));
                v0 = oldRoot.getValue();
                break;
            }
            default: {
                this._elements.add(new Entry<K, V>(key, value));
                this.swap(0, this._elements.size() - 1);
                BinaryHeap.Entry oldRoot = (BinaryHeap.Entry)CollectionsKt.removeLastOrNull(this._elements);
                this.downHeap(0);
                BinaryHeap.Entry entry = oldRoot;
                v0 = entry != null ? entry.getValue() : null;
            }
        }
        return v0;
    }

    @Override
    public V insertAndThenExtractRoot(K key, V value) {
        V v;
        if (this.getSize() == 0) {
            v = value;
        } else if (0 < this.comparator.compare(key, this._elements.get(0).getKey())) {
            v = value;
        } else {
            BinaryHeap.Entry<K, V> oldRoot = this._elements.get(0);
            this._elements.set(0, new Entry<K, V>(key, value));
            this.downHeap(0);
            v = oldRoot.getValue();
        }
        return v;
    }

    @Override
    @Nullable
    public V remove(K key) {
        Object v0;
        if (this.getSize() == 0) {
            v0 = null;
        } else if (Intrinsics.areEqual(key, this._elements.get(0).getKey())) {
            v0 = this.extractRoot();
        } else if (Intrinsics.areEqual(key, ((BinaryHeap.Entry)CollectionsKt.last(this._elements)).getKey())) {
            v0 = this._elements.remove(this._elements.size() - 1).getValue();
        } else {
            int index;
            block10: {
                int n;
                List<BinaryHeap.Entry<K, V>> $this$indexOfFirst$iv = this._elements;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<BinaryHeap.Entry<K, V>> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    BinaryHeap.Entry<K, V> item$iv;
                    BinaryHeap.Entry<K, V> it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getKey(), key)) {
                        n = index$iv;
                        break block10;
                    }
                    ++index$iv;
                }
                n = index = -1;
            }
            if (index >= 0) {
                this.swap(index, this._elements.size() - 1);
                BinaryHeap.Entry<K, V> old = this._elements.remove(this._elements.size() - 1);
                this.downHeap(index);
                v0 = old.getValue();
            } else {
                v0 = null;
            }
        }
        return v0;
    }

    @Override
    @Nullable
    public V peekOneOf(K key) {
        return (V)CollectionsKt.firstOrNull(this.searchSubTreeFor(0, key));
    }

    @Override
    @NotNull
    public List<V> peekAll(K key) {
        return this.searchSubTreeFor(0, key);
    }

    @Override
    public void clear() {
        this._elements.clear();
    }

    private final int parentIndexOf(int childIndex) {
        return (childIndex - 1) / 2;
    }

    private final int leftChildIndexOf(int parentIndex) {
        return 2 * parentIndex + 1;
    }

    private final int rightChildIndexOf(int parentIndex) {
        return 2 * parentIndex + 2;
    }

    private final List<V> searchSubTreeFor(int startEntryIndex, K key) {
        List elements = new ArrayList();
        int left = this.leftChildIndexOf(startEntryIndex);
        int right = this.rightChildIndexOf(startEntryIndex);
        return startEntryIndex >= this._elements.size() ? elements : (Intrinsics.areEqual(key, this._elements.get(startEntryIndex).getKey()) ? CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)elements, this._elements.get(startEntryIndex).getValue()), (Iterable)this.searchSubTreeFor(left, key)), (Iterable)this.searchSubTreeFor(right, key)) : (0 < this.comparator.compare(key, this._elements.get(startEntryIndex).getKey()) ? elements : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)elements, (Iterable)this.searchSubTreeFor(left, key)), (Iterable)this.searchSubTreeFor(right, key))));
    }

    /*
     * WARNING - void declaration
     */
    private final int upHeap(int index, K elementKey) {
        int n;
        if (1 == this.getSize()) {
            n = index;
        } else {
            void var3_3;
            int elementIndex = index;
            int parentIndex = this.parentIndexOf(elementIndex);
            K parentKey = this._elements.get(parentIndex).getKey();
            while (!Intrinsics.areEqual(parentKey, elementKey) && 0 > this.comparator.compare(parentKey, elementKey)) {
                this.swap(parentIndex, elementIndex);
                elementIndex = parentIndex;
                parentIndex = this.parentIndexOf(elementIndex);
                parentKey = this._elements.get(parentIndex).getKey();
            }
            n = var3_3;
        }
        return n;
    }

    private final int downHeap(int index) {
        int n;
        int leftChildIndex = this.leftChildIndexOf(index);
        int rightChildIndex = this.rightChildIndexOf(index);
        int smallest = index;
        if (leftChildIndex < this._elements.size() && 0 < this.comparator.compare(this._elements.get(leftChildIndex).getKey(), this._elements.get(smallest).getKey())) {
            smallest = leftChildIndex;
        }
        if (rightChildIndex < this._elements.size() && 0 < this.comparator.compare(this._elements.get(rightChildIndex).getKey(), this._elements.get(smallest).getKey())) {
            smallest = rightChildIndex;
        }
        if (smallest != index) {
            this.swap(index, smallest);
            n = this.downHeap(smallest);
        } else {
            n = index;
        }
        return n;
    }

    public final void swap(int i1, int i2) {
        BinaryHeap.Entry<K, V> t = this._elements.get(i1);
        this._elements.set(i1, this._elements.get(i2));
        this._elements.set(i2, t);
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new Iterator<V>(this){
            @NotNull
            private List<? extends BinaryHeap.Entry<K, V>> _sorted;
            private int _nextIndex;
            {
                this._sorted = CollectionsKt.sortedWith((Iterable)BinaryHeapComparable.access$get_elements$p($receiver), (arg_0, arg_1) -> iterator.1._sorted$lambda$0((Function2)new Function2<BinaryHeap.Entry<K, V>, BinaryHeap.Entry<K, V>, Integer>($receiver){
                    final /* synthetic */ BinaryHeapComparable<K, V> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @NotNull
                    public final Integer invoke(BinaryHeap.Entry<K, V> a, BinaryHeap.Entry<K, V> b) {
                        return this.this$0.getComparator().compare(b.getKey(), a.getKey());
                    }
                }, arg_0, arg_1));
            }

            public boolean hasNext() {
                return this._nextIndex < this._sorted.size();
            }

            public V next() {
                V v;
                V it = v = this._sorted.get(this._nextIndex).getValue();
                boolean bl = false;
                int n = this._nextIndex;
                this._nextIndex = n + 1;
                return v;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            private static final int _sorted$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }
        };
    }

    @NotNull
    public String toString() {
        return this.getSize() == 0 ? "{}" : CollectionsKt.joinToString$default((Iterable)this._elements, (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null);
    }

    public static final /* synthetic */ List access$get_elements$p(BinaryHeapComparable $this) {
        return $this._elements;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0004\u001a\u00028\u0002X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u00028\u0003X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0013"}, d2={"Lnet/akehurst/language/agl/collections/BinaryHeapComparable$Entry;", "K", "V", "Lnet/akehurst/language/agl/collections/BinaryHeap$Entry;", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "equals", "", "other", "", "hashCode", "", "toString", "", "agl-processor"})
    public static final class Entry<K, V>
    implements BinaryHeap.Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return (k != null ? k.hashCode() : 0) * 31 + (v != null ? v.hashCode() : 0);
        }

        public boolean equals(@Nullable Object other) {
            return !(other instanceof BinaryHeap.Entry) ? false : Intrinsics.areEqual(this.getKey(), ((BinaryHeap.Entry)other).getKey()) && Intrinsics.areEqual(this.getValue(), ((BinaryHeap.Entry)other).getValue());
        }

        @NotNull
        public String toString() {
            return this.getKey() + " -> " + this.getValue();
        }
    }
}

