/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.agl.sppt;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.akehurst.language.api.sppt.Sentence;
import net.akehurst.language.api.sppt.SpptDataNode;
import net.akehurst.language.api.sppt.SpptDataNodeInfo;
import net.akehurst.language.api.sppt.SpptWalker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J$\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00052\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lnet/akehurst/language/agl/agl/sppt/SpptWalkerToString;", "Lnet/akehurst/language/api/sppt/SpptWalker;", "sentence", "Lnet/akehurst/language/api/sppt/Sentence;", "indentDelta", "", "(Lnet/akehurst/language/api/sppt/Sentence;Ljava/lang/String;)V", "currentIndent", "getIndentDelta", "()Ljava/lang/String;", "output", "getOutput", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getSentence", "()Lnet/akehurst/language/api/sppt/Sentence;", "beginBranch", "", "nodeInfo", "Lnet/akehurst/language/api/sppt/SpptDataNodeInfo;", "beginEmbedded", "beginTree", "endBranch", "endEmbedded", "endTree", "error", "msg", "path", "Lkotlin/Function0;", "", "Lnet/akehurst/language/api/sppt/SpptDataNode;", "leaf", "skip", "startPosition", "", "nextInputPosition", "agl-processor"})
public final class SpptWalkerToString
implements SpptWalker {
    @NotNull
    private final Sentence sentence;
    @NotNull
    private final String indentDelta;
    @NotNull
    private String currentIndent;
    @NotNull
    private final StringBuilder sb;

    public SpptWalkerToString(@NotNull Sentence sentence, @NotNull String indentDelta) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)indentDelta, (String)"indentDelta");
        this.sentence = sentence;
        this.indentDelta = indentDelta;
        this.currentIndent = "";
        this.sb = new StringBuilder();
    }

    @NotNull
    public final Sentence getSentence() {
        return this.sentence;
    }

    @NotNull
    public final String getIndentDelta() {
        return this.indentDelta;
    }

    @NotNull
    public final String getOutput() {
        String string = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void beginTree() {
    }

    @Override
    public void endTree() {
        this.sb.append("\n");
    }

    @Override
    public void skip(int startPosition, int nextInputPosition) {
        String string = this.sentence.getText().substring(startPosition, nextInputPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String matchedText = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null), (String)"\t", (String)"\u2b72", (boolean)false, (int)4, null);
        this.sb.append(this.currentIndent + "<SKIP> : '" + matchedText + "'\n");
    }

    @Override
    public void leaf(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        int chNum = nodeInfo.getChild().getIndex();
        int siblings = nodeInfo.getChild().getTotal();
        String ind = siblings == 1 ? "" : this.currentIndent;
        String eol = siblings == 1 ? " " : "\n";
        String matchedText = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.sentence.matchedTextNoSkip(nodeInfo.getNode()), (String)"\n", (String)"\u23ce", (boolean)false, (int)4, null), (String)"\t", (String)"\u2b72", (boolean)false, (int)4, null), (String)"'", (String)"\\'", (boolean)false, (int)4, null);
        if (nodeInfo.getNode().getRule().isEmptyTerminal()) {
            this.sb.append(ind + nodeInfo.getNode().getRule().getTag() + eol);
        } else if (nodeInfo.getNode().getRule().isPattern()) {
            this.sb.append(ind + nodeInfo.getNode().getRule().getTag() + " : '" + matchedText + '\'' + eol);
        } else if (Intrinsics.areEqual((Object)('\'' + matchedText + '\''), (Object)nodeInfo.getNode().getRule().getTag())) {
            this.sb.append(ind + '\'' + matchedText + '\'' + eol);
        } else {
            this.sb.append(ind + nodeInfo.getNode().getRule().getTag() + " : '" + matchedText + '\'' + eol);
        }
    }

    @Override
    public void beginBranch(@NotNull SpptDataNodeInfo nodeInfo) {
        String tag;
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        int option = nodeInfo.getAlt().getIndex();
        int total = nodeInfo.getAlt().getTotalMatched();
        int chNum = nodeInfo.getChild().getIndex();
        int siblings = nodeInfo.getChild().getTotal() + (nodeInfo.getAlt().getTotalMatched() - 1);
        int totChildren = nodeInfo.getTotalChildrenFromAllAlternatives() + nodeInfo.getNumSkipChildren();
        String eol = totChildren <= 1 ? " " : "\n";
        String string = tag = nodeInfo.getAlt().getTotalMatched() <= 1 ? nodeInfo.getNode().getRule().getTag() : nodeInfo.getNode().getRule().getTag() + '|' + nodeInfo.getAlt().getOption();
        if (siblings == 1) {
            this.sb.append(tag + " {" + eol);
        } else {
            this.sb.append(this.currentIndent + tag + " {" + eol);
        }
        if (totChildren != 1) {
            this.currentIndent = this.currentIndent + this.indentDelta;
        }
    }

    @Override
    public void endBranch(@NotNull SpptDataNodeInfo nodeInfo) {
        String eol;
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        int chNum = nodeInfo.getChild().getIndex();
        int siblings = nodeInfo.getChild().getTotal() + (nodeInfo.getAlt().getTotalMatched() - 1);
        int totChildren = nodeInfo.getTotalChildrenFromAllAlternatives() + nodeInfo.getNumSkipChildren();
        String string = eol = siblings == 1 ? " " : "\n";
        if (totChildren != 1) {
            String string2 = this.currentIndent.substring(this.indentDelta.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            this.currentIndent = string2;
        }
        String ind = totChildren == 1 ? "" : this.currentIndent;
        this.sb.append(ind + '}' + eol);
    }

    @Override
    public void beginEmbedded(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        String tag = String.valueOf(nodeInfo.getNode().getRule().getTag());
        this.sb.append(this.currentIndent + tag + " : <EMBED>::");
    }

    @Override
    public void endEmbedded(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
    }

    @Override
    public void error(@NotNull String msg, @NotNull Function0<? extends List<? extends SpptDataNode>> path2) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        List p = (List)path2.invoke();
        this.sb.append(this.currentIndent + "Error at " + ((SpptDataNode)CollectionsKt.last((List)p)).getStartPosition() + ": '" + msg + '\'');
        System.out.println((Object)(this.currentIndent + "Error at " + ((SpptDataNode)CollectionsKt.last((List)p)).getStartPosition() + ": '" + msg + '\''));
    }
}

