/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.agl.sppt;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.akehurst.language.agl.agl.sppt.SpptWalkerToInputSentence;
import net.akehurst.language.api.sppt.Sentence;
import net.akehurst.language.api.sppt.SpptDataNode;
import net.akehurst.language.api.sppt.SpptDataNodeInfo;
import net.akehurst.language.api.sppt.SpptWalker;
import net.akehurst.language.collections.MutableStack;
import net.akehurst.language.collections.MutableStackKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/akehurst/language/agl/agl/sppt/SpptWalkerToInputSentence;", "Lnet/akehurst/language/api/sppt/SpptWalker;", "sentence", "Lnet/akehurst/language/api/sppt/Sentence;", "(Lnet/akehurst/language/api/sppt/Sentence;)V", "output", "", "getOutput", "()Ljava/lang/String;", "getSentence", "()Lnet/akehurst/language/api/sppt/Sentence;", "textStack", "Lnet/akehurst/language/collections/MutableStack;", "Lkotlin/Pair;", "", "beginBranch", "", "nodeInfo", "Lnet/akehurst/language/api/sppt/SpptDataNodeInfo;", "beginEmbedded", "beginTree", "endBranch", "endEmbedded", "endTree", "error", "msg", "path", "Lkotlin/Function0;", "", "Lnet/akehurst/language/api/sppt/SpptDataNode;", "leaf", "skip", "startPosition", "nextInputPosition", "agl-processor"})
public final class SpptWalkerToInputSentence
implements SpptWalker {
    @NotNull
    private final Sentence sentence;
    @NotNull
    private final MutableStack<Pair<Integer, String>> textStack;

    public SpptWalkerToInputSentence(@NotNull Sentence sentence) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        this.sentence = sentence;
        this.textStack = MutableStackKt.mutableStackOf(new Pair[0]);
    }

    @NotNull
    public final Sentence getSentence() {
        return this.sentence;
    }

    @NotNull
    public final String getOutput() {
        return CollectionsKt.joinToString$default((Iterable)this.textStack.getElements(), (CharSequence)"", null, null, (int)0, null, (Function1)output.1.INSTANCE, (int)30, null);
    }

    @Override
    public void beginTree() {
    }

    @Override
    public void endTree() {
    }

    @Override
    public void skip(int startPosition, int nextInputPosition) {
        String string = this.sentence.getText().substring(startPosition, nextInputPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String matchedText = string;
        if (this.textStack.isEmpty()) {
            this.textStack.push((Pair<Integer, String>)new Pair((Object)-1, (Object)matchedText));
        } else {
            Pair<Integer, String> p = this.textStack.pop();
            this.textStack.push((Pair<Integer, String>)new Pair(p.getFirst(), (Object)((String)p.getSecond() + matchedText)));
        }
    }

    @Override
    public void leaf(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        String matchedText = this.sentence.matchedTextNoSkip(nodeInfo.getNode());
        this.textStack.push((Pair<Integer, String>)new Pair((Object)nodeInfo.getAlt().getOption(), (Object)matchedText));
    }

    @Override
    public void beginBranch(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
    }

    @Override
    public void endBranch(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        Integer n = nodeInfo.getNumChildrenAlternatives().get(nodeInfo.getAlt().getOption());
        Intrinsics.checkNotNull((Object)n);
        int numChildren = ((Number)n).intValue();
        List chText = CollectionsKt.reversed((Iterable)this.textStack.pop(numChildren));
        String text2 = CollectionsKt.joinToString$default((Iterable)chText, (CharSequence)"", null, null, (int)0, null, (Function1)endBranch.text.1.INSTANCE, (int)30, null);
        this.textStack.push((Pair<Integer, String>)new Pair((Object)nodeInfo.getAlt().getOption(), (Object)text2));
    }

    @Override
    public void beginEmbedded(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this.beginBranch(nodeInfo);
    }

    @Override
    public void endEmbedded(@NotNull SpptDataNodeInfo nodeInfo) {
        Intrinsics.checkNotNullParameter((Object)nodeInfo, (String)"nodeInfo");
        this.endBranch(nodeInfo);
    }

    @Override
    public void error(@NotNull String msg, @NotNull Function0<? extends List<? extends SpptDataNode>> path2) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        List p = (List)path2.invoke();
        String txt = "Error at " + ((SpptDataNode)CollectionsKt.last((List)p)).getStartPosition() + ": '" + msg + '\'';
        this.textStack.push((Pair<Integer, String>)new Pair((Object)-1, (Object)txt));
        System.out.println((Object)txt);
    }
}

