/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.collections;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001aB\u0015\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lnet/akehurst/language/collections/Stack;", "T", "", "items", "", "(Ljava/util/List;)V", "elements", "getElements", "()Ljava/util/List;", "isEmpty", "", "()Z", "getItems", "size", "", "getSize", "()I", "peek", "()Ljava/lang/Object;", "peekOrNull", "pop", "Lnet/akehurst/language/collections/Stack$PopResult;", "push", "item", "(Ljava/lang/Object;)Lnet/akehurst/language/collections/Stack;", "pushAll", "PopResult", "agl-processor"})
public final class Stack<T> {
    @NotNull
    private final List<T> items;

    public Stack(@NotNull List<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.items = items;
    }

    public /* synthetic */ Stack(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final List<T> getItems() {
        return this.items;
    }

    public final int getSize() {
        return this.items.size();
    }

    public final boolean isEmpty() {
        return this.items.size() == 0;
    }

    @NotNull
    public final List<T> getElements() {
        return this.items;
    }

    @NotNull
    public final Stack<T> push(T item) {
        return new Stack<T>(CollectionsKt.plus((Collection)this.items, item));
    }

    @NotNull
    public final Stack<T> pushAll(@NotNull List<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return new Stack<T>(CollectionsKt.plus((Collection)this.items, (Iterable)items));
    }

    public final T peek() {
        return (T)CollectionsKt.last(this.items);
    }

    @Nullable
    public final T peekOrNull() {
        return (T)CollectionsKt.lastOrNull(this.items);
    }

    @NotNull
    public final PopResult<T> pop() {
        return new PopResult<T>(this.peek(), new Stack<T>(this.items.subList(0, this.getSize() - 1)));
    }

    public Stack() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/akehurst/language/collections/Stack$PopResult;", "T", "", "item", "stack", "Lnet/akehurst/language/collections/Stack;", "(Ljava/lang/Object;Lnet/akehurst/language/collections/Stack;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStack", "()Lnet/akehurst/language/collections/Stack;", "agl-processor"})
    public static final class PopResult<T> {
        private final T item;
        @NotNull
        private final Stack<T> stack;

        public PopResult(T item, @NotNull Stack<T> stack) {
            Intrinsics.checkNotNullParameter(stack, (String)"stack");
            this.item = item;
            this.stack = stack;
        }

        public final T getItem() {
            return this.item;
        }

        @NotNull
        public final Stack<T> getStack() {
            return this.stack;
        }
    }
}

