/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.agl.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.akehurst.language.agl.grammar.GrammarRegistryDefault;
import net.akehurst.language.agl.grammar.format.AglFormatGrammar;
import net.akehurst.language.agl.grammar.format.AglFormatSyntaxAnalyser;
import net.akehurst.language.agl.grammar.grammar.AglGrammarGrammar;
import net.akehurst.language.agl.grammar.grammar.AglGrammarSemanticAnalyser;
import net.akehurst.language.agl.grammar.grammar.AglGrammarSyntaxAnalyser;
import net.akehurst.language.agl.grammar.style.AglStyleGrammar;
import net.akehurst.language.agl.grammar.style.AglStyleSyntaxAnalyser;
import net.akehurst.language.agl.processor.AglLanguages;
import net.akehurst.language.agl.processor.LanguageDefinitionDefault;
import net.akehurst.language.agl.processor.LanguageDefinitionFromAsm;
import net.akehurst.language.api.processor.LanguageDefinition;
import net.akehurst.language.api.semanticAnalyser.SemanticAnalyser;
import net.akehurst.language.api.syntaxAnalyser.SyntaxAnalyser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005JH\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lnet/akehurst/language/agl/processor/LanguageRegistry;", "", "()V", "_registry", "", "", "Lnet/akehurst/language/api/processor/LanguageDefinition;", "agl", "Lnet/akehurst/language/agl/processor/AglLanguages;", "getAgl", "()Lnet/akehurst/language/agl/processor/AglLanguages;", "findOrNull", "identity", "findOrPlaceholder", "register", "grammar", "defaultGoalRule", "style", "format", "syntaxAnalyser", "Lnet/akehurst/language/api/syntaxAnalyser/SyntaxAnalyser;", "semanticAnalyser", "Lnet/akehurst/language/api/semanticAnalyser/SemanticAnalyser;", "registerFromDefinition", "definition", "unregister", "", "agl-processor"})
public final class LanguageRegistry {
    @NotNull
    private final Map<String, LanguageDefinition> _registry;
    @NotNull
    private final AglLanguages agl;

    public LanguageRegistry() {
        boolean bl = false;
        this._registry = new LinkedHashMap();
        this.agl = new AglLanguages(this){
            @NotNull
            private final String grammarLanguageIdentity;
            @NotNull
            private final String styleLanguageIdentity;
            @NotNull
            private final String formatLanguageIdentity;
            @NotNull
            private final LanguageDefinition grammar;
            @NotNull
            private final LanguageDefinition style;
            @NotNull
            private final LanguageDefinition format;
            final /* synthetic */ LanguageRegistry this$0;
            {
                this.this$0 = $receiver;
                this.grammarLanguageIdentity = "net.akehurst.language.agl.AglGrammar";
                this.styleLanguageIdentity = "net.akehurst.language.agl.AglStyle";
                this.formatLanguageIdentity = "net.akehurst.language.agl.AglFormat";
                this.grammar = this.this$0.registerFromDefinition(new LanguageDefinitionFromAsm(this.getGrammarLanguageIdentity(), new AglGrammarGrammar(), "grammarDefinition", "'namespace' {\n  foreground: darkgreen;\n  font-style: bold;\n}\n'grammar' {\n  foreground: darkgreen;\n  font-style: bold;\n}\n'extends' {\n  foreground: darkgreen;\n  font-style: bold;\n}\n'override' {\n  foreground: darkgreen;\n  font-style: bold;\n}\n'skip' {\n  foreground: darkgreen;\n  font-style: bold;\n}\n'leaf' {\n  foreground: darkgreen;\n  font-style: bold;\n}\nLITERAL {\n  foreground: blue;\n}\nPATTERN {\n  foreground: darkblue;\n}\nIDENTIFIER {\n  foreground: darkred;\n  font-style: italic;\n}", "", new AglGrammarSyntaxAnalyser(GrammarRegistryDefault.INSTANCE), new AglGrammarSemanticAnalyser()));
                this.style = this.this$0.registerFromDefinition(new LanguageDefinitionFromAsm(this.getStyleLanguageIdentity(), new AglStyleGrammar(), "rules", "META_IDENTIFIER {\n  foreground: orange;\n  font-style: bold;\n}\nIDENTIFIER {\n  foreground: blue;\n  font-style: bold;\n}\nLITERAL {\n  foreground: blue;\n  font-style: bold;\n}\nPATTERN {\n  foreground: darkblue;\n  font-style: bold;\n}\nSTYLE_ID {\n  foreground: darkred;\n  font-style: italic;\n}", "", new AglStyleSyntaxAnalyser(), null));
                this.format = this.this$0.registerFromDefinition(new LanguageDefinitionFromAsm(this.getFormatLanguageIdentity(), new AglFormatGrammar(), "rules", "", "", new AglFormatSyntaxAnalyser(), null));
            }

            @NotNull
            public String getGrammarLanguageIdentity() {
                return this.grammarLanguageIdentity;
            }

            @NotNull
            public String getStyleLanguageIdentity() {
                return this.styleLanguageIdentity;
            }

            @NotNull
            public String getFormatLanguageIdentity() {
                return this.formatLanguageIdentity;
            }

            @NotNull
            public LanguageDefinition getGrammar() {
                return this.grammar;
            }

            @NotNull
            public LanguageDefinition getStyle() {
                return this.style;
            }

            @NotNull
            public LanguageDefinition getFormat() {
                return this.format;
            }
        };
    }

    @NotNull
    public final AglLanguages getAgl() {
        return this.agl;
    }

    @NotNull
    public final LanguageDefinition registerFromDefinition(@NotNull LanguageDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (this._registry.containsKey(definition.getIdentity())) {
            String string = "LanguageDefinition '" + definition.getIdentity() + "' is already registered, please unregister the old one first";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<String, LanguageDefinition> map = this._registry;
        String string = definition.getIdentity();
        boolean bl = false;
        map.put(string, definition);
        return definition;
    }

    @NotNull
    public final LanguageDefinition register(@NotNull String identity, @NotNull String grammar, @Nullable String defaultGoalRule, @Nullable String style, @Nullable String format, @Nullable SyntaxAnalyser syntaxAnalyser, @Nullable SemanticAnalyser semanticAnalyser) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)grammar, (String)"grammar");
        return this.registerFromDefinition(new LanguageDefinitionDefault(identity, grammar, defaultGoalRule, style, format, syntaxAnalyser, semanticAnalyser));
    }

    public final void unregister(@NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        this._registry.remove(identity);
    }

    @Nullable
    public final LanguageDefinition findOrNull(@NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return this._registry.get(identity);
    }

    @NotNull
    public final LanguageDefinition findOrPlaceholder(@NotNull String identity) {
        LanguageDefinition languageDefinition;
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        LanguageDefinition existing = this.findOrNull(identity);
        if (existing == null) {
            LanguageDefinitionDefault placeholder = new LanguageDefinitionDefault(identity, null);
            languageDefinition = this.registerFromDefinition(placeholder);
        } else {
            languageDefinition = existing;
        }
        return languageDefinition;
    }
}

