/*
 * Decompiled with CFR 0.152.
 */
package net.akehurst.language.collections;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000 1*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u00011B-\b\u0016\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB)\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0016\u0010)\u001a\u00020&2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u0006\u0010*\u001a\u00020&J\u0018\u0010+\u001a\u0004\u0018\u00018\u00002\u0006\u0010$\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010,J\u001e\u0010-\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010.\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u00020&2\u0006\u0010$\u001a\u00020\u0004R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lnet/akehurst/language/collections/MapIntTo;", "V", "", "initialCapacityPower", "", "loadFactor", "", "initialiser", "Lkotlin/Function0;", "(IDLkotlin/jvm/functions/Function0;)V", "initialCapacity", "(DILkotlin/jvm/functions/Function0;)V", "_currentCapacity", "_keys", "", "_mask", "_maxBeforeResize", "_size", "_values", "", "[Ljava/lang/Object;", "_zeroIsEmpty", "", "_zeroValue", "Ljava/lang/Object;", "getInitialiser", "()Lkotlin/jvm/functions/Function0;", "<set-?>", "isInitialised", "()Z", "getLoadFactor", "()D", "size", "getSize", "()I", "_calcIndex", "key", "_grow", "", "_growIfNeeded", "_hash", "_initialise", "clear", "get", "(I)Ljava/lang/Object;", "set", "value", "(ILjava/lang/Object;)V", "setToInitialised", "Companion", "agl-processor"})
public final class MapIntTo<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double loadFactor;
    @Nullable
    private final Function0<V> initialiser;
    private boolean isInitialised;
    private int _currentCapacity;
    private int _mask;
    private int _maxBeforeResize;
    private int _size;
    private boolean _zeroIsEmpty;
    @Nullable
    private V _zeroValue;
    @NotNull
    private int[] _keys;
    @NotNull
    private Object[] _values;
    public static final int EMPTY = 0;
    public static final int ZERO = Integer.MAX_VALUE;

    private MapIntTo(double loadFactor, int initialCapacity, Function0<? extends V> initialiser) {
        this.loadFactor = loadFactor;
        this.initialiser = initialiser;
        this._currentCapacity = initialCapacity;
        this._mask = this._currentCapacity - 1;
        this._maxBeforeResize = (int)((double)this._currentCapacity * this.loadFactor);
        this._zeroIsEmpty = true;
        this._keys = new int[this._currentCapacity];
        this._values = new Object[this._currentCapacity];
        if (this.initialiser != null) {
            this._initialise(this.initialiser);
        }
    }

    /* synthetic */ MapIntTo(double d, int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        this(d, n, function0);
    }

    public final double getLoadFactor() {
        return this.loadFactor;
    }

    @Nullable
    public final Function0<V> getInitialiser() {
        return this.initialiser;
    }

    public MapIntTo(int initialCapacityPower, double loadFactor, @Nullable Function0<? extends V> initialiser) {
        double d = 2.0;
        boolean bl = false;
        this(loadFactor, (int)Math.pow(d, initialCapacityPower), initialiser);
    }

    public /* synthetic */ MapIntTo(int n, double d, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 5;
        }
        if ((n2 & 2) != 0) {
            d = 0.75;
        }
        if ((n2 & 4) != 0) {
            function0 = null;
        }
        this(n, d, function0);
    }

    public final boolean isInitialised() {
        return this.isInitialised;
    }

    public final int getSize() {
        return this._size;
    }

    public final void setToInitialised(int key) {
        if (key == 0) {
            this._zeroIsEmpty = false;
        } else {
            this._growIfNeeded();
            int index = this._calcIndex(key);
            this._keys[index] = key;
            MapIntTo mapIntTo = this;
            int n = mapIntTo._size;
            mapIntTo._size = n + 1;
        }
    }

    @Nullable
    public final V get(int key) {
        Object object;
        if (key == 0) {
            object = this._zeroIsEmpty ? null : (Object)this._zeroValue;
        } else {
            int index = this._calcIndex(key);
            object = index < 0 ? null : (this._keys[index] == 0 ? null : this._values[index]);
        }
        return (V)object;
    }

    public final void set(int key, V value) {
        if (key == 0) {
            this._zeroValue = value;
            this._zeroIsEmpty = false;
        } else {
            this._growIfNeeded();
            int index = this._calcIndex(key);
            this._keys[index] = key;
            this._values[index] = value;
            MapIntTo mapIntTo = this;
            int n = mapIntTo._size;
            mapIntTo._size = n + 1;
        }
    }

    public final void clear() {
        this._size = 0;
        this._zeroValue = null;
        this._zeroIsEmpty = true;
        this._keys = new int[this._currentCapacity];
        this._values = new Object[this._currentCapacity];
    }

    private final int _hash(int key) {
        return key & this._mask;
    }

    private final int _calcIndex(int key) {
        int index = this._hash(key);
        int keyIndex = this._keys[index];
        while (keyIndex != key && keyIndex != 0) {
            int n = index;
            if ((index = n + 1) == this._currentCapacity) {
                index = 0;
            }
            keyIndex = this._keys[index];
        }
        return index;
    }

    private final void _initialise(Function0<? extends V> initialiser) {
        this._zeroValue = initialiser.invoke();
        int n = 0;
        int n2 = this._values.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this._values[i] = initialiser.invoke();
            } while (n <= n2);
        }
        this.isInitialised = true;
    }

    private final void _growIfNeeded() {
        if (this._size > this._maxBeforeResize) {
            this._grow();
        }
    }

    private final void _grow() {
        MapIntTo<Object> newMap = new MapIntTo<Object>(this.loadFactor, this._currentCapacity << 2, this.initialiser);
        int n = 0;
        int n2 = this._keys.length + -1;
        if (n <= n2) {
            do {
                int i;
                int key;
                if ((key = this._keys[i = n++]) == 0) continue;
                Object value = this._values[i];
                newMap.set(key, value);
            } while (n <= n2);
        }
        this._currentCapacity = newMap._currentCapacity;
        this._mask = newMap._mask;
        this._maxBeforeResize = newMap._maxBeforeResize;
        this._size = newMap._size;
        this._keys = newMap._keys;
        this._values = newMap._values;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/akehurst/language/collections/MapIntTo$Companion;", "", "()V", "EMPTY", "", "ZERO", "agl-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

